/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class LinkWithEditorAction
extends Action {
    private BrowserView browserView;
    private IPartListener2 editorListener = new IPartListener2(){

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            LinkWithEditorAction.this.linkViewWithEditor(partRef.getPart(false));
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            LinkWithEditorAction.this.linkViewWithEditor(partRef.getPart(false));
        }
    };

    public LinkWithEditorAction(BrowserView browserView) {
        super(Messages.getString("LinkWithEditorAction.LinkWithEditor"), 2);
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/link_with_editor.gif"));
        this.setEnabled(true);
        this.setChecked(BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("browserLinkWithEditor"));
        this.browserView = browserView;
        if (this.isChecked()) {
            browserView.getSite().getWorkbenchWindow().getPartService().addPartListener(this.editorListener);
        }
    }

    public void run() {
        this.setChecked(this.isChecked());
        BrowserUIPlugin.getDefault().getPreferenceStore().setValue("browserLinkWithEditor", this.isChecked());
        if (this.isChecked()) {
            this.browserView.getSite().getWorkbenchWindow().getPartService().addPartListener(this.editorListener);
            IEditorPart activeEditor = this.browserView.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
            this.linkViewWithEditor((IWorkbenchPart)activeEditor);
        } else {
            this.browserView.getSite().getWorkbenchWindow().getPartService().removePartListener(this.editorListener);
        }
    }

    private void linkViewWithEditor(IWorkbenchPart part) {
        if (part != null && this.browserView != null && part.getSite().getWorkbenchWindow() == this.browserView.getSite().getWorkbenchWindow()) {
            IStructuredSelection selection;
            Object objectToSelect = null;
            if (part instanceof IEditorPart) {
                IEditorPart editor = (IEditorPart)part;
                IEditorInput input = editor.getEditorInput();
                if (input != null && input instanceof EntryEditorInput) {
                    EntryEditorInput eei = (EntryEditorInput)input;
                    objectToSelect = eei.getInput();
                } else if (input != null && input instanceof SearchResultEditorInput) {
                    SearchResultEditorInput srei = (SearchResultEditorInput)input;
                    objectToSelect = srei.getSearch();
                }
            }
            if (!(objectToSelect == null || (selection = (IStructuredSelection)this.browserView.getMainWidget().getViewer().getSelection()).size() == 1 && selection.getFirstElement().equals(objectToSelect))) {
                this.browserView.select(objectToSelect);
            }
        }
    }

    public void dispose() {
        if (this.editorListener != null) {
            this.browserView.getSite().getWorkbenchWindow().getPartService().removePartListener(this.editorListener);
            this.editorListener = null;
        }
        this.browserView = null;
    }
}

