/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.EntryEditorUtils;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorConfiguration;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorNavigationLocation;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorOutlinePage;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditorUniversalListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class EntryEditor
extends EditorPart
implements IEntryEditor,
INavigationLocationProvider,
IReusableEditor,
IShowEditorInput {
    protected EntryEditorConfiguration configuration;
    protected EntryEditorActionGroup actionGroup;
    protected EntryEditorWidget mainWidget;
    protected EntryEditorUniversalListener universalListener;
    protected EntryEditorOutlinePage outlinePage;
    IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() != null && (event.getProperty().equals("entryeditorAutoSaveSingleTab") || event.getProperty().equals("entryeditorAutoSaveMultiTab"))) {
                EntryEditor.this.setInput(EntryEditor.this.getEditorInput());
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        BrowserCommonActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        EntryEditorInput eei = this.getEntryEditorInput();
        this.setEntryEditorWidgetInput(eei);
        this.setEditorName(eei);
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, BrowserUIConstants.PLUGIN_ID + "." + "tools_table_entry_editor");
        this.configuration = new EntryEditorConfiguration(this);
        this.mainWidget = new EntryEditorWidget((EntryEditorWidgetConfiguration)this.configuration);
        this.mainWidget.createWidget(composite);
        this.actionGroup = new EntryEditorActionGroup(this);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.enableGlobalActionHandlers(this.getEditorSite().getActionBars());
        this.actionGroup.fillContextMenu(this.mainWidget.getContextMenuManager());
        this.getSite().setSelectionProvider((ISelectionProvider)this.mainWidget.getViewer());
        this.universalListener = new EntryEditorUniversalListener(this);
        this.setInput(this.getEditorInput());
    }

    public void setFocus() {
        this.mainWidget.setFocus();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = new EntryEditorOutlinePage(this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        if (this.configuration != null) {
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            this.getSite().setSelectionProvider(null);
            BrowserCommonActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isAutoSave()) {
            EntryEditorInput eei = this.getEntryEditorInput();
            eei.saveSharedWorkingCopy(true, this);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getEntryEditorInput().isSharedWorkingCopyDirty(this);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public EntryEditorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public EntryEditorConfiguration getConfiguration() {
        return this.configuration;
    }

    public EntryEditorWidget getMainWidget() {
        return this.mainWidget;
    }

    public EntryEditorOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    public EntryEditorUniversalListener getUniversalListener() {
        return this.universalListener;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new EntryEditorNavigationLocation(this);
    }

    protected void setEditorName(EntryEditorInput input) {
        this.setPartName(input.getName());
    }

    @Override
    public boolean canHandle(IEntry entry) {
        return true;
    }

    @Override
    public EntryEditorInput getEntryEditorInput() {
        return EntryEditorUtils.getEntryEditorInput(this.getEditorInput());
    }

    @Override
    public void workingCopyModified(Object source) {
        if (this.mainWidget != null && !this.mainWidget.getViewer().isCellEditorActive()) {
            ISelection selection = this.mainWidget.getViewer().getSelection();
            this.mainWidget.getViewer().refresh();
            this.mainWidget.getViewer().setSelection(selection);
        }
        if (!this.isAutoSave()) {
            this.firePropertyChange(257);
        }
    }

    private void setEntryEditorWidgetInput(EntryEditorInput eei) {
        if (this.mainWidget != null) {
            this.universalListener.setInput(eei.getSharedWorkingCopy(this));
            this.mainWidget.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void showEditorInput(IEditorInput input) {
        if (input instanceof EntryEditorInput) {
            if (this.isDirty() && !EntryEditorUtils.askSaveSharedWorkingCopyBeforeInputChange(this)) {
                return;
            }
            EntryEditorInput eei = (EntryEditorInput)input;
            IEntry entry = eei.getEntryInput();
            ISearchResult searchResult = eei.getSearchResultInput();
            IBookmark bookmark = eei.getBookmarkInput();
            EntryEditorInput dummyInput = entry != null ? new EntryEditorInput(entry, null) : (searchResult != null ? new EntryEditorInput(searchResult, null) : new EntryEditorInput(bookmark, null));
            this.setInput(dummyInput);
            this.firePropertyChange(258);
            this.setInput(input);
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
        }
    }
}

