/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyAttributeDescriptionAction
extends BrowserAction {
    public void run() {
        StringBuffer text = new StringBuffer();
        Iterator iterator = this.getAttributeNameSet().iterator();
        while (iterator.hasNext()) {
            text.append(iterator.next());
            if (!iterator.hasNext()) continue;
            text.append(BrowserCoreConstants.LINE_SEPARATOR);
        }
        if (text.length() > 0) {
            CopyAction.copyToClipboard((Object[])new Object[]{text.toString()}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private Set getAttributeNameSet() {
        int i;
        LinkedHashSet<String> attributeNameSet = new LinkedHashSet<String>();
        for (i = 0; i < this.getSelectedAttributeHierarchies().length; ++i) {
            for (IAttribute att : this.getSelectedAttributeHierarchies()[i]) {
                attributeNameSet.add(att.getDescription());
            }
        }
        for (i = 0; i < this.getSelectedAttributes().length; ++i) {
            attributeNameSet.add(this.getSelectedAttributes()[i].getDescription());
        }
        for (i = 0; i < this.getSelectedValues().length; ++i) {
            attributeNameSet.add(this.getSelectedValues()[i].getAttribute().getDescription());
        }
        return attributeNameSet;
    }

    public String getText() {
        if (this.getAttributeNameSet().size() > 1) {
            return Messages.getString("CopyAttributeDescriptionAction.CopyAttributeDescriptions");
        }
        return Messages.getString("CopyAttributeDescriptionAction.CopyAttributeDescription");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_att.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getAttributeNameSet().size() > 0;
    }
}

