/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.entryeditors;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgressAdapter;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenEntryEditorRunnable
extends StudioConnectionRunnableWithProgressAdapter
implements StudioConnectionBulkRunnableWithProgress {
    private IEntry[] entries;
    private ISearchResult[] searchResults;
    private IBookmark[] bookmarks;
    private EntryEditorExtension extension;

    public OpenEntryEditorRunnable(IEntry[] entries, ISearchResult[] searchResults, IBookmark[] bookmarks) {
        this.entries = entries;
        this.searchResults = searchResults;
        this.bookmarks = bookmarks;
    }

    public OpenEntryEditorRunnable(EntryEditorExtension extension, IEntry[] entries, ISearchResult[] searchResults, IBookmark[] bookmarks) {
        this.extension = extension;
        this.entries = entries;
        this.searchResults = searchResults;
        this.bookmarks = bookmarks;
    }

    public String getName() {
        return Messages.getString("OpenEntryEditorRunnable.OpenEntryEditor");
    }

    public Object[] getLockedObjects() {
        if (this.entries.length == 1) {
            return new Object[]{this.entries[0]};
        }
        if (this.searchResults.length == 1) {
            return new Object[]{this.searchResults[0].getEntry()};
        }
        if (this.bookmarks.length == 1) {
            return new Object[]{this.bookmarks[0].getEntry()};
        }
        return new Object[0];
    }

    public Connection[] getConnections() {
        if (this.entries.length == 1) {
            return new Connection[]{this.entries[0].getBrowserConnection().getConnection()};
        }
        if (this.searchResults.length == 1) {
            return new Connection[]{this.searchResults[0].getEntry().getBrowserConnection().getConnection()};
        }
        if (this.bookmarks.length == 1) {
            return new Connection[]{this.bookmarks[0].getEntry().getBrowserConnection().getConnection()};
        }
        return new Connection[0];
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.setTaskName(Messages.getString("OpenEntryEditorRunnable.OpeningEntryEditor"));
        IEntry entry = null;
        if (this.entries.length == 1) {
            entry = this.entries[0];
        } else if (this.searchResults.length == 1) {
            entry = this.searchResults[0].getEntry();
        } else if (this.bookmarks.length == 1) {
            entry = this.bookmarks[0].getEntry();
        }
        if (entry != null) {
            if (entry instanceof IContinuation) {
                IContinuation continuation = (IContinuation)entry;
                if (continuation.getState() == IContinuation.State.UNRESOLVED) {
                    continuation.resolve();
                }
            } else if (!entry.isAttributesInitialized()) {
                InitializeAttributesRunnable.initializeAttributes((IEntry)entry, (StudioProgressMonitor)monitor);
            }
        }
        if (this.extension == null) {
            for (EntryEditorExtension entryEditorExtension : BrowserUIPlugin.getDefault().getEntryEditorManager().getSortedEntryEditorExtensions()) {
                if (!entryEditorExtension.getEditorInstance().canHandle(entry)) continue;
                this.extension = entryEditorExtension;
                break;
            }
        }
        final String editorId = this.extension.getEditorId();
        final EntryEditorInput editorInput = this.entries.length == 1 ? new EntryEditorInput(this.entries[0], this.extension) : (this.searchResults.length == 1 ? new EntryEditorInput(this.searchResults[0], this.extension) : (this.bookmarks.length == 1 ? new EntryEditorInput(this.bookmarks[0], this.extension) : new EntryEditorInput((IEntry)null, this.extension)));
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorId, false);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void runNotification(StudioProgressMonitor monitor) {
    }
}

