/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.entryeditors;

import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.IEntryEditor;
import org.apache.directory.studio.entryeditors.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class EntryEditorInput
implements IEditorInput {
    private IEntry entry;
    private ISearchResult searchResult;
    private IBookmark bookmark;
    private EntryEditorExtension extension;

    public EntryEditorInput(IEntry entry, EntryEditorExtension extension) {
        this(entry, null, null, extension);
    }

    public EntryEditorInput(ISearchResult searchResult, EntryEditorExtension extension) {
        this(null, searchResult, null, extension);
    }

    public EntryEditorInput(IBookmark bookmark, EntryEditorExtension extension) {
        this(null, null, bookmark, extension);
    }

    private EntryEditorInput(IEntry entry, ISearchResult searchResult, IBookmark bookmark, EntryEditorExtension extension) {
        this.entry = entry;
        this.searchResult = searchResult;
        this.bookmark = bookmark;
        this.extension = extension;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.extension.getIcon();
    }

    public String getName() {
        IEntry entry = this.getResolvedEntry();
        if (entry != null) {
            if (entry instanceof RootDSE) {
                return Messages.getString("EntryEditorNavigationLocation.RootDSE");
            }
            return entry.getDn().getName();
        }
        return Messages.getString("EntryEditorInput.NoEntrySelected");
    }

    public String getToolTipText() {
        IEntry entry = this.getResolvedEntry();
        if (entry != null) {
            IBrowserConnection connection = entry.getBrowserConnection();
            if (connection != null && connection.getConnection() != null) {
                return this.getName() + " - " + connection.getConnection().getName();
            }
            return this.getName();
        }
        return Messages.getString("EntryEditorInput.NoEntrySelected");
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public EntryEditorExtension getExtension() {
        return this.extension;
    }

    public IEntry getResolvedEntry() {
        Object resolvedEntry = this.entry != null ? this.entry : (this.searchResult != null ? this.searchResult.getEntry() : (this.bookmark != null ? this.bookmark.getEntry() : null));
        if (resolvedEntry != null) {
            resolvedEntry = resolvedEntry.getBrowserConnection().getEntryFromCache(resolvedEntry.getDn());
        }
        return resolvedEntry;
    }

    public IEntry getSharedWorkingCopy(IEntryEditor editor) {
        IEntry resolvedEntry = this.getResolvedEntry();
        if (resolvedEntry != null) {
            return BrowserUIPlugin.getDefault().getEntryEditorManager().getSharedWorkingCopy(resolvedEntry, editor);
        }
        return null;
    }

    public boolean isSharedWorkingCopyDirty(IEntryEditor editor) {
        boolean dirty = BrowserUIPlugin.getDefault().getEntryEditorManager().isSharedWorkingCopyDirty(this.getResolvedEntry(), editor);
        return dirty;
    }

    public IStatus saveSharedWorkingCopy(boolean handleError, IEntryEditor editor) {
        IStatus status = BrowserUIPlugin.getDefault().getEntryEditorManager().saveSharedWorkingCopy(this.getResolvedEntry(), handleError, editor);
        return status;
    }

    public void resetSharedWorkingCopy(IEntryEditor editor) {
        BrowserUIPlugin.getDefault().getEntryEditorManager().resetSharedWorkingCopy(this.getResolvedEntry(), editor);
    }

    public IEntry getEntryInput() {
        return this.entry;
    }

    public ISearchResult getSearchResultInput() {
        return this.searchResult;
    }

    public IBookmark getBookmarkInput() {
        return this.bookmark;
    }

    public Object getInput() {
        if (this.entry != null) {
            return this.entry;
        }
        if (this.searchResult != null) {
            return this.searchResult;
        }
        if (this.bookmark != null) {
            return this.bookmark;
        }
        return null;
    }

    public int hashCode() {
        if (this.extension == null) {
            return 0;
        }
        if (this.extension.isMultiWindow()) {
            return this.getResolvedEntry() == null ? 0 : this.getResolvedEntry().getDn().hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntryEditorInput)) {
            return false;
        }
        EntryEditorInput other = (EntryEditorInput)obj;
        if (this.extension == null && other.extension == null) {
            return true;
        }
        if (this.getExtension() != other.getExtension()) {
            return false;
        }
        if (this.getInput() == null && other.getInput() == null) {
            return true;
        }
        if (this.getInput() == null || other.getInput() == null) {
            return false;
        }
        return other.getInput().equals(this.getInput());
    }
}

