/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.wizards;

import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.NonExistingServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.model.AbstractServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v150.ServerXmlIOV150;
import org.apache.directory.studio.apacheds.configuration.model.v151.ServerXmlIOV151;
import org.apache.directory.studio.apacheds.configuration.model.v152.ServerXmlIOV152;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerXmlIOV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerXmlIOV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerXmlIOV155;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerXmlIOV156;
import org.apache.directory.studio.apacheds.configuration.model.v157.ServerXmlIOV157;
import org.apache.directory.studio.apacheds.configuration.wizards.Messages;
import org.apache.directory.studio.apacheds.configuration.wizards.NewApacheDSConfigurationFileWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewApacheDSConfigurationFileWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow window;
    private NewApacheDSConfigurationFileWizardPage page;

    public void addPages() {
        this.page = new NewApacheDSConfigurationFileWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            ServerConfiguration serverConfiguration = null;
            AbstractServerXmlIO serverXmlIO = null;
            switch (this.page.getTargetVersion()) {
                case VERSION_1_5_7: {
                    serverXmlIO = new ServerXmlIOV157();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.7.xml"));
                    break;
                }
                case VERSION_1_5_6: {
                    serverXmlIO = new ServerXmlIOV156();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.6.xml"));
                    break;
                }
                case VERSION_1_5_5: {
                    serverXmlIO = new ServerXmlIOV155();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.5.xml"));
                    break;
                }
                case VERSION_1_5_4: {
                    serverXmlIO = new ServerXmlIOV154();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.4.xml"));
                    break;
                }
                case VERSION_1_5_3: {
                    serverXmlIO = new ServerXmlIOV153();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.3.xml"));
                    break;
                }
                case VERSION_1_5_2: {
                    serverXmlIO = new ServerXmlIOV152();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.2.xml"));
                    break;
                }
                case VERSION_1_5_1: {
                    serverXmlIO = new ServerXmlIOV151();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.1.xml"));
                    break;
                }
                case VERSION_1_5_0: {
                    serverXmlIO = new ServerXmlIOV150();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.0.xml"));
                    break;
                }
                default: {
                    serverXmlIO = new ServerXmlIOV156();
                    serverConfiguration = serverXmlIO.parse(ApacheDSConfigurationPlugin.class.getResourceAsStream("default-server-1.5.6.xml"));
                }
            }
            IWorkbenchPage page = this.window.getActivePage();
            page.openEditor((IEditorInput)new NonExistingServerConfigurationInput(serverConfiguration), ServerConfigurationEditor.ID);
        }
        catch (PartInitException e) {
            return false;
        }
        catch (ServerXmlIOException e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("NewApacheDSConfigurationFileWizard.Error"), (String)(Messages.getString("NewApacheDSConfigurationFileWizard.ErrorReadingFile") + e.getMessage()));
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.window = workbench.getActiveWorkbenchWindow();
    }
}

