/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v152.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.model.v152.ExtendedOperationEnum;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ExtendedOperationDialog
extends Dialog {
    private List<ExtendedOperationEnum> initialExtendedOperations;
    private List<ExtendedOperationEnum> availableExtendedOperations;
    private ExtendedOperationEnum selectedExtendedOperation;
    private Table extendedOperationsTable;
    private TableViewer extendedOperationsTableViewer;
    private Button addButton;

    public ExtendedOperationDialog(List<ExtendedOperationEnum> extendedOperations) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.initialExtendedOperations = extendedOperations;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add An Extended Operation");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label chooseLabel = new Label(composite, 0);
        chooseLabel.setText("Choose an extended operation:");
        chooseLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.extendedOperationsTable = new Table(composite, 101124);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 148;
        gridData.minimumHeight = 148;
        gridData.widthHint = 350;
        gridData.minimumWidth = 350;
        this.extendedOperationsTable.setLayoutData((Object)gridData);
        this.extendedOperationsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ExtendedOperationDialog.this.extendedOperationsTable.getSelectionIndex() != -1) {
                    ExtendedOperationDialog.this.okPressed();
                }
            }
        });
        this.extendedOperationsTableViewer = new TableViewer(this.extendedOperationsTable);
        this.extendedOperationsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extendedOperationsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ApacheDSConfigurationPlugin.getDefault().getImage("resources/icons/extended_operation.gif");
            }

            public String getText(Object element) {
                if (element instanceof ExtendedOperationEnum) {
                    return ((ExtendedOperationEnum)((Object)element)).getName();
                }
                return super.getText(element);
            }
        });
        this.extendedOperationsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)ExtendedOperationDialog.this.extendedOperationsTableViewer.getSelection();
                if (selection.isEmpty()) {
                    if (ExtendedOperationDialog.this.addButton != null && !ExtendedOperationDialog.this.addButton.isDisposed()) {
                        ExtendedOperationDialog.this.addButton.setEnabled(false);
                    }
                } else if (ExtendedOperationDialog.this.addButton != null && !ExtendedOperationDialog.this.addButton.isDisposed()) {
                    ExtendedOperationDialog.this.addButton.setEnabled(true);
                }
            }
        });
        this.initFromInput();
        return composite;
    }

    private void initFromInput() {
        this.availableExtendedOperations = new ArrayList<ExtendedOperationEnum>();
        if (!this.initialExtendedOperations.contains((Object)ExtendedOperationEnum.START_TLS)) {
            this.availableExtendedOperations.add(ExtendedOperationEnum.START_TLS);
        }
        if (!this.initialExtendedOperations.contains((Object)ExtendedOperationEnum.GRACEFUL_SHUTDOWN)) {
            this.availableExtendedOperations.add(ExtendedOperationEnum.GRACEFUL_SHUTDOWN);
        }
        if (!this.initialExtendedOperations.contains((Object)ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI)) {
            this.availableExtendedOperations.add(ExtendedOperationEnum.LAUNCH_DIAGNOSTIC_UI);
        }
        this.extendedOperationsTableViewer.setInput(this.availableExtendedOperations);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, "Add", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.addButton.setEnabled(false);
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.extendedOperationsTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.selectedExtendedOperation = (ExtendedOperationEnum)((Object)selection.getFirstElement());
        }
        super.okPressed();
    }

    public ExtendedOperationEnum getExtendedOperation() {
        return this.selectedExtendedOperation;
    }
}

