/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsImportException;
import org.apache.directory.studio.schemaeditor.model.io.ProjectsImporter;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.wizards.ImportProjectsWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportProjectsWizard
extends Wizard
implements IImportWizard {
    private ImportProjectsWizardPage page;
    private ProjectsHandler projectsHandler;

    public void addPages() {
        this.page = new ImportProjectsWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        final File[] selectedProjectFiles = this.page.getSelectedProjectFiles();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString("ImportProjectsWizard.ImportingProjects"), selectedProjectFiles.length);
                    for (File projectFile : selectedProjectFiles) {
                        monitor.subTask(projectFile.getName());
                        try {
                            Project project = ProjectsImporter.getProject(new FileInputStream(projectFile), projectFile.getAbsolutePath());
                            if (ImportProjectsWizard.this.projectsHandler.isProjectNameAlreadyTaken(project.getName())) {
                                PluginUtils.logError(NLS.bind((String)Messages.getString("ImportProjectsWizard.ErrorImportingProject"), (Object[])new String[]{project.getName()}), null);
                                ViewUtils.displayErrorMessageDialog(Messages.getString("ImportProjectsWizard.ImportError"), NLS.bind((String)(Messages.getString("ImportProjectsWizard.ErrorImportingProject") + "\n" + Messages.getString("ImportProjectsWizard.ErrorProjectNameExists")), (Object[])new String[]{project.getName()}));
                            } else {
                                ImportProjectsWizard.this.projectsHandler.addProject(project);
                            }
                        }
                        catch (ProjectsImportException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ImportProjectsWizard.ErrorImportingProject"), (Object[])new String[]{projectFile.getName()}), e);
                            ViewUtils.displayErrorMessageDialog(Messages.getString("ImportProjectsWizard.ImportError"), NLS.bind((String)Messages.getString("ImportProjectsWizard.ErrorImportingProject"), (Object[])new String[]{projectFile.getName()}));
                        }
                        catch (FileNotFoundException e) {
                            PluginUtils.logError(NLS.bind((String)Messages.getString("ImportProjectsWizard.ErrorImportingProject"), (Object[])new String[]{projectFile.getName()}), e);
                            ViewUtils.displayErrorMessageDialog(Messages.getString("ImportProjectsWizard.ImportError"), NLS.bind((String)Messages.getString("ImportProjectsWizard.ErrorImportingProject"), (Object[])new String[]{projectFile.getName()}));
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
    }
}

