/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SearchViewController;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.search.SearchPage;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.views.SearchViewContentProvider;
import org.apache.directory.studio.schemaeditor.view.views.SearchViewLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SearchView
extends ViewPart {
    public static final String ID = PluginConstants.VIEW_SEARCH_VIEW_ID;
    private String searchString;
    private Text searchField;
    private Button searchButton;
    private Label searchResultsLabel;
    private Table resultsTable;
    private TableViewer resultsTableViewer;
    private Composite searchFieldComposite;
    private Composite searchFieldInnerComposite;
    private Label separatorLabel;
    private Composite parent;

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PluginConstants.PLUGIN_ID + "." + "search_view");
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.searchFieldComposite = new Composite(parent, 0);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        this.searchFieldComposite.setLayout((Layout)gridLayout);
        this.searchFieldComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label searchFieldCompositeSeparator = new Label(this.searchFieldComposite, 258);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.heightHint = 1;
        searchFieldCompositeSeparator.setLayoutData((Object)gridData);
        searchFieldCompositeSeparator.setVisible(false);
        this.searchResultsLabel = new Label(parent, 0);
        this.searchResultsLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label separatorLabel2 = new Label(parent, 258);
        separatorLabel2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createTableViewer();
        this.setSearchResultsLabel(null, 0);
        new SearchViewController(this);
    }

    private void createSearchField() {
        this.searchFieldInnerComposite = new Composite(this.searchFieldComposite, 0);
        GridLayout searchFieldInnerCompositeGridLayout = new GridLayout(4, false);
        searchFieldInnerCompositeGridLayout.horizontalSpacing = 1;
        searchFieldInnerCompositeGridLayout.verticalSpacing = 1;
        searchFieldInnerCompositeGridLayout.marginHeight = 1;
        searchFieldInnerCompositeGridLayout.marginWidth = 2;
        this.searchFieldInnerComposite.setLayout((Layout)searchFieldInnerCompositeGridLayout);
        this.searchFieldInnerComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label searchFieldLabel = new Label(this.searchFieldInnerComposite, 0);
        searchFieldLabel.setText(Messages.getString("SearchView.SearchColon"));
        searchFieldLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.searchField = new Text(this.searchFieldInnerComposite, 2432);
        if (this.searchString != null) {
            this.searchField.setText(this.searchString);
        }
        this.searchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchView.this.validateSearchField();
            }
        });
        this.searchField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SearchView.this.resultsTable.setFocus();
                } else if (e.keyCode == Action.findKeyCode((String)"RETURN") || e.keyCode == 0x1000050) {
                    SearchView.this.search();
                }
            }
        });
        final ToolBar searchToolBar = new ToolBar(this.searchFieldInnerComposite, 0x800100);
        final ToolItem searchInToolItem = new ToolItem(searchToolBar, 4);
        searchInToolItem.setText(Messages.getString("SearchView.SearchIn"));
        searchInToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = searchInToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = searchToolBar.toDisplay(pt);
                Menu menu = SearchView.this.createSearchInMenu();
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        new ToolItem(searchToolBar, 2);
        final ToolItem scopeToolItem = new ToolItem(searchToolBar, 4);
        scopeToolItem.setText(Messages.getString("SearchView.Scope"));
        scopeToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = scopeToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = searchToolBar.toDisplay(pt);
                Menu menu = SearchView.this.createScopeMenu();
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        searchToolBar.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.searchButton = new Button(this.searchFieldInnerComposite, 1032);
        this.searchButton.setEnabled(false);
        this.searchButton.setImage(Activator.getDefault().getImage("resources/icons/search.gif"));
        this.searchButton.setToolTipText(Messages.getString("SearchView.Search"));
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.search();
            }
        });
        this.searchButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.separatorLabel = new Label(this.searchFieldComposite, 258);
        this.separatorLabel.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    public Menu createSearchInMenu() {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Menu searchInMenu = new Menu((Decorations)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
        final MenuItem aliasesMenuItem = new MenuItem(searchInMenu, 32);
        aliasesMenuItem.setText(Messages.getString("SearchView.Aliases"));
        aliasesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES, aliasesMenuItem.getSelection());
            }
        });
        final MenuItem oidMenuItem = new MenuItem(searchInMenu, 32);
        oidMenuItem.setText(Messages.getString("SearchView.OID"));
        oidMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID, oidMenuItem.getSelection());
            }
        });
        final MenuItem descriptionMenuItem = new MenuItem(searchInMenu, 32);
        descriptionMenuItem.setText(Messages.getString("SearchView.Description"));
        descriptionMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION, descriptionMenuItem.getSelection());
            }
        });
        new MenuItem(searchInMenu, 2);
        final MenuItem superiorMenuItem = new MenuItem(searchInMenu, 32);
        superiorMenuItem.setText(Messages.getString("SearchView.Superior"));
        superiorMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIOR, superiorMenuItem.getSelection());
            }
        });
        final MenuItem syntaxMenuItem = new MenuItem(searchInMenu, 32);
        syntaxMenuItem.setText(Messages.getString("SearchView.Syntax"));
        syntaxMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SYNTAX, syntaxMenuItem.getSelection());
            }
        });
        final MenuItem matchingRulesMenuItem = new MenuItem(searchInMenu, 32);
        matchingRulesMenuItem.setText(Messages.getString("SearchView.MatchingRules"));
        matchingRulesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MATCHING_RULES, matchingRulesMenuItem.getSelection());
            }
        });
        new MenuItem(searchInMenu, 2);
        final MenuItem superiorsMenuItem = new MenuItem(searchInMenu, 32);
        superiorsMenuItem.setText(Messages.getString("SearchView.Superiors"));
        superiorsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIORS, superiorsMenuItem.getSelection());
            }
        });
        final MenuItem mandatoryAttributesMenuItem = new MenuItem(searchInMenu, 32);
        mandatoryAttributesMenuItem.setText(Messages.getString("SearchView.MandatoryAttributes"));
        mandatoryAttributesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MANDATORY_ATTRIBUTES, mandatoryAttributesMenuItem.getSelection());
            }
        });
        final MenuItem optionalAttributesMenuItem = new MenuItem(searchInMenu, 32);
        optionalAttributesMenuItem.setText(Messages.getString("SearchView.OptionalAttributes"));
        optionalAttributesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OPTIONAL_ATTRIBUTES, optionalAttributesMenuItem.getSelection());
            }
        });
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES) == null) {
            aliasesMenuItem.setSelection(true);
        } else {
            aliasesMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES));
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID) == null) {
            oidMenuItem.setSelection(true);
        } else {
            oidMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID));
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION) == null) {
            descriptionMenuItem.setSelection(true);
        } else {
            descriptionMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION));
        }
        superiorMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIOR));
        syntaxMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SYNTAX));
        matchingRulesMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MATCHING_RULES));
        superiorsMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIORS));
        mandatoryAttributesMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MANDATORY_ATTRIBUTES));
        optionalAttributesMenuItem.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OPTIONAL_ATTRIBUTES));
        return searchInMenu;
    }

    public Menu createScopeMenu() {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Menu scopeMenu = new Menu((Decorations)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
        MenuItem attributeTypesAndObjectClassesMenuItem = new MenuItem(scopeMenu, 16);
        attributeTypesAndObjectClassesMenuItem.setText(Messages.getString("SearchView.TypesAndClasses"));
        attributeTypesAndObjectClassesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SCOPE, 0);
            }
        });
        MenuItem attributesTypesOnlyMenuItem = new MenuItem(scopeMenu, 16);
        attributesTypesOnlyMenuItem.setText(Messages.getString("SearchView.TypesOnly"));
        attributesTypesOnlyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SCOPE, 1);
            }
        });
        MenuItem objectClassesMenuItem = new MenuItem(scopeMenu, 16);
        objectClassesMenuItem.setText(Messages.getString("SearchView.ClassesOnly"));
        objectClassesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.put(PluginConstants.PREFS_SEARCH_PAGE_SCOPE, 2);
            }
        });
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SCOPE) == null) {
            attributeTypesAndObjectClassesMenuItem.setSelection(true);
        } else {
            switch (settings.getInt(PluginConstants.PREFS_SEARCH_PAGE_SCOPE)) {
                case 0: {
                    attributeTypesAndObjectClassesMenuItem.setSelection(true);
                    break;
                }
                case 1: {
                    attributesTypesOnlyMenuItem.setSelection(true);
                    break;
                }
                case 2: {
                    objectClassesMenuItem.setSelection(true);
                }
            }
        }
        return scopeMenu;
    }

    private void createTableViewer() {
        this.resultsTable = new Table(this.parent, 99076);
        GridData gridData = new GridData(4, 4, true, true);
        this.resultsTable.setLayoutData((Object)gridData);
        this.resultsTable.setLinesVisible(true);
        this.resultsTableViewer = new TableViewer(this.resultsTable);
        this.resultsTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new SearchViewLabelProvider(), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.resultsTableViewer.setContentProvider((IContentProvider)new SearchViewContentProvider());
        this.resultsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == Action.findKeyCode((String)"RETURN") || e.keyCode == 0x1000050) {
                    SearchView.this.openEditor();
                }
            }
        });
        this.resultsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SearchView.this.openEditor();
            }
        });
    }

    private void openEditor() {
        StructuredSelection selection;
        if (Activator.getDefault().getSchemaHandler() != null && !(selection = (StructuredSelection)this.resultsTableViewer.getSelection()).isEmpty()) {
            Object item = selection.getFirstElement();
            Object input = null;
            String editorId = null;
            if (item instanceof AttributeType) {
                input = new AttributeTypeEditorInput((AttributeType)item);
                editorId = AttributeTypeEditor.ID;
            } else if (item instanceof ObjectClass) {
                input = new ObjectClassEditorInput((ObjectClass)((MutableObjectClass)item));
                editorId = ObjectClassEditor.ID;
            }
            if (input != null) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException exception) {
                    PluginUtils.logError(Messages.getString("SearchView.ErrorOpeningEditor"), exception);
                    ViewUtils.displayErrorMessageDialog(Messages.getString("SearchView.Error"), Messages.getString("SearchView.ErrorOpeningEditor"));
                }
            }
        }
    }

    public void setFocus() {
        if (this.searchField != null && !this.searchField.isDisposed()) {
            this.searchField.setFocus();
        } else {
            this.resultsTable.setFocus();
        }
    }

    public void showSearchFieldSection() {
        this.createSearchField();
        this.parent.layout(true, true);
        this.searchField.setFocus();
        this.validateSearchField();
    }

    public void hideSearchFieldSection() {
        if (this.searchFieldInnerComposite != null) {
            this.searchFieldInnerComposite.dispose();
            this.searchFieldInnerComposite = null;
        }
        if (this.separatorLabel != null) {
            this.separatorLabel.dispose();
            this.separatorLabel = null;
        }
        this.parent.layout(true, true);
        this.resultsTable.setFocus();
    }

    private void validateSearchField() {
        this.searchButton.setEnabled(this.searchField.getText().length() > 0);
    }

    public void setSearchInput(String searchString, SearchPage.SearchInEnum[] searchIn, int scope) {
        this.searchString = searchString;
        SearchPage.addSearchStringHistory(searchString);
        SearchPage.saveSearchScope(Arrays.asList(searchIn));
        if (this.searchField != null && !this.searchField.isDisposed()) {
            this.searchField.setText(searchString);
            this.validateSearchField();
        }
        List<SchemaObject> results = this.search(searchString, searchIn, scope);
        this.setSearchResultsLabel(searchString, results.size());
        this.resultsTableViewer.setInput(results);
    }

    private List<SchemaObject> search(String searchString, SearchPage.SearchInEnum[] searchIn, int scope) {
        ArrayList<SchemaObject> searchResults = new ArrayList<SchemaObject>();
        if (searchString != null) {
            String computedSearchString = searchString.replaceAll("\\*", "[\\\\S]*");
            computedSearchString = computedSearchString.replaceAll("\\?", "[\\\\S]");
            Pattern pattern = Pattern.compile(computedSearchString, 2);
            SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
            if (schemaHandler != null) {
                ArrayList<SearchPage.SearchInEnum> searchScope = new ArrayList<SearchPage.SearchInEnum>(Arrays.asList(searchIn));
                if (scope == 0 || scope == 1) {
                    List<AttributeType> attributeTypes = schemaHandler.getAttributeTypes();
                    for (AttributeType at : attributeTypes) {
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.ALIASES) && this.checkList(pattern, at.getNames())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.OID) && this.checkString(pattern, at.getOid())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.DESCRIPTION) && this.checkString(pattern, at.getDescription())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.SUPERIOR) && this.checkString(pattern, at.getSuperiorOid())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.SYNTAX) && this.checkString(pattern, at.getSyntaxOid())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (!searchScope.contains((Object)SearchPage.SearchInEnum.MATCHING_RULES)) continue;
                        if (this.checkString(pattern, at.getEqualityOid())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (this.checkString(pattern, at.getOrderingOid())) {
                            searchResults.add((SchemaObject)at);
                            continue;
                        }
                        if (!this.checkString(pattern, at.getSubstringOid())) continue;
                        searchResults.add((SchemaObject)at);
                    }
                }
                if (scope == 0 || scope == 2) {
                    List<ObjectClass> objectClasses = schemaHandler.getObjectClasses();
                    for (ObjectClass oc : objectClasses) {
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.ALIASES) && this.checkList(pattern, oc.getNames())) {
                            searchResults.add((SchemaObject)oc);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.OID) && this.checkString(pattern, oc.getOid())) {
                            searchResults.add((SchemaObject)oc);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.DESCRIPTION) && this.checkString(pattern, oc.getDescription())) {
                            searchResults.add((SchemaObject)oc);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.SUPERIORS) && this.checkList(pattern, oc.getSuperiorOids())) {
                            searchResults.add((SchemaObject)oc);
                            continue;
                        }
                        if (searchScope.contains((Object)SearchPage.SearchInEnum.MANDATORY_ATTRIBUTES) && this.checkList(pattern, oc.getMustAttributeTypeOids())) {
                            searchResults.add((SchemaObject)oc);
                            continue;
                        }
                        if (!searchScope.contains((Object)SearchPage.SearchInEnum.OPTIONAL_ATTRIBUTES) || !this.checkList(pattern, oc.getMayAttributeTypeOids())) continue;
                        searchResults.add((SchemaObject)oc);
                    }
                }
            }
        }
        return searchResults;
    }

    private boolean checkList(Pattern pattern, List<String> list) {
        Iterator<String> i$;
        if (list != null && (i$ = list.iterator()).hasNext()) {
            String string = i$.next();
            return pattern.matcher(string).matches();
        }
        return false;
    }

    private boolean checkString(Pattern pattern, String string) {
        if (string != null) {
            return pattern.matcher(string).matches();
        }
        return false;
    }

    private void search() {
        String searchString = this.searchField.getText();
        List<SearchPage.SearchInEnum> searchScope = SearchPage.loadSearchIn();
        this.setSearchInput(searchString, searchScope.toArray(new SearchPage.SearchInEnum[0]), SearchPage.loadScope());
    }

    public void setSearchResultsLabel(String searchString, int resultsCount) {
        StringBuffer sb = new StringBuffer();
        if (searchString == null) {
            sb.append(Messages.getString("SearchView.NoSearch"));
        } else {
            sb.append("'" + searchString + "'");
            sb.append(" - ");
            sb.append(resultsCount);
            sb.append(" ");
            if (resultsCount > 1) {
                sb.append(Messages.getString("SearchView.Matches"));
            } else {
                sb.append(Messages.getString("SearchView.Match"));
            }
            sb.append(Messages.getString("SearchView.InWorkspace"));
        }
        this.searchResultsLabel.setText(sb.toString());
    }

    public void runCurrentSearchAgain() {
        if (this.searchString != null) {
            this.setSearchInput(this.searchString, SearchPage.loadSearchIn().toArray(new SearchPage.SearchInEnum[0]), SearchPage.loadScope());
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void refresh() {
        this.resultsTableViewer.refresh();
    }
}

