/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.schema.Messages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class SchemaEditorTableViewerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ObjectClass) {
            return Activator.getDefault().getImage("resources/icons/object_class.gif");
        }
        if (element instanceof AttributeType) {
            return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ObjectClass) {
            ObjectClass oc = (ObjectClass)element;
            List names = oc.getNames();
            if (names != null && names.size() > 0) {
                return ViewUtils.concateAliases(names) + "  -  (" + oc.getOid() + ")";
            }
            return NLS.bind((String)Messages.getString("SchemaEditorTableViewerLabelProvider.None"), (Object[])new String[]{oc.getOid()});
        }
        if (element instanceof AttributeType) {
            AttributeType at = (AttributeType)element;
            List names = at.getNames();
            if (names != null && names.size() > 0) {
                return ViewUtils.concateAliases(names) + "  -  (" + at.getOid() + ")";
            }
            return NLS.bind((String)Messages.getString("SchemaEditorTableViewerLabelProvider.None"), (Object[])new String[]{at.getOid()});
        }
        return null;
    }
}

