/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingObjectClass;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObjectClassEditorSuperiorsTableContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            ArrayList<Object> results = new ArrayList<Object>();
            List superiors = (List)inputElement;
            for (String superior : superiors) {
                MutableObjectClass oc = this.schemaHandler.getObjectClass(superior);
                if (oc != null) {
                    results.add(oc);
                    continue;
                }
                results.add(new NonExistingObjectClass(superior));
            }
            Collections.sort(results, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof ObjectClass && o2 instanceof ObjectClass) {
                        List oc1Names = ((ObjectClass)o1).getNames();
                        List oc2Names = ((ObjectClass)o2).getNames();
                        if (oc1Names != null && oc2Names != null && oc1Names.size() > 0 && oc2Names.size() > 0) {
                            return ((String)oc1Names.get(0)).compareToIgnoreCase((String)oc2Names.get(0));
                        }
                    } else if (o1 instanceof ObjectClass && o2 instanceof NonExistingObjectClass) {
                        List oc1Names = ((ObjectClass)o1).getNames();
                        String oc2Name = ((NonExistingObjectClass)o2).getName();
                        if (oc1Names != null && oc2Name != null && oc1Names.size() > 0) {
                            return ((String)oc1Names.get(0)).compareToIgnoreCase(oc2Name);
                        }
                    } else if (o1 instanceof NonExistingObjectClass && o2 instanceof ObjectClass) {
                        String oc1Name = ((NonExistingObjectClass)o1).getName();
                        List oc2Names = ((ObjectClass)o2).getNames();
                        if (oc1Name != null && oc2Names != null && oc2Names.size() > 0) {
                            return oc1Name.compareToIgnoreCase((String)oc2Names.get(0));
                        }
                    } else if (o1 instanceof NonExistingObjectClass && o2 instanceof NonExistingObjectClass) {
                        String oc1Name = ((NonExistingObjectClass)o1).getName();
                        String oc2Name = ((NonExistingObjectClass)o2).getName();
                        if (oc1Name != null && oc2Name != null) {
                            return oc1Name.compareToIgnoreCase(oc2Name);
                        }
                    }
                    return 0;
                }
            });
            return results.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

