/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileImportException;
import org.eclipse.osgi.util.NLS;

public class OpenLdapSchemaFileImporter {
    public static Schema getSchema(InputStream inputStream, String path) throws OpenLdapSchemaFileImportException {
        OpenLdapSchemaParser parser = null;
        try {
            parser = new OpenLdapSchemaParser();
        }
        catch (IOException e) {
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
        }
        try {
            parser.parse(inputStream);
        }
        catch (IOException e) {
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
        }
        catch (ParseException e) {
            ExceptionMessage exceptionMessage = OpenLdapSchemaFileImporter.parseExceptionMessage(e.getMessage());
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}) + (exceptionMessage == null ? "" : NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.ErrorMessage"), (Object[])new String[]{exceptionMessage.lineNumber, exceptionMessage.columnNumber, exceptionMessage.cause})), e);
        }
        String schemaName = OpenLdapSchemaFileImporter.getNameFromPath(path);
        Schema schema = new Schema(schemaName);
        List ats = parser.getAttributeTypes();
        for (int i = 0; i < ats.size(); ++i) {
            AttributeType at = OpenLdapSchemaFileImporter.convertAttributeType((AttributeType)ats.get(i));
            at.setSchemaName(schemaName);
            schema.addAttributeType(at);
        }
        List ocs = parser.getObjectClassTypes();
        for (int i = 0; i < ocs.size(); ++i) {
            MutableObjectClass oc = OpenLdapSchemaFileImporter.convertObjectClass((ObjectClass)ocs.get(i));
            oc.setSchemaName(schemaName);
            schema.addObjectClass(oc);
        }
        return schema;
    }

    private static final String getNameFromPath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        if (fileName.endsWith(".schema")) {
            String[] fileNameSplitted = fileName.split("\\.");
            return fileNameSplitted[0];
        }
        return fileName;
    }

    private static final AttributeType convertAttributeType(AttributeType at) {
        MutableAttributeType newAT = new MutableAttributeType(at.getOid());
        newAT.setNames(at.getNames());
        newAT.setDescription(at.getDescription());
        newAT.setSuperiorOid(at.getSuperiorOid());
        newAT.setUsage(at.getUsage());
        newAT.setSyntaxOid(at.getSyntaxOid());
        newAT.setSyntaxLength(at.getSyntaxLength());
        newAT.setObsolete(at.isObsolete());
        newAT.setSingleValued(at.isSingleValued());
        newAT.setCollective(at.isCollective());
        newAT.setUserModifiable(at.isUserModifiable());
        newAT.setEqualityOid(at.getEqualityOid());
        newAT.setOrderingOid(at.getOrderingOid());
        newAT.setSubstringOid(at.getSubstringOid());
        return newAT;
    }

    private static final MutableObjectClass convertObjectClass(ObjectClass oc) {
        MutableObjectClass newOC = new MutableObjectClass(oc.getOid());
        newOC.setNames(oc.getNames());
        newOC.setDescription(oc.getDescription());
        newOC.setSuperiorOids(oc.getSuperiorOids());
        newOC.setType(oc.getType());
        newOC.setObsolete(oc.isObsolete());
        newOC.setMustAttributeTypeOids(oc.getMustAttributeTypeOids());
        newOC.setMayAttributeTypeOids(oc.getMayAttributeTypeOids());
        return newOC;
    }

    private static ExceptionMessage parseExceptionMessage(String message) {
        MatchResult result;
        Scanner scanner = new Scanner(new ByteArrayInputStream(message.getBytes()));
        String foundString = scanner.findWithinHorizon(".*line (\\d+):(\\d+): *([^\\n]*).*", message.length());
        if (foundString != null && (result = scanner.match()).groupCount() == 3) {
            ExceptionMessage exceptionMessage = new ExceptionMessage();
            exceptionMessage.lineNumber = result.group(1);
            exceptionMessage.columnNumber = result.group(2);
            exceptionMessage.cause = result.group(3);
            scanner.close();
            return exceptionMessage;
        }
        scanner.close();
        return null;
    }

    private static class ExceptionMessage {
        String lineNumber;
        String columnNumber;
        String cause;

        private ExceptionMessage() {
        }
    }
}

