/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.CheckNetworkParameterRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NetworkParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_CONNECTION_NAME = "X-CONNECTION-NAME";
    private static final String X_ENCRYPTION = "X-ENCRYPTION";
    private static final String X_ENCRYPTION_LDAPS = "ldaps";
    private static final String X_ENCRYPTION_START_TLS = "StartTLS";
    private static final String X_NETWORK_PROVIDER = "X-NETWORK-PROVIDER";
    private static final String X_NETWORK_PROVIDER_JNDI = "JNDI";
    private static final String X_NETWORK_PROVIDER_APACHE_DIRECTORY_LDAP_API = "ApacheDirectoryLdapApi";
    private Text nameText;
    private Combo hostCombo;
    private Combo portCombo;
    private Combo encryptionMethodCombo;
    private Combo networkProviderCombo;
    private Button checkConnectionButton;
    private Button readOnlyConnectionCheckbox;

    private String getName() {
        return this.nameText.getText();
    }

    private String getHostName() {
        return this.hostCombo.getText();
    }

    private int getPort() {
        return Integer.parseInt(this.portCombo.getText());
    }

    private ConnectionParameter.EncryptionMethod getEncyrptionMethod() {
        switch (this.encryptionMethodCombo.getSelectionIndex()) {
            case 1: {
                return ConnectionParameter.EncryptionMethod.LDAPS;
            }
            case 2: {
                return ConnectionParameter.EncryptionMethod.START_TLS;
            }
        }
        return ConnectionParameter.EncryptionMethod.NONE;
    }

    private ConnectionParameter.NetworkProvider getNetworkProvider() {
        switch (this.networkProviderCombo.getSelectionIndex()) {
            case 1: {
                return ConnectionParameter.NetworkProvider.JNDI;
            }
        }
        return ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API;
    }

    private Connection getTestConnection() {
        ConnectionParameter cp = new ConnectionParameter(null, this.getHostName(), this.getPort(), this.getEncyrptionMethod(), this.getNetworkProvider(), ConnectionParameter.AuthenticationMethod.NONE, null, null, null, true, null);
        Connection conn = new Connection(cp);
        return conn;
    }

    private boolean isReadOnly() {
        return this.readOnlyConnectionCheckbox.getSelection();
    }

    @Override
    protected void createComposite(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Composite nameComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)nameComposite, (String)Messages.getString("NetworkParameterPage.ConnectionName"), (int)1);
        this.nameText = BaseWidgetUtils.createText((Composite)nameComposite, (String)"", (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("NetworkParameterPage.NetworkParameter"), (int)1);
        IDialogSettings dialogSettings = ConnectionUIPlugin.getDefault().getDialogSettings();
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.HostName"), (int)1);
        String[] hostHistory = HistoryUtils.load((IDialogSettings)dialogSettings, (String)"hostHistory");
        this.hostCombo = BaseWidgetUtils.createCombo((Composite)groupComposite, (String[])hostHistory, (int)-1, (int)2);
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.Port"), (int)1);
        String[] portHistory = HistoryUtils.load((IDialogSettings)dialogSettings, (String)"portHistory");
        this.portCombo = BaseWidgetUtils.createCombo((Composite)groupComposite, (String[])portHistory, (int)-1, (int)2);
        this.portCombo.setTextLimit(5);
        this.portCombo.setText("389");
        String[] encMethods = new String[]{Messages.getString("NetworkParameterPage.NoEncryption"), Messages.getString("NetworkParameterPage.UseSSLEncryption"), Messages.getString("NetworkParameterPage.UseStartTLS")};
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.EncryptionMethod"), (int)1);
        this.encryptionMethodCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])encMethods, (int)0, (int)2);
        boolean validateCertificates = ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("validateCertificates");
        if (!validateCertificates) {
            BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)1);
            BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.WarningCertificateValidation"), (int)2);
        } else {
            BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)1);
            Link link = BaseWidgetUtils.createLink((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.CertificateValidationLink"), (int)2);
            GridData linkGridData = new GridData(768);
            linkGridData.horizontalSpan = 2;
            linkGridData.widthHint = 100;
            link.setLayoutData((Object)linkGridData);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String certificateValidationPreferencePageId = "org.apache.directory.studio.connection.preferences.CertificateValidationPreferencePage";
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)certificateValidationPreferencePageId, (String[])new String[]{certificateValidationPreferencePageId}, null);
                    dialog.open();
                }
            });
        }
        String[] networkProviders = new String[]{"Apache Directory LDAP Client API", "JNDI (Java Naming and Directory Interface)"};
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.Provider"), (int)1);
        this.networkProviderCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])networkProviders, (int)0, (int)2);
        this.networkProviderCombo.select(ConnectionCorePlugin.getDefault().getDefaultNetworkProvider() == ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API ? 0 : 1);
        BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)2);
        this.checkConnectionButton = new Button(groupComposite, 8);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 1024;
        this.checkConnectionButton.setLayoutData((Object)gd);
        this.checkConnectionButton.setText(Messages.getString("NetworkParameterPage.CheckNetworkParameter"));
        this.readOnlyConnectionCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("NetworkParameterPage.ReadOnly"), (int)1);
        this.nameText.setFocus();
    }

    @Override
    protected void validate() {
        this.checkConnectionButton.setEnabled(!this.hostCombo.getText().equals("") && !this.portCombo.getText().equals(""));
        this.message = null;
        this.infoMessage = null;
        this.errorMessage = null;
        if ("".equals(this.portCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterPort");
        }
        if ("".equals(this.hostCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterHostname");
        }
        if ("".equals(this.nameText.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterConnectionName");
        }
        if (!(ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionByName(this.nameText.getText()) == null || this.connectionParameter != null && this.nameText.getText().equals(this.connectionParameter.getName()))) {
            this.errorMessage = NLS.bind((String)Messages.getString("NetworkParameterPage.ConnectionExists"), (Object[])new String[]{this.nameText.getText()});
        }
    }

    @Override
    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        this.nameText.setText(parameter.getName());
        this.hostCombo.setText(parameter.getHost());
        this.portCombo.setText(Integer.toString(parameter.getPort()));
        int encryptionMethodIndex = parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS ? 1 : (parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS ? 2 : 0);
        this.encryptionMethodCombo.select(encryptionMethodIndex);
        this.networkProviderCombo.select(parameter.getNetworkProvider() == ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API ? 0 : 1);
        this.readOnlyConnectionCheckbox.setSelection(parameter.isReadOnly());
    }

    @Override
    protected void initListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.hostCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.portCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        });
        this.portCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.encryptionMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.networkProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.checkConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Connection connection = NetworkParameterPage.this.getTestConnection();
                CheckNetworkParameterRunnable runnable = new CheckNetworkParameterRunnable(connection);
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, NetworkParameterPage.this.runnableContext, true);
                if (status.isOK()) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("NetworkParameterPage.CheckNetworkParameter"), (String)Messages.getString("NetworkParameterPage.ConnectionEstablished"));
                }
            }
        });
        this.readOnlyConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
    }

    @Override
    public void saveParameters(ConnectionParameter parameter) {
        parameter.setName(this.getName());
        parameter.setHost(this.getHostName());
        parameter.setPort(this.getPort());
        parameter.setEncryptionMethod(this.getEncyrptionMethod());
        parameter.setNetworkProvider(this.getNetworkProvider());
        parameter.setReadOnly(this.isReadOnly());
    }

    @Override
    public void saveDialogSettings() {
        IDialogSettings dialogSettings = ConnectionUIPlugin.getDefault().getDialogSettings();
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)"hostHistory", (String)this.hostCombo.getText());
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)"portHistory", (String)this.portCombo.getText());
    }

    @Override
    public void setFocus() {
        this.nameText.setFocus();
    }

    @Override
    public boolean areParametersModifed() {
        return this.isReconnectionRequired() || !StringUtils.equals((String)this.connectionParameter.getName(), (String)this.getName());
    }

    @Override
    public boolean isReconnectionRequired() {
        return this.connectionParameter == null || !StringUtils.equals((String)this.connectionParameter.getHost(), (String)this.getHostName()) || this.connectionParameter.getPort() != this.getPort() || this.connectionParameter.getEncryptionMethod() != this.getEncyrptionMethod() || this.connectionParameter.getNetworkProvider() != this.getNetworkProvider() || this.connectionParameter.isReadOnly() != this.isReadOnly();
    }

    @Override
    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapUrl ldapUrl) {
        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_CONNECTION_NAME, parameter.getName()));
        ldapUrl.setHost(parameter.getHost());
        ldapUrl.setPort(parameter.getPort());
        switch (parameter.getEncryptionMethod()) {
            case NONE: {
                break;
            }
            case LDAPS: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ENCRYPTION, X_ENCRYPTION_LDAPS));
                break;
            }
            case START_TLS: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ENCRYPTION, X_ENCRYPTION_START_TLS));
            }
        }
        switch (parameter.getNetworkProvider()) {
            case JNDI: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_NETWORK_PROVIDER, X_NETWORK_PROVIDER_JNDI));
                break;
            }
            case APACHE_DIRECTORY_LDAP_API: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_NETWORK_PROVIDER, X_NETWORK_PROVIDER_APACHE_DIRECTORY_LDAP_API));
            }
        }
    }

    @Override
    public void mergeLdapUrlToParameters(LdapUrl ldapUrl, ConnectionParameter parameter) {
        String name = ldapUrl.getExtensionValue(X_CONNECTION_NAME);
        if (StringUtils.isEmpty((String)name)) {
            name = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date());
        }
        parameter.setName(name);
        parameter.setHost(ldapUrl.getHost());
        parameter.setPort(ldapUrl.getPort());
        String encryption = ldapUrl.getExtensionValue(X_ENCRYPTION);
        if (StringUtils.isNotEmpty((String)encryption) && X_ENCRYPTION_LDAPS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
        } else if (StringUtils.isNotEmpty((String)encryption) && X_ENCRYPTION_START_TLS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.START_TLS);
        } else {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
        }
        String networkProvider = ldapUrl.getExtensionValue(X_NETWORK_PROVIDER);
        if (StringUtils.isNotEmpty((String)networkProvider) && X_NETWORK_PROVIDER_APACHE_DIRECTORY_LDAP_API.equalsIgnoreCase(networkProvider)) {
            parameter.setNetworkProvider(ConnectionParameter.NetworkProvider.APACHE_DIRECTORY_LDAP_API);
        } else if (StringUtils.isNotEmpty((String)networkProvider) && X_NETWORK_PROVIDER_JNDI.equalsIgnoreCase(networkProvider)) {
            parameter.setNetworkProvider(ConnectionParameter.NetworkProvider.JNDI);
        } else {
            parameter.setNetworkProvider(ConnectionCorePlugin.getDefault().getDefaultNetworkProvider());
        }
    }
}

