/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    int clientHandle;
    int labelHandle;
    String text = "";

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int clientHandle() {
        return this.clientHandle;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        int width = this.computeNativeSize((int)this.handle, (int)-1, (int)-1, (boolean)false).x;
        size.x = Math.max(size.x, width);
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        this.forceResize();
        int clientX = OS.GTK_WIDGET_X(this.clientHandle);
        int clientY = OS.GTK_WIDGET_Y(this.clientHandle);
        return new Rectangle(x -= clientX, y -= clientY, width += clientX + clientX, height += clientX + clientY);
    }

    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_frame_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        OS.g_object_ref(this.labelHandle);
        OS.gtk_object_sink(this.labelHandle);
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.clientHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_container_add(this.handle, this.clientHandle);
        if ((this.style & 4) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 1);
        }
        if ((this.style & 8) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 2);
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 3);
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_frame_set_shadow_type(this.handle, 4);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.labelHandle);
    }

    void enableWidget(boolean enabled) {
        OS.gtk_widget_set_sensitive(this.labelHandle, enabled);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            this.setFocus();
        }
        return result;
    }

    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.labelHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.clientHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.labelHandle != 0) {
            OS.g_object_unref(this.labelHandle);
        }
        this.text = null;
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        this.setBackgroundColor(this.fixedHandle, color);
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        OS.gtk_widget_modify_font(this.labelHandle, font);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        this.setForegroundColor(this.labelHandle, color);
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.labelHandle, dir);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            if (OS.gtk_frame_get_label_widget(this.handle) == 0) {
                OS.gtk_frame_set_label_widget(this.handle, this.labelHandle);
            }
        } else {
            OS.gtk_frame_set_label_widget(this.handle, 0);
        }
    }

    void showWidget() {
        super.showWidget();
        if (this.clientHandle != 0) {
            OS.gtk_widget_show(this.clientHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }
}

