/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.widgets;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class BaseWidgetUtils {
    public static Group createGroup(Composite parent, String label, int span) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        group.setLayoutData((Object)gd);
        group.setText(label);
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    public static Composite createColumnContainer(Composite parent, int columnCount, int span) {
        return BaseWidgetUtils.createColumnContainer(parent, columnCount, false, span);
    }

    public static Composite createColumnContainer(Composite parent, int columnCount, boolean makeColumnsEqualWidth, int span) {
        Composite container = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columnCount, makeColumnsEqualWidth);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        container.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        container.setLayoutData((Object)gd);
        return container;
    }

    public static Label createLabel(Composite parent, String text, int span) {
        Label l = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        l.setLayoutData((Object)gd);
        l.setText(text);
        return l;
    }

    public static Label createWrappedLabel(Composite parent, String text, int span) {
        Label l = new Label(parent, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 100;
        l.setLayoutData((Object)gd);
        l.setText(text);
        return l;
    }

    public static Text createText(Composite parent, String text, int span) {
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        t.setLayoutData((Object)gd);
        t.setText(text);
        return t;
    }

    public static Text createText(Composite parent, String text, int textWidth, int span) {
        Text t = new Text(parent, 2048);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.widthHint = 9 * textWidth;
        t.setLayoutData((Object)gd);
        t.setText(text);
        t.setTextLimit(textWidth);
        return t;
    }

    public static Text createPasswordText(Composite parent, String text, int span) {
        Text t = new Text(parent, 0x400800);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        t.setLayoutData((Object)gd);
        t.setText(text);
        return t;
    }

    public static Text createReadonlyPasswordText(Composite parent, String text, int span) {
        Text t = new Text(parent, 0x400808);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Text createLabeledText(Composite parent, String text, int span) {
        Text t = new Text(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Text createLabeledText(Composite parent, String text, int span, int widthHint) {
        Text t = new Text(parent, 0);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Text createWrappedLabeledText(Composite parent, String text, int span) {
        Text t = new Text(parent, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 10;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Text createWrappedLabeledText(Composite parent, String text, int span, int widthHint) {
        Text t = new Text(parent, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Text createReadonlyText(Composite parent, String text, int span) {
        Text t = new Text(parent, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        t.setBackground(parent.getBackground());
        t.setText(text);
        return t;
    }

    public static Combo createCombo(Composite parent, String[] items, int selectedIndex, int span) {
        Combo c = new Combo(parent, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        c.setLayoutData((Object)gd);
        c.setItems(items);
        c.select(selectedIndex);
        c.setVisibleItemCount(20);
        return c;
    }

    public static Combo createReadonlyCombo(Composite parent, String[] items, int selectedIndex, int span) {
        Combo c = new Combo(parent, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        c.setLayoutData((Object)gd);
        c.setItems(items);
        c.select(selectedIndex);
        c.setVisibleItemCount(20);
        return c;
    }

    public static Button createCheckbox(Composite parent, String text, int span) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        checkbox.setLayoutData((Object)gd);
        return checkbox;
    }

    public static Button createRadiobutton(Composite parent, String text, int span) {
        Button radio = new Button(parent, 16);
        radio.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        radio.setLayoutData((Object)gd);
        return radio;
    }

    public static Button createButton(Composite parent, String text, int span) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Button button = new Button(parent, 8);
        GridData gd = new GridData();
        gd.widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        button.setText(text);
        return button;
    }

    public static Label createRadioIndent(Composite parent, int span) {
        Label l = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = 22;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Label createSpacer(Composite parent, int span) {
        Label l = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Label createSeparator(Composite parent, int span) {
        Label l = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Link createLink(Composite parent, String text, int span) {
        Link link = new Link(parent, 0);
        link.setText(text);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = span;
        gd.widthHint = 150;
        link.setLayoutData((Object)gd);
        return link;
    }
}

