/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;

public abstract class AbstractInPlaceStringValueEditor
extends TextCellEditor
implements IValueEditor {
    private String name;
    private ImageDescriptor imageDescriptor;

    protected AbstractInPlaceStringValueEditor() {
    }

    protected boolean showRawValues() {
        return BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues");
    }

    @Override
    public String getDisplayValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return "NULL";
        }
        ArrayList<IValue> valueList = new ArrayList<IValue>();
        for (IAttribute attribute : attributeHierarchy) {
            valueList.addAll(Arrays.asList(attribute.getValues()));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = valueList.iterator();
        while (it.hasNext()) {
            IValue value = (IValue)it.next();
            sb.append(this.getDisplayValue(value));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getDisplayValue(IValue value) {
        Object obj = this.getRawValue(value);
        return obj == null ? "NULL" : obj.toString();
    }

    @Override
    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return null;
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 0) {
            if (attributeHierarchy.getAttribute().isString()) {
                return IValue.EMPTY_STRING_VALUE;
            }
            return IValue.EMPTY_BINARY_VALUE;
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 1) {
            return this.getRawValue(attributeHierarchy.getAttribute().getValues()[0]);
        }
        return null;
    }

    @Override
    public Object getRawValue(IValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.getStringValue();
        }
        if (value.isBinary()) {
            return this.isEditable(value.getBinaryValue()) ? value.getStringValue() : null;
        }
        return null;
    }

    private boolean isEditable(byte[] b) {
        if (b == null) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 10 || b[i] == 13 || b[i] >= 32 && b[i] <= 127) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getStringOrBinaryValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String) {
            return rawValue;
        }
        return null;
    }

    @Override
    public CellEditor getCellEditor() {
        return this;
    }

    protected Object doGetValue() {
        return "".equals(this.text.getText()) ? null : this.text.getText();
    }

    protected void doSetValue(Object value) {
        if (value != null && value instanceof IValue.EmptyValue) {
            value = ((IValue.EmptyValue)value).getStringValue();
        }
        super.doSetValue(value);
    }

    @Override
    public void setValueEditorName(String name) {
        this.name = name;
    }

    @Override
    public String getValueEditorName() {
        return this.name;
    }

    @Override
    public void setValueEditorImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public ImageDescriptor getValueEditorImageDescriptor() {
        return this.imageDescriptor;
    }
}

