/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.wizards;

import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyEvent;
import org.apache.directory.studio.ldapbrowser.common.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.common.wizards.Messages;
import org.apache.directory.studio.ldapbrowser.common.wizards.NewEntryWizard;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewEntryTypeWizardPage
extends WizardPage
implements WidgetModifyListener,
SelectionListener {
    public static final String PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY = NewEntryTypeWizardPage.class.getName() + ".preferredEntryCreationMethod";
    private NewEntryWizard wizard;
    private Button schemaButton;
    private Button templateButton;
    private EntryWidget entryWidget;

    public NewEntryTypeWizardPage(String pageName, NewEntryWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString("NewEntryTypeWizardPage.EntryCreationMethod"));
        this.setDescription(Messages.getString("NewEntryTypeWizardPage.EntryCreationMethodDescription"));
        this.setImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_wizard.gif"));
        this.setPageComplete(false);
        this.wizard = wizard;
    }

    private void validate() {
        if (this.schemaButton.getSelection()) {
            this.setPageComplete(true);
        } else if (this.templateButton.getSelection()) {
            this.setPageComplete(this.entryWidget.getBrowserConnection() != null && this.entryWidget.getDn() != null);
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWizardPage getNextPage() {
        if (this.templateButton.getSelection()) {
            IBrowserConnection browserConnection = this.entryWidget.getBrowserConnection();
            final Dn dn = this.entryWidget.getDn();
            IEntry templateEntry = null;
            if (browserConnection == null) {
                this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)NewEntryTypeWizardPage.this.getShell(), (String)Messages.getString("NewEntryTypeWizardPage.Error"), (String)Messages.getString("NewEntryTypeWizardPage.NoConnection"));
                    }
                });
                return null;
            }
            if (dn == null) {
                this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)NewEntryTypeWizardPage.this.getShell(), (String)Messages.getString("NewEntryTypeWizardPage.Error"), (String)Messages.getString("NewEntryTypeWizardPage.NoDN"));
                    }
                });
                return null;
            }
            ReadEntryRunnable readEntryRunnable = new ReadEntryRunnable(browserConnection, dn);
            RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)readEntryRunnable, (IRunnableContext)this.getContainer(), (boolean)false);
            templateEntry = readEntryRunnable.getReadEntry();
            if (templateEntry == null) {
                this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)NewEntryTypeWizardPage.this.getShell(), (String)Messages.getString("NewEntryTypeWizardPage.Error"), (String)NLS.bind((String)Messages.getString("NewEntryTypeWizardPage.EntryDoesNotExist"), (Object)dn.toString()));
                    }
                });
                return null;
            }
            if (!templateEntry.isAttributesInitialized()) {
                InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(new IEntry[]{templateEntry});
                RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, (IRunnableContext)this.getContainer(), (boolean)true);
            }
            try {
                EventRegistry.suspendEventFiringInCurrentThread();
                LdifContentRecord record = ModelConverter.entryToLdifContentRecord((IEntry)templateEntry);
                DummyEntry prototypeEntry = ModelConverter.ldifContentRecordToEntry((LdifContentRecord)record, (IBrowserConnection)browserConnection);
                IAttribute[] attributes = prototypeEntry.getAttributes();
                for (int i = 0; i < attributes.length; ++i) {
                    if (SchemaUtils.isModifiable((AttributeType)attributes[i].getAttributeTypeDescription())) continue;
                    prototypeEntry.deleteAttribute(attributes[i]);
                }
                this.wizard.setPrototypeEntry(prototypeEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                EventRegistry.resumeEventFiringInCurrentThread();
            }
        } else {
            this.wizard.setPrototypeEntry(new DummyEntry(new Dn(), this.wizard.getSelectedConnection()));
        }
        return super.getNextPage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.schemaButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("NewEntryTypeWizardPage.CreateEntryFromScratch"), (int)1);
        this.schemaButton.addSelectionListener((SelectionListener)this);
        this.templateButton = BaseWidgetUtils.createRadiobutton((Composite)composite, (String)Messages.getString("NewEntryTypeWizardPage.UseExistingEntryAsTemplate"), (int)1);
        this.templateButton.addSelectionListener((SelectionListener)this);
        Composite entryComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)3, (int)1);
        BaseWidgetUtils.createRadioIndent((Composite)entryComposite, (int)1);
        this.entryWidget = new EntryWidget(this.wizard.getSelectedConnection(), this.wizard.getSelectedEntry() != null ? this.wizard.getSelectedEntry().getDn() : null);
        this.entryWidget.createWidget(entryComposite);
        this.entryWidget.addWidgetModifyListener(this);
        if (BrowserCommonActivator.getDefault().getDialogSettings().get(PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY) == null) {
            BrowserCommonActivator.getDefault().getDialogSettings().put(PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY, true);
        }
        this.schemaButton.setSelection(BrowserCommonActivator.getDefault().getDialogSettings().getBoolean(PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY));
        this.templateButton.setSelection(!BrowserCommonActivator.getDefault().getDialogSettings().getBoolean(PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY));
        this.widgetSelected(null);
        this.setControl((Control)composite);
    }

    @Override
    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.entryWidget.setEnabled(this.templateButton.getSelection());
        this.validate();
    }

    public void saveDialogSettings() {
        BrowserCommonActivator.getDefault().getDialogSettings().put(PREFERRED_ENTRY_CREATION_METHOD_DIALOGSETTING_KEY, this.schemaButton.getSelection());
    }
}

