/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ScopeWidget
extends BrowserWidget {
    private SearchScope initialScope;
    private Group scopeGroup;
    private Button scopeObjectButton;
    private Button scopeOnelevelButton;
    private Button scopeSubtreeButton;

    public ScopeWidget(SearchScope initialScope) {
        this.initialScope = initialScope;
    }

    public ScopeWidget() {
        this.initialScope = SearchScope.OBJECT;
    }

    public void createWidget(Composite parent) {
        this.scopeGroup = new Group(parent, 0);
        this.scopeGroup.setText(Messages.getString("ScopeWidget.Scope"));
        this.scopeGroup.setLayout((Layout)new GridLayout(1, false));
        this.scopeGroup.setLayoutData((Object)new GridData(1808));
        this.scopeObjectButton = new Button((Composite)this.scopeGroup, 16);
        this.scopeObjectButton.setText(Messages.getString("ScopeWidget.Object"));
        this.scopeObjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeWidget.this.notifyListeners();
            }
        });
        this.scopeOnelevelButton = new Button((Composite)this.scopeGroup, 16);
        this.scopeOnelevelButton.setText(Messages.getString("ScopeWidget.OneLevel"));
        this.scopeOnelevelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeWidget.this.notifyListeners();
            }
        });
        this.scopeSubtreeButton = new Button((Composite)this.scopeGroup, 16);
        this.scopeSubtreeButton.setText(Messages.getString("ScopeWidget.Subtree"));
        this.scopeSubtreeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeWidget.this.notifyListeners();
            }
        });
        this.setScope(this.initialScope);
    }

    public void setScope(SearchScope scope) {
        this.initialScope = scope;
        this.scopeObjectButton.setSelection(this.initialScope == SearchScope.OBJECT);
        this.scopeOnelevelButton.setSelection(this.initialScope == SearchScope.ONELEVEL);
        this.scopeSubtreeButton.setSelection(this.initialScope == SearchScope.SUBTREE);
    }

    public SearchScope getScope() {
        SearchScope scope = this.scopeSubtreeButton.getSelection() ? SearchScope.SUBTREE : (this.scopeOnelevelButton.getSelection() ? SearchScope.ONELEVEL : (this.scopeObjectButton.getSelection() ? SearchScope.OBJECT : SearchScope.ONELEVEL));
        return scope;
    }

    public void setEnabled(boolean b) {
        this.scopeGroup.setEnabled(b);
        this.scopeObjectButton.setEnabled(b);
        this.scopeOnelevelButton.setEnabled(b);
        this.scopeSubtreeButton.setEnabled(b);
    }
}

