/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterAutoEditStrategy;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

public class FilterWidgetAutoEditStrategyAdapter {
    private FilterAutoEditStrategy autoEditStrategy;
    private Combo combo;
    private List<String> oldTexts;
    private List<VerifyEvent> verifyEvents;
    private boolean inApplyComboCustomization;

    public FilterWidgetAutoEditStrategyAdapter(Combo combo, LdapFilterParser parser) {
        this.combo = combo;
        this.oldTexts = new ArrayList<String>();
        this.verifyEvents = new ArrayList<VerifyEvent>();
        this.inApplyComboCustomization = false;
        this.autoEditStrategy = new FilterAutoEditStrategy(parser);
        combo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                FilterWidgetAutoEditStrategyAdapter.this.prepareComboCustomization(e);
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterWidgetAutoEditStrategyAdapter.this.applyComboCustomization(e);
            }
        });
    }

    public void prepareComboCustomization(VerifyEvent e) {
        if (!this.inApplyComboCustomization) {
            String oldText = this.combo.getText();
            if (!this.oldTexts.isEmpty()) {
                this.oldTexts.clear();
                this.verifyEvents.clear();
            }
            this.oldTexts.add(oldText);
            this.verifyEvents.add(e);
        }
    }

    public void applyComboCustomization(ModifyEvent e) {
        if (!this.inApplyComboCustomization && !this.verifyEvents.isEmpty()) {
            Point newSelection;
            String oldText = this.oldTexts.remove(0);
            VerifyEvent verifyEvent = this.verifyEvents.remove(0);
            this.inApplyComboCustomization = true;
            String text = verifyEvent.text;
            int offset = verifyEvent.start <= verifyEvent.end ? verifyEvent.start : verifyEvent.end;
            int length = verifyEvent.start <= verifyEvent.end ? verifyEvent.end - verifyEvent.start : verifyEvent.start - verifyEvent.end;
            FilterAutoEditStrategy.AutoEditParameters autoEditParameters = new FilterAutoEditStrategy.AutoEditParameters(text, offset, length, -1, true);
            this.autoEditStrategy.customizeAutoEditParameters(oldText, autoEditParameters);
            Point oldSelection = this.combo.getSelection();
            String newText = "";
            newText = newText + oldText.substring(0, autoEditParameters.offset);
            newText = newText + autoEditParameters.text;
            newText = newText + oldText.substring(autoEditParameters.offset + autoEditParameters.length, oldText.length());
            if (autoEditParameters.caretOffset != -1) {
                int x = autoEditParameters.caretOffset;
                newSelection = new Point(x, x);
            } else {
                newSelection = new Point(oldSelection.x, oldSelection.y);
            }
            if (this.verifyEvents.isEmpty()) {
                this.combo.setText(newText);
                this.combo.setSelection(newSelection);
            }
            this.inApplyComboCustomization = false;
        }
    }
}

