/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SelectBrowserConnectionDialog;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class BrowserConnectionWidget
extends BrowserWidget {
    private Text browserConnectionText;
    private Button connectionBrowseButton;
    private IBrowserConnection selectedBrowserConnection;

    public BrowserConnectionWidget(IBrowserConnection connection) {
        this.selectedBrowserConnection = connection;
    }

    public BrowserConnectionWidget() {
        this.selectedBrowserConnection = null;
    }

    public void createWidget(final Composite parent) {
        this.browserConnectionText = BaseWidgetUtils.createReadonlyText((Composite)parent, (String)"", (int)1);
        this.connectionBrowseButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("BrowserConnectionWidget.BrowseButton"), (int)1);
        this.connectionBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBrowserConnectionDialog dialog = new SelectBrowserConnectionDialog(parent.getShell(), Messages.getString("BrowserConnectionWidget.SelectConnection"), BrowserConnectionWidget.this.selectedBrowserConnection);
                dialog.open();
                IBrowserConnection browserConnection = dialog.getSelectedBrowserConnection();
                if (browserConnection != null) {
                    BrowserConnectionWidget.this.setBrowserConnection(browserConnection);
                    BrowserConnectionWidget.this.notifyListeners();
                }
            }
        });
        this.setBrowserConnection(this.selectedBrowserConnection);
    }

    public IBrowserConnection getBrowserConnection() {
        return this.selectedBrowserConnection;
    }

    public void setBrowserConnection(IBrowserConnection connection) {
        this.selectedBrowserConnection = connection;
        this.browserConnectionText.setText(this.selectedBrowserConnection != null && this.selectedBrowserConnection.getConnection() != null ? this.selectedBrowserConnection.getConnection().getName() : "");
    }

    public void setEnabled(boolean b) {
        this.browserConnectionText.setEnabled(b);
        this.connectionBrowseButton.setEnabled(b);
    }
}

