/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetContentProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetFilter;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class EntryEditorWidgetLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IFontProvider,
IColorProvider {
    private TreeViewer viewer;
    private ValueEditorManager valueEditorManager;

    public EntryEditorWidgetLabelProvider(TreeViewer viewer, ValueEditorManager valueEditorManager) {
        this.viewer = viewer;
        this.valueEditorManager = valueEditorManager;
    }

    public void dispose() {
        super.dispose();
        this.valueEditorManager = null;
    }

    public final String getColumnText(Object obj, int index) {
        if (obj != null && obj instanceof IValue) {
            IValue value = (IValue)obj;
            switch (index) {
                case 0: {
                    return value.getAttribute().getDescription();
                }
                case 1: {
                    IValueEditor vp = this.valueEditorManager.getCurrentValueEditor(value);
                    String dv = vp.getDisplayValue(value);
                    return dv;
                }
            }
            return "";
        }
        if (obj != null && obj instanceof IAttribute) {
            IAttribute attribute = (IAttribute)obj;
            if (index == 0) {
                return NLS.bind((String)Messages.getString("EntryEditorWidgetLabelProvider.AttributeLabel"), (Object)attribute.getDescription(), (Object)this.getNumberOfValues(attribute));
            }
            return "";
        }
        return "";
    }

    private int getNumberOfValues(IAttribute attribute) {
        EntryEditorWidgetContentProvider contentProvider = (EntryEditorWidgetContentProvider)this.viewer.getContentProvider();
        EntryEditorWidgetFilter filter = (EntryEditorWidgetFilter)this.viewer.getFilters()[0];
        int count = 0;
        for (Object child : contentProvider.getChildren(attribute)) {
            if (!filter.select((Viewer)this.viewer, attribute, child)) continue;
            ++count;
        }
        return count;
    }

    public final Image getColumnImage(Object element, int index) {
        return null;
    }

    public Font getFont(Object element) {
        IAttribute attribute = null;
        IValue value = null;
        if (element instanceof IAttribute) {
            attribute = (IAttribute)element;
        } else if (element instanceof IValue) {
            value = (IValue)element;
            attribute = value.getAttribute();
        }
        if (value != null && value.isEmpty()) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            FontData fontDataBoldItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 3);
            return BrowserCommonActivator.getDefault().getFont(new FontData[]{fontDataBoldItalic});
        }
        if (attribute != null && value == null && !attribute.isConsistent()) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            FontData fontDataBoldItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 3);
            return BrowserCommonActivator.getDefault().getFont(new FontData[]{fontDataBoldItalic});
        }
        if (attribute != null) {
            if (attribute.isObjectClassAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"objectClassFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            if (attribute.isMustAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mustAttributeFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            if (attribute.isOperationalAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"operationalAttributeFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mayAttributeFont");
            return BrowserCommonActivator.getDefault().getFont(fontData);
        }
        return null;
    }

    public Color getForeground(Object element) {
        IAttribute attribute = null;
        IValue value = null;
        if (element instanceof IAttribute) {
            attribute = (IAttribute)element;
        } else if (element instanceof IValue) {
            value = (IValue)element;
            attribute = value.getAttribute();
        }
        if (value != null && value.isEmpty()) {
            return BrowserCommonActivator.getDefault().getColor(Display.getDefault().getSystemColor(3).getRGB());
        }
        if (attribute != null && value == null && !attribute.isConsistent()) {
            return BrowserCommonActivator.getDefault().getColor(Display.getDefault().getSystemColor(3).getRGB());
        }
        if (attribute != null) {
            if (attribute.isObjectClassAttribute()) {
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"objectClassColor");
                return BrowserCommonActivator.getDefault().getColor(rgb);
            }
            if (attribute.isMustAttribute()) {
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mustAttributeColor");
                return BrowserCommonActivator.getDefault().getColor(rgb);
            }
            if (attribute.isOperationalAttribute()) {
                RGB rgb = PreferenceConverter.getColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"operationalAttributeColor");
                return BrowserCommonActivator.getDefault().getColor(rgb);
            }
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mayAttributeColor");
            return BrowserCommonActivator.getDefault().getColor(rgb);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

