/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.Arrays;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSorter;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;

public class BrowserEntryPage {
    private BrowserSorter sorter;
    private int first;
    private int last;
    private IEntry entry;
    private BrowserEntryPage parentEntryPage;
    private BrowserEntryPage[] subpages;

    public BrowserEntryPage(IEntry entry, int first, int last, BrowserEntryPage[] subpages, BrowserSorter sorter) {
        this.entry = entry;
        this.first = first;
        this.last = last;
        this.subpages = subpages;
        this.sorter = sorter;
        if (subpages != null) {
            for (int i = 0; i < subpages.length; ++i) {
                subpages[i].parentEntryPage = this;
            }
        }
    }

    public Object[] getChildren() {
        if (this.subpages != null) {
            return this.subpages;
        }
        Object[] children = this.entry.getChildren();
        this.sorter.sort(null, children);
        if (children != null) {
            Object[] childrenRange = new IEntry[this.last - this.first + 1];
            for (int i = this.first; i <= this.last; ++i) {
                childrenRange[i - this.first] = children[i];
            }
            return childrenRange;
        }
        return null;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public IEntry getEntry() {
        return this.entry;
    }

    public BrowserEntryPage getParentOf(IEntry entry) {
        if (this.subpages != null) {
            BrowserEntryPage ep = null;
            for (int i = 0; i < this.subpages.length && ep == null; ++i) {
                ep = this.subpages[i].getParentOf(entry);
            }
            return ep;
        }
        IEntry[] sr = (IEntry[])this.getChildren();
        if (sr != null && Arrays.asList(sr).contains(entry)) {
            return this;
        }
        return null;
    }

    public Object getParent() {
        return this.parentEntryPage != null ? this.parentEntryPage : this.entry;
    }

    public String toString() {
        return this.entry.toString() + "[" + this.first + "..." + this.last + "]" + this.hashCode();
    }
}

