/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterExtensibleComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterItemComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class FilterTextHover
implements ITextHover {
    private LdapFilterParser parser;
    private Schema schema;

    public FilterTextHover(LdapFilterParser parser) {
        this.parser = parser;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.schema != null) {
            LdapFilterItemComponent fc;
            LdapFilter filter = this.parser.getModel().getFilter(hoverRegion.getOffset());
            if (filter.getFilterComponent() instanceof LdapFilterItemComponent) {
                fc = (LdapFilterItemComponent)filter.getFilterComponent();
                if (fc.getAttributeToken() != null && fc.getAttributeToken().getOffset() <= hoverRegion.getOffset() && hoverRegion.getOffset() <= fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength()) {
                    String attributeType = fc.getAttributeToken().getValue();
                    AttributeType attributeTypeDescription = this.schema.getAttributeTypeDescription(attributeType);
                    String ldifLine = SchemaUtils.getLdifLine((AbstractSchemaObject)attributeTypeDescription);
                    return ldifLine;
                }
                if (fc.getAttributeToken() != null && "objectClass".equalsIgnoreCase(fc.getAttributeToken().getValue()) && fc.getValueToken() != null && fc.getValueToken().getOffset() <= hoverRegion.getOffset() && hoverRegion.getOffset() <= fc.getValueToken().getOffset() + fc.getValueToken().getLength()) {
                    String objectClass = fc.getValueToken().getValue();
                    MutableObjectClass objectClassDescription = this.schema.getObjectClassDescription(objectClass);
                    String ldifLine = SchemaUtils.getLdifLine((AbstractSchemaObject)objectClassDescription);
                    return ldifLine;
                }
            }
            if (filter.getFilterComponent() instanceof LdapFilterExtensibleComponent) {
                fc = (LdapFilterExtensibleComponent)filter.getFilterComponent();
                if (fc.getAttributeToken() != null && fc.getAttributeToken().getOffset() <= hoverRegion.getOffset() && hoverRegion.getOffset() <= fc.getAttributeToken().getOffset() + fc.getAttributeToken().getLength()) {
                    String attributeType = fc.getAttributeToken().getValue();
                    AttributeType attributeTypeDescription = this.schema.getAttributeTypeDescription(attributeType);
                    String ldifLine = SchemaUtils.getLdifLine((AbstractSchemaObject)attributeTypeDescription);
                    return ldifLine;
                }
                if (fc.getMatchingRuleToken() != null && fc.getMatchingRuleToken().getOffset() <= hoverRegion.getOffset() && hoverRegion.getOffset() <= fc.getMatchingRuleToken().getOffset() + fc.getMatchingRuleToken().getLength()) {
                    String matchingRule = fc.getMatchingRuleToken().getValue();
                    MatchingRule matchingRuleDescription = this.schema.getMatchingRuleDescription(matchingRule);
                    String info = SchemaUtils.getLdifLine((AbstractSchemaObject)matchingRuleDescription);
                    return info;
                }
            }
        }
        LdapFilter[] invalidFilters = this.parser.getModel().getInvalidFilters();
        for (int i = 0; i < invalidFilters.length; ++i) {
            int stop;
            if (invalidFilters[i].getStartToken() == null) continue;
            int start = invalidFilters[i].getStartToken().getOffset();
            int n = stop = invalidFilters[i].getStopToken() != null ? invalidFilters[i].getStopToken().getOffset() + invalidFilters[i].getStopToken().getLength() : start + invalidFilters[i].getStartToken().getLength();
            if (start > hoverRegion.getOffset() || hoverRegion.getOffset() >= stop) continue;
            return invalidFilters[i].getInvalidCause();
        }
        LdapFilterToken[] tokens = this.parser.getModel().getTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].getType() != -2) continue;
            int start = tokens[i].getOffset();
            int stop = start + tokens[i].getLength();
            if (start > hoverRegion.getOffset() || hoverRegion.getOffset() >= stop) continue;
            return Messages.getString("FilterTextHover.InvalidCharacters");
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 1);
    }
}

