/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class SearchTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = BrowserCommonConstants.DND_SEARCH_TRANSFER;
    private static final int TYPEID = SearchTransfer.registerType((String)TYPENAME);
    private static SearchTransfer instance = new SearchTransfer();

    private SearchTransfer() {
    }

    public static SearchTransfer getInstance() {
        return instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof ISearch[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            ISearch[] searches = (ISearch[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                for (ISearch search : searches) {
                    byte[] connectionId = search.getBrowserConnection().getConnection().getId().getBytes("UTF-8");
                    writeOut.writeInt(connectionId.length);
                    writeOut.write(connectionId);
                    byte[] searchName = search.getName().getBytes("UTF-8");
                    writeOut.writeInt(searchName.length);
                    writeOut.write(searchName);
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        block8: {
            try {
                if (!this.isSupportedType(transferData)) break block8;
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ArrayList<ISearch> searchList = new ArrayList<ISearch>();
                try {
                    IBrowserConnection connection = null;
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    DataInputStream readIn = new DataInputStream(in);
                    do {
                        if (readIn.available() > 1) {
                            int size = readIn.readInt();
                            byte[] connectionId = new byte[size];
                            readIn.read(connectionId);
                            connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(new String(connectionId, "UTF-8"));
                        }
                        ISearch search = null;
                        if (readIn.available() <= 1 || connection == null) {
                            return null;
                        }
                        int size = readIn.readInt();
                        byte[] searchName = new byte[size];
                        readIn.read(searchName);
                        search = connection.getSearchManager().getSearch(new String(searchName, "UTF-8"));
                        if (search == null) continue;
                        searchList.add(search);
                    } while (readIn.available() > 1);
                    readIn.close();
                }
                catch (IOException ex) {
                    return null;
                }
                return searchList.isEmpty() ? null : searchList.toArray(new ISearch[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

