/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.AttributeValueEditorDialog;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.SyntaxValueEditorDialog;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionManager;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.AttributeValueEditorRelation;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SyntaxValueEditorRelation;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValueEditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private SortedMap<String, ValueEditorManager.ValueEditorExtension> class2ValueEditorExtensionMap;
    private SortedMap<String, AttributeType> attributeOid2AtdMap;
    private SortedMap<String, AttributeType> attributeNames2AtdMap;
    private String[] attributeTypesAndOids;
    private SortedMap<String, LdapSyntax> syntaxOid2LsdMap;
    private SortedMap<String, LdapSyntax> syntaxDesc2LsdMap;
    private String[] syntaxDescsAndOids;
    private List<AttributeValueEditorRelation> attributeList;
    private TableViewer attributeViewer;
    private Button attributeAddButton;
    private Button attributeEditButton;
    private Button attributeRemoveButton;
    private List<SyntaxValueEditorRelation> syntaxList;
    private TableViewer syntaxViewer;
    private Button syntaxAddButton;
    private Button syntaxEditButton;
    private Button syntaxRemoveButton;
    private Map<ImageDescriptor, Image> imageMap;

    public ValueEditorsPreferencePage() {
        super(Messages.getString("ValueEditorsPreferencePage.ValueEditors"));
        super.setDescription(Messages.getString("ValueEditorsPreferencePage.SpecifyValueEditors"));
        this.imageMap = new HashMap<ImageDescriptor, Image>();
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.imageMap != null) {
            for (Image image : this.imageMap.values()) {
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        Schema schema;
        IBrowserConnection[] connections;
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        this.class2ValueEditorExtensionMap = new TreeMap<String, ValueEditorManager.ValueEditorExtension>();
        Composite dummyComposite = new Composite(composite, 0);
        dummyComposite.setLayoutData((Object)new GridData(1, 1));
        Collection<ValueEditorManager.ValueEditorExtension> valueEditorExtensions = ValueEditorManager.getValueEditorExtensions();
        for (ValueEditorManager.ValueEditorExtension vee : valueEditorExtensions) {
            this.class2ValueEditorExtensionMap.put(vee.className, vee);
        }
        this.attributeNames2AtdMap = new TreeMap<String, AttributeType>();
        this.attributeOid2AtdMap = new TreeMap<String, AttributeType>();
        BrowserConnectionManager cm = BrowserCorePlugin.getDefault().getConnectionManager();
        for (IBrowserConnection browserConnection : connections = cm.getBrowserConnections()) {
            schema = browserConnection.getSchema();
            this.createAttributeMapsAndArray(schema);
        }
        this.createAttributeMapsAndArray(Schema.DEFAULT_SCHEMA);
        this.syntaxOid2LsdMap = new TreeMap<String, LdapSyntax>();
        this.syntaxDesc2LsdMap = new TreeMap<String, LdapSyntax>();
        for (IBrowserConnection browserConnection : connections) {
            schema = browserConnection.getSchema();
            this.createSyntaxMapsAndArray(schema);
        }
        this.createSyntaxMapsAndArray(Schema.DEFAULT_SCHEMA);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.createAttributeContents(composite);
        this.attributeList = new ArrayList<AttributeValueEditorRelation>(Arrays.asList(BrowserCommonActivator.getDefault().getValueEditorsPreferences().getAttributeValueEditorRelations()));
        this.attributeViewer.setInput(this.attributeList);
        this.attributeViewer.getTable().getColumn(0).pack();
        this.attributeViewer.getTable().getColumn(2).pack();
        this.attributeViewer.getTable().pack();
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.createSyntaxContents(composite);
        this.syntaxList = new ArrayList<SyntaxValueEditorRelation>(Arrays.asList(BrowserCommonActivator.getDefault().getValueEditorsPreferences().getSyntaxValueEditorRelations()));
        this.syntaxViewer.setInput(this.syntaxList);
        this.syntaxViewer.getTable().getColumn(0).pack();
        this.syntaxViewer.getTable().getColumn(2).pack();
        this.syntaxViewer.getTable().pack();
        return composite;
    }

    private void createAttributeMapsAndArray(Schema schema) {
        ArrayList<String> attributeTypesList = new ArrayList<String>();
        ArrayList<String> oidsList = new ArrayList<String>();
        Collection atds = schema.getAttributeTypeDescriptions();
        for (AttributeType atd : atds) {
            this.attributeOid2AtdMap.put(atd.getOid(), atd);
            oidsList.add(atd.getOid());
            for (String name : atd.getNames()) {
                this.attributeNames2AtdMap.put(name.toLowerCase(), atd);
                attributeTypesList.add(name);
            }
        }
        Collections.sort(attributeTypesList);
        Collections.sort(oidsList);
        ArrayList<String> attributeTypesAndOidsList = new ArrayList<String>();
        attributeTypesAndOidsList.addAll(attributeTypesList);
        attributeTypesAndOidsList.addAll(oidsList);
        this.attributeTypesAndOids = attributeTypesAndOidsList.toArray(new String[0]);
    }

    private void createSyntaxMapsAndArray(Schema schema) {
        ArrayList<String> syntaxDescsAndOidsList = new ArrayList<String>();
        Collection lsds = schema.getLdapSyntaxDescriptions();
        for (LdapSyntax lsd : lsds) {
            this.syntaxOid2LsdMap.put(lsd.getOid(), lsd);
            syntaxDescsAndOidsList.add(lsd.getOid());
            if (lsd.getDescription() == null) continue;
            this.syntaxDesc2LsdMap.put(lsd.getDescription(), lsd);
        }
        Collections.sort(syntaxDescsAndOidsList);
        this.syntaxDescsAndOids = syntaxDescsAndOidsList.toArray(new String[0]);
    }

    private void createAttributeContents(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ValueEditorsPreferencePage.ValueEditorsByAttributeType"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Composite listComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        listComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Table table = new Table(listComposite, 67844);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.attributeViewer = new TableViewer(table);
        TableColumn c1 = new TableColumn(table, 0);
        c1.setText(Messages.getString("ValueEditorsPreferencePage.Attribute"));
        c1.setWidth(80);
        TableColumn c2 = new TableColumn(table, 0);
        c2.setText(Messages.getString("ValueEditorsPreferencePage.Alias"));
        c2.setWidth(80);
        TableColumn c3 = new TableColumn(table, 0);
        c3.setText(Messages.getString("ValueEditorsPreferencePage.ValueEditor"));
        c3.setWidth(200);
        this.attributeViewer.setColumnProperties(new String[]{Messages.getString("ValueEditorsPreferencePage.Attribute"), Messages.getString("ValueEditorsPreferencePage.ValueEditor")});
        this.attributeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.attributeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValueEditorsPreferencePage.this.editAttribute();
            }
        });
        this.attributeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValueEditorsPreferencePage.this.attributeEditButton.setEnabled(!ValueEditorsPreferencePage.this.attributeViewer.getSelection().isEmpty());
                ValueEditorsPreferencePage.this.attributeRemoveButton.setEnabled(!ValueEditorsPreferencePage.this.attributeViewer.getSelection().isEmpty());
            }
        });
        this.attributeAddButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Add"), (int)1);
        this.attributeAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.addAttribute();
            }
        });
        this.attributeEditButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Edit"), (int)1);
        this.attributeEditButton.setEnabled(false);
        this.attributeEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.editAttribute();
            }
        });
        this.attributeRemoveButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Remove"), (int)1);
        this.attributeRemoveButton.setEnabled(false);
        this.attributeRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.removeAttribute();
            }
        });
    }

    private void createSyntaxContents(Composite parent) {
        BaseWidgetUtils.createLabel((Composite)parent, (String)Messages.getString("ValueEditorsPreferencePage.ValueEditorBySyntax"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Composite listComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        listComposite.setLayoutData((Object)new GridData(1808));
        Composite buttonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Table table = new Table(listComposite, 67844);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.syntaxViewer = new TableViewer(table);
        TableColumn c1 = new TableColumn(table, 0);
        c1.setText(Messages.getString("ValueEditorsPreferencePage.Syntax"));
        c1.setWidth(80);
        TableColumn c2 = new TableColumn(table, 0);
        c2.setText(Messages.getString("ValueEditorsPreferencePage.Description"));
        c2.setWidth(80);
        TableColumn c3 = new TableColumn(table, 0);
        c3.setText(Messages.getString("ValueEditorsPreferencePage.ValueEditor"));
        c3.setWidth(200);
        this.syntaxViewer.setColumnProperties(new String[]{Messages.getString("ValueEditorsPreferencePage.Syntax"), Messages.getString("ValueEditorsPreferencePage.ValueEditor")});
        this.syntaxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.syntaxViewer.setLabelProvider((IBaseLabelProvider)new SyntaxLabelProvider());
        this.syntaxViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValueEditorsPreferencePage.this.editSyntax();
            }
        });
        this.syntaxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValueEditorsPreferencePage.this.syntaxEditButton.setEnabled(!ValueEditorsPreferencePage.this.syntaxViewer.getSelection().isEmpty());
                ValueEditorsPreferencePage.this.syntaxRemoveButton.setEnabled(!ValueEditorsPreferencePage.this.syntaxViewer.getSelection().isEmpty());
            }
        });
        this.syntaxAddButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Add"), (int)1);
        this.syntaxAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.addSyntax();
            }
        });
        this.syntaxEditButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Edit"), (int)1);
        this.syntaxEditButton.setEnabled(false);
        this.syntaxEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.editSyntax();
            }
        });
        this.syntaxRemoveButton = BaseWidgetUtils.createButton((Composite)buttonComposite, (String)Messages.getString("ValueEditorsPreferencePage.Remove"), (int)1);
        this.syntaxRemoveButton.setEnabled(false);
        this.syntaxRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueEditorsPreferencePage.this.removeSyntax();
            }
        });
    }

    private void addAttribute() {
        AttributeValueEditorDialog dialog = new AttributeValueEditorDialog(this.getShell(), null, this.class2ValueEditorExtensionMap, this.attributeTypesAndOids);
        if (dialog.open() == 0) {
            this.attributeList.add(dialog.getRelation());
            this.attributeViewer.refresh();
        }
    }

    private void removeAttribute() {
        Object o = ((StructuredSelection)this.attributeViewer.getSelection()).getFirstElement();
        this.attributeList.remove(o);
        this.attributeViewer.refresh();
    }

    private void editAttribute() {
        StructuredSelection sel = (StructuredSelection)this.attributeViewer.getSelection();
        if (!sel.isEmpty()) {
            AttributeValueEditorRelation relation = (AttributeValueEditorRelation)sel.getFirstElement();
            AttributeValueEditorDialog dialog = new AttributeValueEditorDialog(this.getShell(), relation, this.class2ValueEditorExtensionMap, this.attributeTypesAndOids);
            if (dialog.open() == 0) {
                int index = this.attributeList.indexOf(relation);
                this.attributeList.set(index, dialog.getRelation());
                this.attributeViewer.refresh();
            }
        }
    }

    private void addSyntax() {
        SyntaxValueEditorDialog dialog = new SyntaxValueEditorDialog(this.getShell(), null, this.class2ValueEditorExtensionMap, this.syntaxDescsAndOids);
        if (dialog.open() == 0) {
            this.syntaxList.add(dialog.getRelation());
            this.syntaxViewer.refresh();
        }
    }

    private void removeSyntax() {
        Object o = ((StructuredSelection)this.syntaxViewer.getSelection()).getFirstElement();
        this.syntaxList.remove(o);
        this.syntaxViewer.refresh();
    }

    private void editSyntax() {
        StructuredSelection sel = (StructuredSelection)this.syntaxViewer.getSelection();
        if (!sel.isEmpty()) {
            SyntaxValueEditorRelation relation = (SyntaxValueEditorRelation)sel.getFirstElement();
            SyntaxValueEditorDialog dialog = new SyntaxValueEditorDialog(this.getShell(), relation, this.class2ValueEditorExtensionMap, this.syntaxDescsAndOids);
            if (dialog.open() == 0) {
                int index = this.syntaxList.indexOf(relation);
                this.syntaxList.set(index, dialog.getRelation());
                this.syntaxViewer.refresh();
            }
        }
    }

    public boolean performOk() {
        AttributeValueEditorRelation[] aRelations = this.attributeList.toArray(new AttributeValueEditorRelation[this.attributeList.size()]);
        BrowserCommonActivator.getDefault().getValueEditorsPreferences().setAttributeValueEditorRelations(aRelations);
        SyntaxValueEditorRelation[] sRelations = this.syntaxList.toArray(new SyntaxValueEditorRelation[this.syntaxList.size()]);
        BrowserCommonActivator.getDefault().getValueEditorsPreferences().setSyntaxValueEditorRelations(sRelations);
        return true;
    }

    protected void performDefaults() {
        this.attributeList.clear();
        this.attributeList.addAll(Arrays.asList(BrowserCommonActivator.getDefault().getValueEditorsPreferences().getDefaultAttributeValueEditorRelations()));
        this.attributeViewer.refresh();
        this.syntaxList.clear();
        this.syntaxList.addAll(Arrays.asList(BrowserCommonActivator.getDefault().getValueEditorsPreferences().getDefaultSyntaxValueEditorRelations()));
        this.syntaxViewer.refresh();
        super.performDefaults();
    }

    class SyntaxLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SyntaxLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof SyntaxValueEditorRelation) {
                SyntaxValueEditorRelation relation = (SyntaxValueEditorRelation)obj;
                if (index == 0) {
                    return relation.getSyntaxOID();
                }
                if (index == 1) {
                    if (relation.getSyntaxOID() != null && ValueEditorsPreferencePage.this.syntaxOid2LsdMap.containsKey(relation.getSyntaxOID())) {
                        LdapSyntax lsd = (LdapSyntax)ValueEditorsPreferencePage.this.syntaxOid2LsdMap.get(relation.getSyntaxOID());
                        return SchemaUtils.toString((AbstractSchemaObject)lsd);
                    }
                } else if (index == 2) {
                    ValueEditorManager.ValueEditorExtension vee = (ValueEditorManager.ValueEditorExtension)ValueEditorsPreferencePage.this.class2ValueEditorExtensionMap.get(relation.getValueEditorClassName());
                    return vee != null ? vee.name : null;
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof SyntaxValueEditorRelation) {
                SyntaxValueEditorRelation relation = (SyntaxValueEditorRelation)obj;
                if (index == 2) {
                    ValueEditorManager.ValueEditorExtension vee = (ValueEditorManager.ValueEditorExtension)ValueEditorsPreferencePage.this.class2ValueEditorExtensionMap.get(relation.getValueEditorClassName());
                    if (vee != null) {
                        if (!ValueEditorsPreferencePage.this.imageMap.containsKey(vee.icon)) {
                            Image image = vee.icon.createImage();
                            ValueEditorsPreferencePage.this.imageMap.put(vee.icon, image);
                        }
                        return (Image)ValueEditorsPreferencePage.this.imageMap.get(vee.icon);
                    }
                    return null;
                }
            }
            return null;
        }
    }

    class AttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        AttributeLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AttributeValueEditorRelation) {
                AttributeValueEditorRelation relation = (AttributeValueEditorRelation)obj;
                if (index == 0) {
                    return relation.getAttributeNumericOidOrType();
                }
                if (index == 1) {
                    if (relation.getAttributeNumericOidOrType() != null) {
                        if (ValueEditorsPreferencePage.this.attributeNames2AtdMap.containsKey(relation.getAttributeNumericOidOrType().toLowerCase())) {
                            AttributeType atd = (AttributeType)ValueEditorsPreferencePage.this.attributeNames2AtdMap.get(relation.getAttributeNumericOidOrType().toLowerCase());
                            String s = atd.getOid();
                            for (String name : atd.getNames()) {
                                if (relation.getAttributeNumericOidOrType().equalsIgnoreCase(name)) continue;
                                s = s + ", " + name;
                            }
                            return s;
                        }
                        if (ValueEditorsPreferencePage.this.attributeOid2AtdMap.containsKey(relation.getAttributeNumericOidOrType())) {
                            AttributeType atd = (AttributeType)ValueEditorsPreferencePage.this.attributeOid2AtdMap.get(relation.getAttributeNumericOidOrType());
                            return atd.toString();
                        }
                    }
                } else if (index == 2) {
                    ValueEditorManager.ValueEditorExtension vee = (ValueEditorManager.ValueEditorExtension)ValueEditorsPreferencePage.this.class2ValueEditorExtensionMap.get(relation.getValueEditorClassName());
                    return vee != null ? vee.name : null;
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof AttributeValueEditorRelation) {
                AttributeValueEditorRelation relation = (AttributeValueEditorRelation)obj;
                if (index == 2) {
                    ValueEditorManager.ValueEditorExtension vee = (ValueEditorManager.ValueEditorExtension)ValueEditorsPreferencePage.this.class2ValueEditorExtensionMap.get(relation.getValueEditorClassName());
                    if (vee != null) {
                        if (!ValueEditorsPreferencePage.this.imageMap.containsKey(vee.icon)) {
                            Image image = vee.icon.createImage();
                            ValueEditorsPreferencePage.this.imageMap.put(vee.icon, image);
                        }
                        return (Image)ValueEditorsPreferencePage.this.imageMap.get(vee.icon);
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

