/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.preferences.Messages;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AttributesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showDecoratedValuesButton;
    private final String[] ATTRIBUTE_TYPES = new String[]{Messages.getString("AttributesPreferencePage.ObjectClassAttribute"), Messages.getString("AttributesPreferencePage.MustAttributes"), Messages.getString("AttributesPreferencePage.MayAttributes"), Messages.getString("AttributesPreferencePage.OperationalAttributes")};
    private final String[] ATTRIBUTE_FONT_CONSTANTS = new String[]{"objectClassFont", "mustAttributeFont", "mayAttributeFont", "operationalAttributeFont"};
    private final String[] ATTRIBUTE_COLOR_CONSTANTS = new String[]{"objectClassColor", "mustAttributeColor", "mayAttributeColor", "operationalAttributeColor"};
    private Label[] attributeTypeLabels = new Label[this.ATTRIBUTE_TYPES.length];
    private ColorSelector[] attributeColorSelectors = new ColorSelector[this.ATTRIBUTE_TYPES.length];
    private Button[] attributeBoldButtons = new Button[this.ATTRIBUTE_TYPES.length];
    private Button[] attributeItalicButtons = new Button[this.ATTRIBUTE_TYPES.length];

    public AttributesPreferencePage() {
        super(Messages.getString("AttributesPreferencePage.Attributes"));
        super.setPreferenceStore(BrowserCommonActivator.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("AttributesPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.showDecoratedValuesButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("AttributesPreferencePage.ShowDecoratedValues"), (int)1);
        this.showDecoratedValuesButton.setSelection(!this.getPreferenceStore().getBoolean("showRawValues"));
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group colorsAndFontsGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("AttributesPreferencePage.AttributeColorsAndFonts"), (int)1);
        colorsAndFontsGroup.setLayoutData((Object)new GridData(768));
        Composite colorsAndFontsComposite = BaseWidgetUtils.createColumnContainer((Composite)colorsAndFontsGroup, (int)4, (int)1);
        for (int i = 0; i < this.ATTRIBUTE_TYPES.length; ++i) {
            this.attributeTypeLabels[i] = BaseWidgetUtils.createLabel((Composite)colorsAndFontsComposite, (String)this.ATTRIBUTE_TYPES[i], (int)1);
            this.attributeTypeLabels[i].setLayoutData((Object)new GridData(768));
            this.attributeColorSelectors[i] = new ColorSelector(colorsAndFontsComposite);
            this.attributeBoldButtons[i] = BaseWidgetUtils.createCheckbox((Composite)colorsAndFontsComposite, (String)Messages.getString("AttributesPreferencePage.Bold"), (int)1);
            this.attributeItalicButtons[i] = BaseWidgetUtils.createCheckbox((Composite)colorsAndFontsComposite, (String)Messages.getString("AttributesPreferencePage.Italic"), (int)1);
            FontData[] fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_FONT_CONSTANTS[i]);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_COLOR_CONSTANTS[i]);
            this.setColorsAndFonts(i, fontDatas, rgb);
        }
        this.applyDialogFont(composite);
        return composite;
    }

    private void setColorsAndFonts(int index, FontData[] fontDatas, RGB rgb) {
        boolean bold = this.isBold(fontDatas);
        boolean italic = this.isItalic(fontDatas);
        this.attributeColorSelectors[index].setColorValue(rgb);
        this.attributeBoldButtons[index].setSelection(bold);
        this.attributeItalicButtons[index].setSelection(italic);
    }

    private void setFontData(FontData[] fontDatas, Button boldButton, Button italicButton) {
        for (FontData fontData : fontDatas) {
            int style = 0;
            if (boldButton.getSelection()) {
                style |= 1;
            }
            if (italicButton.getSelection()) {
                style |= 2;
            }
            fontData.setStyle(style);
        }
    }

    private boolean isBold(FontData[] fontDatas) {
        boolean bold = false;
        for (FontData fontData : fontDatas) {
            if ((fontData.getStyle() & 1) == 0) continue;
            bold = true;
        }
        return bold;
    }

    private boolean isItalic(FontData[] fontDatas) {
        boolean italic = false;
        for (FontData fontData : fontDatas) {
            if ((fontData.getStyle() & 2) == 0) continue;
            italic = true;
        }
        return italic;
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("showRawValues", !this.showDecoratedValuesButton.getSelection());
        for (int i = 0; i < this.ATTRIBUTE_TYPES.length; ++i) {
            FontData[] fontDatas = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_FONT_CONSTANTS[i]);
            this.setFontData(fontDatas, this.attributeBoldButtons[i], this.attributeItalicButtons[i]);
            RGB rgb = this.attributeColorSelectors[i].getColorValue();
            PreferenceConverter.setValue((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_FONT_CONSTANTS[i], (FontData[])fontDatas);
            PreferenceConverter.setValue((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_COLOR_CONSTANTS[i], (RGB)rgb);
        }
        return true;
    }

    protected void performDefaults() {
        this.showDecoratedValuesButton.setSelection(!this.getPreferenceStore().getDefaultBoolean("showRawValues"));
        for (int i = 0; i < this.ATTRIBUTE_TYPES.length; ++i) {
            FontData[] fontDatas = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_FONT_CONSTANTS[i]);
            RGB rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)this.ATTRIBUTE_COLOR_CONSTANTS[i]);
            this.setColorsAndFonts(i, fontDatas, rgb);
        }
        super.performDefaults();
    }
}

