/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions.proxy;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class BrowserActionProxy
extends Action
implements ISelectionChangedListener,
EntryUpdateListener,
SearchUpdateListener,
BookmarkUpdateListener,
ConnectionUpdateListener {
    protected BrowserAction action;
    protected ISelectionProvider selectionProvider;

    protected BrowserActionProxy(ISelectionProvider selectionProvider, BrowserAction action, int style) {
        super(action.getText(), style);
        this.selectionProvider = selectionProvider;
        this.action = action;
        super.setImageDescriptor(action.getImageDescriptor());
        super.setActionDefinitionId(action.getCommandId());
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        ConnectionEventRegistry.addConnectionUpdateListener((ConnectionUpdateListener)this, (EventRunner)ConnectionUIPlugin.getDefault().getEventRunner());
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addSearchUpdateListener((SearchUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        EventRegistry.addBookmarkUpdateListener((BookmarkUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        this.updateAction();
    }

    protected BrowserActionProxy(ISelectionProvider selectionProvider, BrowserAction action) {
        this(selectionProvider, action, action.getStyle());
    }

    public void dispose() {
        ConnectionEventRegistry.removeConnectionUpdateListener((ConnectionUpdateListener)this);
        EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
        EventRegistry.removeSearchUpdateListener((SearchUpdateListener)this);
        EventRegistry.removeBookmarkUpdateListener((BookmarkUpdateListener)this);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.action.dispose();
        this.action = null;
    }

    public boolean isDisposed() {
        return this.action == null;
    }

    public final void entryUpdated(EntryModificationEvent entryModificationEvent) {
        if (!this.isDisposed()) {
            this.updateAction();
        }
    }

    public void searchUpdated(SearchUpdateEvent searchUpdateEvent) {
        if (!this.isDisposed()) {
            this.updateAction();
        }
    }

    public void bookmarkUpdated(BookmarkUpdateEvent bookmarkUpdateEvent) {
        if (!this.isDisposed()) {
            this.updateAction();
        }
    }

    public final void connectionUpdated(Connection connection) {
        if (!this.isDisposed()) {
            this.updateAction();
        }
    }

    public void connectionAdded(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionRemoved(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionOpened(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionClosed(Connection connection) {
        this.connectionUpdated(connection);
    }

    public void connectionFolderModified(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
        this.connectionUpdated(null);
    }

    public void inputChanged(Object input) {
        if (!this.isDisposed()) {
            this.action.setInput(input);
            this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, (ISelection)new StructuredSelection()));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isDisposed()) {
            ISelection selection = event.getSelection();
            this.action.setSelectedBrowserViewCategories(BrowserSelectionUtils.getBrowserViewCategories(selection));
            this.action.setSelectedEntries(BrowserSelectionUtils.getEntries(selection));
            this.action.setSelectedBrowserEntryPages(BrowserSelectionUtils.getBrowserEntryPages(selection));
            this.action.setSelectedSearchResults(BrowserSelectionUtils.getSearchResults(selection));
            this.action.setSelectedBrowserSearchResultPages(BrowserSelectionUtils.getBrowserSearchResultPages(selection));
            this.action.setSelectedBookmarks(BrowserSelectionUtils.getBookmarks(selection));
            this.action.setSelectedSearches(BrowserSelectionUtils.getSearches(selection));
            this.action.setSelectedAttributes(BrowserSelectionUtils.getAttributes(selection));
            this.action.setSelectedAttributeHierarchies(BrowserSelectionUtils.getAttributeHierarchie(selection));
            this.action.setSelectedValues(BrowserSelectionUtils.getValues(selection));
            this.action.setSelectedProperties(BrowserSelectionUtils.getProperties(selection));
            this.updateAction();
        }
    }

    public void updateAction() {
        if (!this.isDisposed()) {
            this.setText(this.action.getText());
            this.setToolTipText(this.action.getText());
            this.setEnabled(this.action.isEnabled());
            this.setImageDescriptor(this.action.getImageDescriptor());
            this.setChecked(this.action.isChecked());
        }
    }

    public void run() {
        if (!this.isDisposed()) {
            this.action.run();
        }
    }

    public BrowserAction getAction() {
        return this.action;
    }
}

