## IMPORTANT ##

The links below point to the current versions of the ACES technical documentation. 

Git is used to version control the LaTeX source for the documents, which is hosted here on GitHub. Thus, any updates to the documents will be visible through git commits. The PDFs generated from the most up-to-date LaTeX source are linked to below and from the ACES website.

These documents may be updated updated frequently in order to incorporate developer feedback, so please check the [ACES Documentation Manifest](http://j.mp/docsmanifest) to ensure you have the latest versions before finalizing your ACES implementation.

Please report any issues related to the documentation to acessupport@oscars.org.

#### Academy Documents ####

Download the entire document package as a [ZIP](http://j.mp/ACES-docs), or use links below to download individual documents:

_**System Documentation**_

* Documentation Guide
	* [TB-2014-001](http://j.mp/TB-2014-001) Academy Color Encoding System (ACES) Documentation Guide
* Versioning System
	* [S-2014-002](http://j.mp/S-2014-002) Academy Color Encoding System — Versioning System
* User Experience Guidelines
	* [TB-2014-002](http://j.mp/TB-2014-002) Academy Color Encoding System (ACES) Version 1.0 User Experience Guidelines
	* _**DRAFT**_ [TB-2014-013](http://j.mp/TB-2014-013) Alternate ACES Viewing Pipeline User Experience
* ACES Component Names
	* [TB-2014-012](http://j.mp/TB-2014-012) Academy Color Encoding System (ACES) Version 1.0 Component Names

_**Encodings and Metrics**_

* ACES2065-1
	* [TB-2014-004](http://j.mp/TB-2014-004) Informative Notes on SMPTE ST 2065-1 — Academy Color Encoding Specification (ACES)
* ACESproxy
	* [S-2013-001](http://j.mp/S-2013-001) ACESproxy — An Integer Log Encoding of ACES Image Data
* ACEScc
	* [S-2014-003](http://j.mp/S-2014-003) ACEScc — A Logarithmic Encoding of ACES Data for use within Color Grading Systems
* ACEScg
	* [S-2014-004](http://j.mp/S-2014-004) ACEScg — A Working Space for CGI Render and Compositing
* APD
	* [TB-2014-005](http://j.mp/TB-2014-005) Informative Notes on SMPTE ST 2065-2 — Academy Printing Density (APD) — Spectral Responsivities, Reference Measurement Device and Spectral Calculation and SMPTE ST 2065-3 Academy Density Exchange Encoding (ADX) — Encoding Printing Density (APD) Values

_**Image and Metadata Containers**_

* ACES Container
	* [TB-2014-006](http://j.mp/TB-2014-006) Informative Notes on SMPTE ST 2065-4 — ACES Image Container File Layout
* ADX Container 
	* [TB-2014-007](http://j.mp/TB-2014-007) Informative Notes on SMPTE ST 268:2014 — File Format for Digital Moving Picture Exchange (DPX)
* ACESclip
	* [TB-2014-009](http://j.mp/TB-2014-009) Academy Color Encoding System (ACES) Clip-level Metadata File Format Definition and Usage
* Common LUT Format
	* _**DRAFT**_ [S-2014-006](http://j.mp/S-2014-006) A Common File Format for Look-Up Tables 
* Look Transforms (LMTs)
	* [TB-2014-010](http://j.mp/TB-2014-010) Design, Integration and Use of ACES Look Modification Transforms

_**Procedures**_

* Input Transforms (IDTs)
	* _**DRAFT**_ [P-2013-001](http://j.mp/P-2013-001) Recommended Procedures for the Creation and Use of Digital Camera System Input Device Transforms (IDTs)

#### International Standards ####

Some ACES-related documents are only available as international standards. Some informative notes on the international standards are provided in the Technical Bulletins that are part of the Academy Documents. The following is a list of ACES standards documents:

* SMPTE ST 2065-1:2012 — Academy Color Encoding Specification (ACES)
* SMPTE ST 2065-2:2012 — Academy Printing Density (APD) — Spectral Responsivities, Reference Measurement Device and Spectral Calculation 
* SMPTE ST 2065-3:2012 — Academy Density Exchange Encoding (ADX) — Encoding Academy Printing Density (APD) Values
* SMPTE ST 2065-4:2013 — ACES Image Container File Layout

