/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.MergedLogSource;
import org.apache.zookeeper.graph.TransactionEntry;

public class MeasureThroughput {
    private static final int MS_PER_SEC = 1000;
    private static final int MS_PER_MIN = 60000;
    private static final int MS_PER_HOUR = 3600000;

    public static void main(String[] args) throws IOException {
        MergedLogSource source = new MergedLogSource(args);
        PrintStream ps_ms = new PrintStream(new BufferedOutputStream(new FileOutputStream("throughput-ms.out")));
        PrintStream ps_sec = new PrintStream(new BufferedOutputStream(new FileOutputStream("throughput-sec.out")));
        PrintStream ps_min = new PrintStream(new BufferedOutputStream(new FileOutputStream("throughput-min.out")));
        PrintStream ps_hour = new PrintStream(new BufferedOutputStream(new FileOutputStream("throughput-hour.out")));
        System.out.println(source);
        LogIterator iter = source.iterator();
        long currentms = 0L;
        long currentsec = 0L;
        long currentmin = 0L;
        long currenthour = 0L;
        HashSet<Long> zxids_ms = new HashSet<Long>();
        long zxid_sec = 0L;
        long zxid_min = 0L;
        long zxid_hour = 0L;
        while (iter.hasNext()) {
            LogEntry e = (LogEntry)iter.next();
            TransactionEntry cxn = (TransactionEntry)e;
            long ms = cxn.getTimestamp();
            long sec = ms / 1000L;
            long min = ms / 60000L;
            long hour = ms / 3600000L;
            if (currentms != ms && currentms != 0L) {
                ps_ms.println("" + currentms + " " + zxids_ms.size());
                zxid_sec += (long)zxids_ms.size();
                zxid_min += (long)zxids_ms.size();
                zxid_hour += (long)zxids_ms.size();
                zxids_ms.clear();
            }
            if (currentsec != sec && currentsec != 0L) {
                ps_sec.println("" + currentsec * 1000L + " " + zxid_sec);
                zxid_sec = 0L;
            }
            if (currentmin != min && currentmin != 0L) {
                ps_min.println("" + currentmin * 60000L + " " + zxid_min);
                zxid_min = 0L;
            }
            if (currenthour != hour && currenthour != 0L) {
                ps_hour.println("" + currenthour * 3600000L + " " + zxid_hour);
                zxid_hour = 0L;
            }
            currentms = ms;
            currentsec = sec;
            currentmin = min;
            currenthour = hour;
            zxids_ms.add(cxn.getZxid());
        }
        iter.close();
        ps_ms.close();
        ps_sec.close();
        ps_min.close();
        ps_hour.close();
    }
}

