/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthFailNotifyTest
extends ClientBase {
    private AtomicInteger authFailed = new AtomicInteger(0);

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadSaslAuthNotifiesWatch() throws Exception {
        TestableZooKeeper zk = this.createClient();
        AtomicInteger atomicInteger = this.authFailed;
        synchronized (atomicInteger) {
            this.authFailed.wait();
        }
        Assert.assertEquals((long)this.authFailed.get(), (long)1L);
        zk.close();
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        try {
            File tmpDir = SaslAuthFailNotifyTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super\"\n       password=\"test1\";\n};\n");
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                AtomicInteger atomicInteger = SaslAuthFailNotifyTest.this.authFailed;
                synchronized (atomicInteger) {
                    SaslAuthFailNotifyTest.this.authFailed.incrementAndGet();
                    SaslAuthFailNotifyTest.this.authFailed.notify();
                }
            } else {
                super.process(event);
            }
        }
    }
}

