/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import junit.framework.Assert;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DatadirCleanupManagerTest {
    private DatadirCleanupManager purgeMgr;
    private String snapDir;
    private String dataLogDir;

    @Before
    public void setUp() throws Exception {
        File dataDir = ClientBase.createTmpDir();
        this.snapDir = dataDir.getAbsolutePath();
        this.dataLogDir = dataDir.getAbsolutePath();
    }

    @Test
    public void testPurgeTask() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, 1);
        this.purgeMgr.start();
        Assert.assertEquals((String)"Data log directory is not set as configured", (String)this.dataLogDir, (String)this.purgeMgr.getDataLogDir());
        Assert.assertEquals((String)"Snapshot directory is not set as configured", (String)this.snapDir, (String)this.purgeMgr.getSnapDir());
        Assert.assertEquals((String)"Snapshot retain count is not set as configured", (int)3, (int)this.purgeMgr.getSnapRetainCount());
        Assert.assertEquals((String)"Purge task is not started", (Object)DatadirCleanupManager.PurgeTaskStatus.STARTED, (Object)this.purgeMgr.getPurgeTaskStatus());
        this.purgeMgr.shutdown();
        Assert.assertEquals((String)"Purge task is still running after shutdown", (Object)DatadirCleanupManager.PurgeTaskStatus.COMPLETED, (Object)this.purgeMgr.getPurgeTaskStatus());
    }

    @Test
    public void testWithZeroPurgeInterval() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, 0);
        this.purgeMgr.start();
        Assert.assertEquals((String)"Purge task is scheduled with zero purge interval", (Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus());
        this.purgeMgr.shutdown();
        Assert.assertEquals((String)"Purge task is scheduled with zero purge interval", (Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus());
    }

    @Test
    public void testWithNegativePurgeInterval() throws Exception {
        this.purgeMgr = new DatadirCleanupManager(this.snapDir, this.dataLogDir, 3, -1);
        this.purgeMgr.start();
        Assert.assertEquals((String)"Purge task is scheduled with negative purge interval", (Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus());
        this.purgeMgr.shutdown();
        Assert.assertEquals((String)"Purge task is scheduled with negative purge interval", (Object)DatadirCleanupManager.PurgeTaskStatus.NOT_STARTED, (Object)this.purgeMgr.getPurgeTaskStatus());
    }

    @After
    public void tearDown() throws Exception {
        if (this.purgeMgr != null) {
            this.purgeMgr.shutdown();
        }
    }
}

