/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "PrintDiscDialog.h"
#include "EnterStringDialog.h"

//(*InternalHeaders(PrintDiscDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/msgdlg.h>
#include <wx/file.h>
#include <wx/image.h>
#include <wx/bitmap.h>
#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/colour.h>
#include <wx/gdicmn.h>
#include <wx/arrstr.h>

//(*IdInit(PrintDiscDialog)
const long PrintDiscDialog::ID_PANEL2 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT1 = wxNewId();
const long PrintDiscDialog::ID_CHOICE1 = wxNewId();
const long PrintDiscDialog::ID_STATICLINE1 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT2 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT3 = wxNewId();
const long PrintDiscDialog::ID_SPINCTRL1 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT5 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT4 = wxNewId();
const long PrintDiscDialog::ID_SPINCTRL2 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT6 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT8 = wxNewId();
const long PrintDiscDialog::ID_SPINCTRL3 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT9 = wxNewId();
const long PrintDiscDialog::ID_STATICTEXT7 = wxNewId();
const long PrintDiscDialog::ID_BUTTON4 = wxNewId();
const long PrintDiscDialog::ID_BUTTON5 = wxNewId();
const long PrintDiscDialog::ID_STATICLINE2 = wxNewId();
const long PrintDiscDialog::ID_BUTTON1 = wxNewId();
const long PrintDiscDialog::ID_BUTTON2 = wxNewId();
const long PrintDiscDialog::ID_BUTTON3 = wxNewId();
const long PrintDiscDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(PrintDiscDialog,wxDialog)
	//(*EventTable(PrintDiscDialog)
	//*)
END_EVENT_TABLE()

PrintDiscDialog::PrintDiscDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    HelpText = _("Welcome!\nPrinting on disc is not a simple operation, but you should be able to make success of it.\n\nAt first check the list of supported printers if yours is listed or not. If it is listed just choose it and click contiue.\n\nOtherwise you will have to find out the good position of the disc by yourself. If you make it save the configuration. And please send the $HOME/.discwrapper/printermodels0 file to nmatra@citromail.hu. So the next release will include your printer.\n\nBy the way it's probable that similar models work with a common configuration.\n\n Thank You");

    DiscPosX = DiscPosY = CDiscPosX = CDiscPosY = SupportedModels = MaxModel = 0;
    DiscSurf = CDiscSurf = 612;

	//(*Initialize(PrintDiscDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer6;
	wxBoxSizer* BoxSizer5;
	wxBoxSizer* BoxSizer7;
	wxBoxSizer* BoxSizer8;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxFlexGridSizer* FlexGridSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, id, _("Printing on disc"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Panel2 = new wxPanel(Panel1, ID_PANEL2, wxDefaultPosition, wxSize(300,400), wxTAB_TRAVERSAL, _T("ID_PANEL2"));
	BoxSizer3->Add(Panel2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4 = new wxBoxSizer(wxVERTICAL);
	BoxSizer5 = new wxBoxSizer(wxHORIZONTAL);
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("Printer:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	BoxSizer5->Add(StaticText1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Choice1 = new wxChoice(Panel1, ID_CHOICE1, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
	Choice1->SetSelection( Choice1->Append(_("Custom")) );
	BoxSizer5->Add(Choice1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(BoxSizer5, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticLine1 = new wxStaticLine(Panel1, ID_STATICLINE1, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
	BoxSizer4->Add(StaticLine1, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText2 = new wxStaticText(Panel1, ID_STATICTEXT2, _("Position from the center of the page:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
	BoxSizer4->Add(StaticText2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1 = new wxFlexGridSizer(3, 3, 0, 0);
	StaticText3 = new wxStaticText(Panel1, ID_STATICTEXT3, _("Horizontal"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SpinCtrl1 = new wxSpinCtrl(Panel1, ID_SPINCTRL1, _T("0"), wxDefaultPosition, wxDefaultSize, 0, -1240, 1240, 0, _T("ID_SPINCTRL1"));
	SpinCtrl1->SetValue(_T("0"));
	FlexGridSizer1->Add(SpinCtrl1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText5 = new wxStaticText(Panel1, ID_STATICTEXT5, _("pixel"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	FlexGridSizer1->Add(StaticText5, 1, wxTOP|wxBOTTOM|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(Panel1, ID_STATICTEXT4, _("Vertical"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SpinCtrl2 = new wxSpinCtrl(Panel1, ID_SPINCTRL2, _T("0"), wxDefaultPosition, wxDefaultSize, 0, -1754, 1754, 0, _T("ID_SPINCTRL2"));
	SpinCtrl2->SetValue(_T("0"));
	FlexGridSizer1->Add(SpinCtrl2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(Panel1, ID_STATICTEXT6, _("pixel"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	FlexGridSizer1->Add(StaticText6, 1, wxTOP|wxBOTTOM|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText8 = new wxStaticText(Panel1, ID_STATICTEXT8, _("Surface"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT8"));
	FlexGridSizer1->Add(StaticText8, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SpinCtrl3 = new wxSpinCtrl(Panel1, ID_SPINCTRL3, _T("612"), wxDefaultPosition, wxDefaultSize, 0, 100, 612, 612, _T("ID_SPINCTRL3"));
	SpinCtrl3->SetValue(_T("612"));
	FlexGridSizer1->Add(SpinCtrl3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticText9 = new wxStaticText(Panel1, ID_STATICTEXT9, _("pixel"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT9"));
	FlexGridSizer1->Add(StaticText9, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(FlexGridSizer1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer7 = new wxBoxSizer(wxVERTICAL);
	StaticText7 = new wxStaticText(Panel1, ID_STATICTEXT7, _("%fmm\n%fmm\n%fmm"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT7"));
	BoxSizer7->Add(StaticText7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(BoxSizer7, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer8 = new wxBoxSizer(wxHORIZONTAL);
	Button4 = new wxButton(Panel1, ID_BUTTON4, _("Save layout"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
	BoxSizer8->Add(Button4, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button5 = new wxButton(Panel1, ID_BUTTON5, _("Delete layout"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	Button5->Disable();
	BoxSizer8->Add(Button5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4->Add(BoxSizer8, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(BoxSizer4, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticLine2 = new wxStaticLine(Panel1, ID_STATICLINE2, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE2"));
	BoxSizer2->Add(StaticLine2, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel1, ID_BUTTON1, _("Help"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer6->Add(Button1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer6->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer6->Add(Button2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(Panel1, ID_BUTTON3, _("Continue"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	BoxSizer6->Add(Button3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer6, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);

	Panel2->Connect(wxEVT_PAINT,(wxObjectEventFunction)&PrintDiscDialog::OnPaintPreview,0,this);
	Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&PrintDiscDialog::OnPrinterModelSelect);
	Connect(ID_SPINCTRL1,wxEVT_COMMAND_SPINCTRL_UPDATED,(wxObjectEventFunction)&PrintDiscDialog::OnSpinCtrlChange);
	Connect(ID_SPINCTRL2,wxEVT_COMMAND_SPINCTRL_UPDATED,(wxObjectEventFunction)&PrintDiscDialog::OnSpinCtrlChange);
	Connect(ID_SPINCTRL3,wxEVT_COMMAND_SPINCTRL_UPDATED,(wxObjectEventFunction)&PrintDiscDialog::OnSpinCtrlChange);
	Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PrintDiscDialog::NewLayout);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PrintDiscDialog::On_Del_layout);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PrintDiscDialog::OnHelp);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PrintDiscDialog::OnCancel);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PrintDiscDialog::OnContinue);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&PrintDiscDialog::OnInit);
	//*)

}

PrintDiscDialog::~PrintDiscDialog()
{
	//(*Destroy(PrintDiscDialog)
	//*)
}


void PrintDiscDialog::OnCancel(wxCommandEvent& event)
{
    SaveList();
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void PrintDiscDialog::OnContinue(wxCommandEvent& event)
{
    SaveList();
    ex_point = wxPoint(SpinCtrl1->GetValue(), SpinCtrl2->GetValue());
    ex_surface = SpinCtrl3->GetValue();
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void PrintDiscDialog::OnHelp(wxCommandEvent& event)
{
    wxMessageDialog(this, HelpText, _T("DiscWrapper"), wxICON_INFORMATION , wxDefaultPosition).ShowModal();
}

void PrintDiscDialog::OnPrinterModelSelect(wxCommandEvent& event)
{
    int i = Choice1->GetCurrentSelection()-1;
    if ( i != -1 )
    {
        SpinCtrl1->SetValue(DiscPosX = ModX[i]);
        SpinCtrl2->SetValue(DiscPosY = ModY[i]);
        SpinCtrl3->SetValue(DiscSurf = ModS[i]);
        Panel2->Refresh();

        StaticText7->SetLabel(wxString::Format(_("%fmm\n%fmm\n%fmm"), SpinCtrl1->GetValue()/11.8110, SpinCtrl2->GetValue()/11.8110, SpinCtrl3->GetValue()/11.8110));

        if ( i < SupportedModels )
        {
            Button5->Disable();
            Button4->Disable();
            SpinCtrl1->Disable();
            SpinCtrl2->Disable();
            SpinCtrl3->Disable();
        }
        else
        {
            Button5->Enable();
            Button4->Enable();
            SpinCtrl1->Enable();
            SpinCtrl2->Enable();
            SpinCtrl3->Enable();
        }

    }
    else
    {
        Button5->Disable();

        Button4->Enable();
        SpinCtrl1->Enable();
        SpinCtrl2->Enable();
        SpinCtrl3->Enable();
    }
}

void PrintDiscDialog::OnSpinCtrlChange(wxSpinEvent& event)
{
    if ( 0 == Choice1->GetCurrentSelection() )
    {
        CDiscPosX = SpinCtrl1->GetValue();
        CDiscPosY = SpinCtrl2->GetValue();
        CDiscSurf = SpinCtrl3->GetValue();
    }
    DiscPosX = SpinCtrl1->GetValue();
    DiscPosY = SpinCtrl2->GetValue();
    DiscSurf = SpinCtrl3->GetValue();
    Panel2->Refresh();


    StaticText7->SetLabel(wxString::Format(_("%fmm\n%fmm\n%fmm"), SpinCtrl1->GetValue()/11.8110, SpinCtrl2->GetValue()/11.8110, SpinCtrl3->GetValue()/11.8110));
}

void PrintDiscDialog::OnPaintPreview(wxPaintEvent& event)
{
    wxPaintDC dc(Panel2);
    //wxGCDC dc(pdc);
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.Clear();


        float maxX = 2480;   // Get the width and the height of the current pattern
        float maxY = 3508;
        float marginX = 20;     // Set margins
        float marginY = 20;

        maxX += (2*marginX);    // Add margins to resolution
        maxY += (2*marginY);
        maxX = maxX;
        maxY = maxY;
        int w, h;
        dc.GetSize(&w, &h);     // Get the width and height of the selected panel

        float scaleX=(float)(w/maxX);   // Calculate and set scale
        float scaleY=(float)(h/maxY);
        float actualScale = wxMin(scaleX,scaleY);
        float posX = (float)((w - (2480*actualScale))/2.0);
        float posY = (float)((h - (3508*actualScale))/2.0);
        dc.SetUserScale(actualScale, actualScale);

        dc.SetDeviceOrigin( (long)posX, (long)posY );   // Prepare DC
        dc.SetBackgroundMode(wxTRANSPARENT);

        dc.SetBrush(*wxLIGHT_GREY_BRUSH);  //Draw bounders
        dc.SetPen(*wxWHITE_PEN);
        dc.DrawCircle(wxPoint(1240+DiscPosX, 1754-DiscPosY), 700);
        dc.SetBrush(*wxWHITE_BRUSH);  //Draw bounders
        dc.DrawCircle(wxPoint(1240+DiscPosX, 1754-DiscPosY), 700-DiscSurf);

        //dc.DrawBitmap(, 0, 0, 0);
        dc.SetBrush(*wxTRANSPARENT_BRUSH);  //Draw bounders
        dc.SetPen(*wxGREY_PEN);
        dc.DrawRectangle(0, 0, 2480, 3508);
        dc.DrawCircle(wxPoint(1240, 1754), 700);
        dc.DrawCircle(wxPoint(1240, 1754), 284);
        dc.DrawCircle(wxPoint(1240, 1754), 88);


        dc.SetPen(*wxBLACK_PEN);
        dc.DrawCircle(wxPoint(1240+DiscPosX, 1754-DiscPosY), 700);
        dc.DrawCircle(wxPoint(1240+DiscPosX, 1754-DiscPosY), 284);
        dc.DrawCircle(wxPoint(1240+DiscPosX, 1754-DiscPosY), 88);

}

void PrintDiscDialog::OnInit(wxInitDialogEvent& event)
{
    if ( !wxFile::Exists(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("printermodels1")) )
    {
        wxMessageDialog(this, HelpText, _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

        // TODO: Set defaults and save list
    }

	//Read&load list

    int i, j, g, x = 0, y = 0, s = 612;
    wxChar *c;
    wxFile file;
    wxString path, temp;

    ModelNames.Clear();

    path = CFs.DataPath()+_T("printermodels");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        c = new wxChar[12];
        for ( g = 0 ; g < 12 ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            temp = wxString(c, 12);
        delete[] c;

        if ( temp != _T("MNándor...DW") )
        {
            //wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            file.Close();
            return;
        }
        else
        {
            file.Seek(0, wxFromStart);
            i = 0;
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i += buf;
            }
            file.Seek(-4, wxFromEnd);
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i -= buf;
            }
            file.Seek(-4, wxFromEnd);
            file.Read(&j, 4);
            if ( i != j )
            {
                //wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                file.Close();
                return;
            }
            else
            {
                file.Seek(48, wxFromStart);

                file.Read(&i, sizeof(int)); // Database version
                // TODO (nandor#1#): Do something with version
                file.Read(&SupportedModels, sizeof(int));
                ModX = new int[SupportedModels];
                ModY = new int[SupportedModels];
                ModS = new int[SupportedModels];
                for ( i = 0 ; i < SupportedModels ; i++ )
                {
                    file.Read(&j, sizeof(int));

                    c = new wxChar[j];
                    for ( g = 0 ; g < j ; g++ )
                        file.Read(&c[g], sizeof(wxChar));
                        temp = wxString(c, j);
                    delete[] c;

                    ModelNames.Add(temp);
                    Choice1->Append(temp);

                    file.Read(&ModX[i], sizeof(int));
                    file.Read(&ModY[i], sizeof(int));
                    file.Read(&ModS[i], sizeof(int));
                  // ModS[i] = 612;
                }
                file.Close();
            }
        }
    }

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("printermodels1");
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        c = new wxChar[12];
        for ( g = 0 ; g < 12 ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            temp = wxString(c, 12);
        delete[] c;

        if ( temp != _T("MNándor...DW") )
        {
            //wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            file.Close();
            return;
        }
        else
        {
            file.Seek(0, wxFromStart);
            i = 0;
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i += buf;
            }
            file.Seek(-4, wxFromEnd);
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i -= buf;
            }
            file.Seek(-4, wxFromEnd);
            file.Read(&j, 4);
            if ( i != j )
            {
                //wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                file.Close();
                return;
            }
            else
            {
                file.Seek(48, wxFromStart);

                file.Read(&x, sizeof(int));
                file.Read(&y, sizeof(int));
                file.Read(&s, sizeof(int));

                file.Read(&MaxModel, sizeof(int));

                if ( SupportedModels != 0 )
                {
                    int temp1[SupportedModels], temp2[SupportedModels], temp3[SupportedModels];

                    for ( i = 0 ; i < SupportedModels ; i++ )
                    {
                        temp1[i] = ModX[i];
                        temp2[i] = ModY[i];
                        temp3[i] = ModS[i];
                    }

                    delete[] ModX;
                    delete[] ModY;
                    delete[] ModS;

                    ModX = new int[SupportedModels+MaxModel];
                    ModY = new int[SupportedModels+MaxModel];
                    ModS = new int[SupportedModels+MaxModel];

                    for ( i = 0 ; i < SupportedModels ; i++ )
                    {
                        ModX[i] = temp1[i];
                        ModY[i] = temp2[i];
                        ModS[i] = temp3[i];
                    }
                }
                else
                {
                    ModX = new int[MaxModel];
                    ModY = new int[MaxModel];
                    ModS = new int[MaxModel];
                }

                for ( i = 0 ; i < MaxModel ; i++ )
                {
                    file.Read(&j, sizeof(int));

                    c = new wxChar[j];
                    for ( g = 0 ; g < j ; g++ )
                        file.Read(&c[g], sizeof(wxChar));
                        temp = wxString(c, j);
                    delete[] c;

                    ModelNames.Add(temp);
                    Choice1->Append(temp);

                    file.Read(&ModX[SupportedModels+i], sizeof(int));
                    file.Read(&ModY[SupportedModels+i], sizeof(int));
                    file.Read(&ModS[SupportedModels+i], sizeof(int));
                }

                /*file.Read(&i, sizeof(int)); // Database version
                file.Read(&SupportedModels, sizeof(int));
                ModX = new int[SupportedModels];
                ModY = new int[SupportedModels];
                for ( i = 0 ; i < SupportedModels ; i++ )
                {
                    file.Read(&j, sizeof(int));

                    c = new wxChar[j];
                    for ( g = 0 ; g < j ; g++ )
                        file.Read(&c[g], sizeof(wxChar));
                        temp = wxString(c, j);
                    delete[] c;

                    ModelNames.Add(temp);
                    Choice1->Append(temp);

                    file.Read(&ModX[i], sizeof(int));
                    file.Read(&ModY[i], sizeof(int));
                }*/
                file.Close();
            }
        }
    }
/*
    if ( wxFile::Exists(path) == true )
    {
        file.Open(path, wxFile::read);

        c = new wxChar[12];
        for ( g = 0 ; g < 12 ; g++ )
            file.Read(&c[g], sizeof(wxChar));
            temp = wxString(c, 12);
        delete[] c;

        if ( temp != _T("MNándor...DW") )
        {
            wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
            file.Close();
            return;
        }
        else
        {
            file.Seek(0, wxFromStart);
            i = 0;
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i += buf;
            }
            file.Seek(-4, wxFromEnd);
            while ( !file.Eof() )
            {
                unsigned char buf;
                file.Read(&buf, 1);
                i -= buf;
            }
            file.Seek(-4, wxFromEnd);
            file.Read(&j, 4);
            if ( i != j )
            {
                wxMessageDialog(this, _("Printer model list is corrupted."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                file.Close();
                return;
            }
            else
            {
                file.Seek(48, wxFromStart);
                file.Read(&x, sizeof(int));
                file.Read(&y, sizeof(int));
              //  file.Read(&i, sizeof(int)); // Database version
                file.Read(&MaxModel, sizeof(int));
              //  file.Read(&SupportedModels, sizeof(int));
                if ( SupportedModels != 0 )
                {
                    int temp1[SupportedModels], temp2[SupportedModels];

                    for ( i = 0 ; i < SupportedModels ; i++ )
                    {
                        temp1[i] = ModX[i];
                        temp2[i] = ModY[i];
                    }

                    delete[] ModX;
                    delete[] ModY;

                    for ( i = 0 ; i < SupportedModels ; i++ )
                    {
                        ModX[i] = temp1[i];
                        ModY[i] = temp2[i];
                    }
                }
                else
                {
                    ModX = new int[MaxModel];
                    ModY = new int[MaxModel];
                }

                for ( i = 0 ; i < MaxModel ; i++ )
                {
                    file.Read(&j, sizeof(int));

                    c = new wxChar[j];
                    for ( g = 0 ; g < j ; g++ )
                        file.Read(&c[g], sizeof(wxChar));
                        temp = wxString(c, j);
                    delete[] c;

                    ModelNames.Add(temp);
                    Choice1->Append(temp);

                    file.Read(&ModX[SupportedModels+i], sizeof(int));
                    file.Read(&ModY[SupportedModels+i], sizeof(int));
                }
                file.Close();
            }
        }
    }
*/
    SpinCtrl1->SetValue(x);
    SpinCtrl2->SetValue(y);
    SpinCtrl3->SetValue(s);

    DiscPosX = x;
    DiscPosY = y;
    DiscSurf = s;
    Panel2->Refresh();

    StaticText7->SetLabel(wxString::Format(_("%fmm\n%fmm\n%fmm"), SpinCtrl1->GetValue()/11.8110, SpinCtrl2->GetValue()/11.8110, SpinCtrl3->GetValue()/11.8110));
}

void PrintDiscDialog::SaveList()
{
    /*if ( MaxModel == 0 )
        return;*/

    int i, j;
    wxFile file;
    wxString path;

    path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("printermodels1");


    file.Create(path, true, wxS_DEFAULT);
    wxString oyi = _T("MNándor...DW");
    for ( i = 0 ; i < oyi.Len() ; i++ )
    {
        wxChar ch = oyi.GetChar(i);
        file.Write(&ch, sizeof(wxChar));
    }

    file.Write(&CDiscPosX, sizeof(int));
    file.Write(&CDiscPosY, sizeof(int));
    file.Write(&CDiscSurf, sizeof(int));

   // i = 1;  // Database release
   // file.Write(&i, sizeof(i));


    i = MaxModel;   // Layouts in this database
    file.Write(&i, sizeof(i));


   // i = 0;  // Supported printers
   // file.Write(&i, sizeof(i));


    for ( i = SupportedModels ; i < SupportedModels+MaxModel ; i++ )
    {
        int g = ModelNames.Item(i).Len();
        file.Write(&g, sizeof(int));

        for ( j = 0 ; j < g ; j++ )
        {
            wxChar ch = ModelNames.Item(i).GetChar(j);
            file.Write(&ch, sizeof(wxChar));
        }

        file.Write(&ModX[i], sizeof(int));
        file.Write(&ModY[i], sizeof(int));
        file.Write(&ModS[i], sizeof(int));
    }
    file.Close();

    file.Open(path, wxFile::read);
    file.Seek(0, wxFromStart);
    i = 0;

    while ( !file.Eof() )
    {
        unsigned char buf;
        file.Read(&buf, 1);
        i += buf;
    }
    file.Close();
    file.Open(path, wxFile::write_append);
    file.Write(&i, 4);
    file.Close();

}

void PrintDiscDialog::NewLayout(wxCommandEvent& event)
{
    if ( 0 == Choice1->GetCurrentSelection() )
    {
        EnterStringDialog dialog(this,wxID_ANY);
        if ( dialog.ShowModal() == wxID_OK )
        {
            MaxModel++;

            ModelNames.Add(dialog.GetModel());
            Choice1->Append(dialog.GetModel());

            int i, tempi1[SupportedModels+MaxModel-1], tempi2[SupportedModels+MaxModel-1], tempi3[SupportedModels+MaxModel-1];

            for ( i = 0 ; i < SupportedModels+MaxModel-1 ; i++ )
            {
                tempi1[i] = ModX[i];
                tempi2[i] = ModY[i];
                tempi3[i] = ModS[i];
            }

            delete[] ModX;
            delete[] ModY;
            delete[] ModS;

            ModX = new int [SupportedModels+MaxModel];
            ModY = new int [SupportedModels+MaxModel];
            ModS = new int [SupportedModels+MaxModel];

            for ( i = 0 ; i < SupportedModels+MaxModel-1 ; i++ )
            {
                ModX[i] = tempi1[i];
                ModY[i] = tempi2[i];
                ModS[i] = tempi3[i];
            }

            ModX[SupportedModels+MaxModel-1] = SpinCtrl1->GetValue();
            ModY[SupportedModels+MaxModel-1] = SpinCtrl2->GetValue();
            ModS[SupportedModels+MaxModel-1] = SpinCtrl3->GetValue();
        }
        else
            return;
    }
    else
    {
        if ( wxMessageDialog(this, _("Overwrite current model?"), _T("DiscWrapper"), wxYES_NO , wxDefaultPosition).ShowModal() == wxID_YES )
        {
            ModX[Choice1->GetCurrentSelection()-1] = SpinCtrl1->GetValue();
            ModY[Choice1->GetCurrentSelection()-1] = SpinCtrl2->GetValue();
            ModS[Choice1->GetCurrentSelection()-1] = SpinCtrl3->GetValue();
        }
        else
        {
            EnterStringDialog dialog(this,wxID_ANY);
            if ( dialog.ShowModal() == wxID_OK )
            {
                MaxModel++;

                ModelNames.Add(dialog.GetModel());
                Choice1->Append(dialog.GetModel());

                int i, tempi1[SupportedModels+MaxModel-1], tempi2[SupportedModels+MaxModel-1], tempi3[SupportedModels+MaxModel-1];

                for ( i = 0 ; i < SupportedModels+MaxModel-1 ; i++ )
                {
                    tempi1[i] = ModX[i];
                    tempi2[i] = ModY[i];
                    tempi3[i] = ModS[i];
                }

                delete[] ModX;
                delete[] ModY;
                delete[] ModS;

                ModX = new int [SupportedModels+MaxModel];
                ModY = new int [SupportedModels+MaxModel];
                ModS = new int [SupportedModels+MaxModel];

                for ( i = 0 ; i < SupportedModels+MaxModel-1 ; i++ )
                {
                    ModX[i] = tempi1[i];
                    ModY[i] = tempi2[i];
                    ModS[i] = tempi3[i];
                }

                ModX[SupportedModels+MaxModel-1] = SpinCtrl1->GetValue();
                ModY[SupportedModels+MaxModel-1] = SpinCtrl2->GetValue();
                ModS[SupportedModels+MaxModel-1] = SpinCtrl3->GetValue();
            }
            else
                return;
        }
    }

    SaveList();
}

void PrintDiscDialog::On_Del_layout(wxCommandEvent& event)
{
    if ( wxMessageDialog(this, _("Delete current model?"), _T("DiscWrapper"), wxYES_NO , wxDefaultPosition).ShowModal() == wxID_YES )
    {
        int del = Choice1->GetCurrentSelection()-1;
        MaxModel--;

        ModelNames.RemoveAt(del);
        Choice1->Clear();
        Choice1->SetSelection( Choice1->Append(_("Custom")) );

        int i, j, tempi1[SupportedModels+MaxModel], tempi2[SupportedModels+MaxModel], tempi3[SupportedModels+MaxModel];

        for ( i = 0 ; i < ModelNames.Count() ; i++ )
            Choice1->Append(ModelNames.Item(i));

        for ( i = 0 ; i < del ; i++ )
        {
            tempi1[i] = ModX[i];
            tempi2[i] = ModY[i];
            tempi3[i] = ModS[i];
        }

        for ( j = i, i++ ; j < SupportedModels+MaxModel ; i++, j++ )
        {
            tempi1[j] = ModX[i];
            tempi2[j] = ModY[i];
            tempi3[j] = ModS[i];
        }


        delete[] ModX;
        delete[] ModY;
        delete[] ModS;

        ModX = new int [SupportedModels+MaxModel];
        ModY = new int [SupportedModels+MaxModel];
        ModS = new int [SupportedModels+MaxModel];

        for ( i = 0 ; i < SupportedModels+MaxModel ; i++ )
        {
            ModX[i] = tempi1[i];
            ModY[i] = tempi2[i];
            ModS[i] = tempi3[i];
        }

        SaveList();

        Button5->Disable();
    }
}
