/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY || FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperMain.h"
#include "ExportDialog.h"
#include "PrintDiscDialog.h"

#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/dcmemory.h>
#include <wx/file.h>
#include <wx/filedlg.h>

void DiscWrapperFrame::OnToolBar_Refresh_Clicked(wxCommandEvent& event) // Refresh preview
{
    UpdPview = true;

    DrawDC();  // Refresh currently viewed pattern
}

void DiscWrapperFrame::OnPaint(wxPaintEvent& event)     // Preview drawing
{
    DrawDC();  // Refresh currently viewed pattern
}

void DiscWrapperFrame::RDO()    // Refresh preview
{
    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Front") )   // Find selected pattern
    {
        PanelF->Refresh();
    }
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Inside") )
    {
        PanelI->Refresh();
    }
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Back") )
    {
        PanelB->Refresh();
    }
    else
    {
        PanelD->Refresh();
    }
}

int DiscWrapperFrame::GetBackWidth(int Cpage)    //
{
    int value = 0;
    if ( Cpage == 0 )
        switch(Database->PDC){
            case 0:
                value = 1429;
                break;
            case 1:
                value = 1429;
                break;
            case 2:
                value = 3224;
                break;
            case 3:
                value = 3153;
                break;
        }
    else if ( Cpage == 1 )
        switch(Database->PDC){
            case 0:
                value = 1429;
                break;
            case 1:
                value = 1429;
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else if ( Cpage == 2 )
        switch(Database->PDC){
            case 0:
                value = 1780;
                break;
            case 1:
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else
    {
        value = 1400;
    }

    return(value);
}

int DiscWrapperFrame::GetBackHeight(int Cpage)    //
{
    int value = 0;
    if ( Cpage == 0 )
        switch(Database->PDC){
            case 0:
                value = 1417;
                break;
            case 1:
                value = 1417;
                break;
            case 2:
                value = 2182;
                break;
            case 3:
                value = 2182;
                break;
        }
    else if ( Cpage == 1 )
        switch(Database->PDC){
            case 0:
                value = 1417;
                break;
            case 1:
                value = 1417;
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else if ( Cpage == 2 )
        switch(Database->PDC){
            case 0:
                value = 1393;
                break;
            case 1:
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else
    {
        value = 1400;
    }

    return(value);
}

void DiscWrapperFrame::DrawDC()    // The Drawing stuff (preview)
{
    int Cpage = GetCurrentPage();

    wxPaintDC pdc(GetCurrentPanel());

    int w, h;
    pdc.GetSize(&w, &h);

    if ( !Pview.IsOk() || UpdPview || ( wxSize(w, h) != UpdSize ) )
    {
        wxMemoryDC memDC;
        wxBitmap bitmap(GetBackWidth(Cpage), GetBackHeight(Cpage));
        memDC.SelectObject(bitmap);

        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.SetBackgroundMode(wxTRANSPARENT);

        memDC.Clear();

        DrawImages(memDC, Cpage, true);

        memDC.SetBrush(*wxTRANSPARENT_BRUSH);  //Draw bounders
        //memDC.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 2, wxLONG_DASH));

        memDC.SelectObject(wxNullBitmap);


        int maxX = GetBackWidth(Cpage);   // Get the width && the height of the current pattern
        int maxY = GetBackHeight(Cpage);
        int marginX = 50;     // Set margins
        int marginY = 50;
        maxX += (2*marginX);    // Add margins to resolution
        maxY += (2*marginY);
        maxX = maxX * CurrentZoom;
        maxY = maxY * CurrentZoom;     // Get the width && height of the selected panel
        int w2 = w;
        int h2 = h;

        float scaleX=(float)((float)w2/(float)maxX);   // Calculate && set scale
        float scaleY=(float)((float)h2/(float)maxY);
        float actualScale = wxMin(scaleX,scaleY);

        //wxMessageBox(wxString::Format(_("pre\n %i , %i \n %i , %i \n %f , %f"), w2, h2, maxX, maxY, scaleX, scaleY));

        wxImage tempimg = bitmap.ConvertToImage();

        int sX = (float)((float)GetBackWidth(Cpage)*(float)actualScale);
        int sY = (float)((float)GetBackHeight(Cpage)*(float)actualScale);


        tempimg.Rescale(sX, sY, wxIMAGE_QUALITY_NORMAL);


        if(!tempimg.IsOk())
            wxMessageBox(wxString::Format(_T("Prerendering error:\n %i , %i \n %i , %i \n %f , %f\n %i , %i \n %f"), w2, h2, maxX, maxY, scaleX, scaleY, sX, sY, actualScale));

        Pview = wxBitmap(tempimg);

        UpdPview = false;
        UpdSize = wxSize(w, h);

    }

    pdc.SetBackground(*wxWHITE_BRUSH);
    pdc.SetBackgroundMode(wxTRANSPARENT);


    int maxX = GetBackWidth(Cpage);   // Get the width && the height of the current pattern
    int maxY = GetBackHeight(Cpage);
    int marginX = 50;     // Set margins
    int marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w3 = w;
    int h3 = h;

    float scaleX=(float)((float)w3/(float)maxX);   // Calculate && set scale
    float scaleY=(float)((float)h3/(float)maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w3 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h3 - (GetBackHeight(Cpage)*actualScale))/2.0);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    pdc.DrawBitmap(Pview, PositionX, PositionY, 0);

    pdc.SetUserScale(actualScale, actualScale);
    pdc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC

    DrawLists(pdc, Cpage, true);
    DrawLabels(pdc, Cpage, true);


    pdc.SetBrush(*wxTRANSPARENT_BRUSH);  //Draw bounders
    pdc.SetPen(*wxGREY_PEN);
    if ( Cpage == 0 )
        switch(Database->PDC){
            case 0:
                pdc.DrawRectangle(0, 0, 1429, 1417);
                break;
            case 1:
                pdc.DrawRectangle(0, 0, 1429, 1417);
                break;
            case 2:
                pdc.DrawRectangle(0, 0, 3224, 2182);
                pdc.DrawRectangle(1561, 0, 102, 2182);
                break;
            case 3:
                pdc.DrawRectangle(0, 0, 3153, 2182);
                pdc.DrawRectangle(1536, 0, 81, 2182);
                break;
        }
    else if ( Cpage == 1 )
        switch(Database->PDC){
            case 0:
                pdc.DrawRectangle(0, 0, 1429, 1417);
                break;
            case 1:
                pdc.DrawRectangle(0, 0, 1429, 1417);
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else if ( Cpage == 2 )
        switch(Database->PDC){
            case 0:
                pdc.DrawRectangle(0, 0, 1780, 1393);
                pdc.DrawRectangle(77, 0, 1626, 1393);
                break;
            case 1:
                break;
            case 2:
                break;
            case 3:
                break;
        }
    else
    {
        pdc.DrawCircle(wxPoint(700, 700), 700);
        pdc.DrawCircle(wxPoint(700, 700), 284);
        pdc.DrawCircle(wxPoint(700, 700), 88);
    }


    pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 2, wxLONG_DASH));

    if ( (ActiveTool == 1) && (Database->Page[Cpage].labels.GetCount() != 0) )
    {
        pdc.SetFont(Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont());           // Apply Font && Color then draw text with the chosen coordinates && angle
        pdc.SetTextForeground(Database->Page[Cpage].labels[SelectedItem].Colour.GetColour());
        wxFont Xfont = Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont();
        wxCoord wi, he, xc = NULL;
        pdc.GetMultiLineTextExtent(Database->Page[Cpage].labels[SelectedItem].L, & wi, & he, &xc, &Xfont);
        if ( wi == 0 )
            wi = he = 100 ;

        if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
        {
            if ( Database->Page[Cpage].labels[SelectedItem].Align == 0 )
            {
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X, Database->Page[Cpage].labels[SelectedItem].Y, wi, he);

                pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+wi-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+wi-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
            }
            else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
            {
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2), Database->Page[Cpage].labels[SelectedItem].Y, wi, he);

                pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
            }
            else if ( Database->Page[Cpage].labels[SelectedItem].Align == 2 )
            {
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi, Database->Page[Cpage].labels[SelectedItem].Y, wi, he);

                pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-12, Database->Page[Cpage].labels[SelectedItem].Y-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi-12, Database->Page[Cpage].labels[SelectedItem].Y+he-12, 24, 24);
            }
        }
        else
        {
            if ( he > wi )
                wi = he;
            if ( Database->Page[Cpage].labels[SelectedItem].Align != 1 )
            {
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi, Database->Page[Cpage].labels[SelectedItem].Y-wi, 2*wi, 2*wi);

                pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi-12, Database->Page[Cpage].labels[SelectedItem].Y-wi-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+wi-12, Database->Page[Cpage].labels[SelectedItem].Y-wi-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+wi-12, Database->Page[Cpage].labels[SelectedItem].Y+wi-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-wi-12, Database->Page[Cpage].labels[SelectedItem].Y+wi-12, 24, 24);
            }
            else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
            {
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2), Database->Page[Cpage].labels[SelectedItem].Y-(wi/2), wi, wi);

                pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12, 24, 24);
                pdc.DrawRectangle(Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12, Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12, 24, 24);
            }
        }
    }
    else if ( (ActiveTool == 2) && (Database->Page[Cpage].lists.GetCount() != 0) )
    {
        int he = 0, wi = 0;
        pdc.SetFont(Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont());
        pdc.SetTextForeground(Database->Page[Cpage].lists[SelectedItem].Colour.GetColour());

        long Col = -1, *columns;
        wxString TempString = wxEmptyString;

        int g = 0, j = 0;
        while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
        {
            if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';' )
            {
                TempString += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j];
                j++;
            }
            else if ( Col == -1 )
            {
                TempString.ToLong(&Col);
                TempString = wxEmptyString;
                columns = new long[Col];
                j++;
            }
            else
            {
                TempString.ToLong(&columns[g++]);
                wi += columns[g-1];
                TempString = wxEmptyString;
                j++;
            }
        }

        he = ((Database->Page[Cpage].lists[SelectedItem].L.GetCount()-1)*Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont().GetPointSize()*1.5);
        pdc.DrawRectangle(Database->Page[Cpage].lists[SelectedItem].X, Database->Page[Cpage].lists[SelectedItem].Y, wi, he);

        g = Database->Page[Cpage].lists[SelectedItem].X;
        for ( j = 0 ; j < Col-1 ; j++ )
        {
            g = g + columns[j];
            pdc.DrawLine(g, Database->Page[Cpage].lists[SelectedItem].Y, g, Database->Page[Cpage].lists[SelectedItem].Y+he);
        }

        delete[] columns;
    }
    else if ((ActiveTool == 3) && (SelectedItem != -1))
    {
        int wi = Database->Page[Cpage].images[SelectedItem].Img.GetWidth()*Database->Page[Cpage].images[SelectedItem].Scale/100, he = Database->Page[Cpage].images[SelectedItem].Img.GetHeight()*Database->Page[Cpage].images[SelectedItem].Scale/100;
        if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 0) || (Database->Page[Cpage].images[SelectedItem].Rotate == 2) )
        {
            pdc.DrawRectangle(Database->Page[Cpage].images[SelectedItem].X-(wi/2), Database->Page[Cpage].images[SelectedItem].Y-(he/2), wi, he);

            pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12, (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12, (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12, (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12, (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12, 24, 24);

        }
        else if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 1) || (Database->Page[Cpage].images[SelectedItem].Rotate == 3) )
        {
            pdc.DrawRectangle(Database->Page[Cpage].images[SelectedItem].X-(he/2), Database->Page[Cpage].images[SelectedItem].Y-(wi/2), he, wi);

            pdc.SetPen(wxPen(wxColour(255, 0, 0, wxALPHA_OPAQUE), 1, wxSOLID));
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(he/2))-12, (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12, (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12, (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12, 24, 24);
            pdc.DrawRectangle((Database->Page[Cpage].images[SelectedItem].X-(he/2))-12, (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12, 24, 24);
        }

    }

}

void DiscWrapperFrame::On_Export(wxCommandEvent& event)        // Zoom in
{
    CFs.DWLog(_T("> Exporting: "));

    int part, format, patt = 0;
    if ( Database->PDC == 1 )
        patt = 1;
    else if ( (Database->PDC == 2) || (Database->PDC == 3) )
        patt = 2;
    ExportDialog dialog(this,wxID_ANY, patt);
    dialog.ShowModal();
    part = dialog.GetPart();
    format = dialog.GetFormat();


    if ( part == -2 )
        return;

    wxMemoryDC memDC;
    wxBitmap bitmap, bitmap1, bitmap2;

    if ( part == -3 )   // Export Disc
    {
        int Cpage = 3;

        CFs.DWLog(_T("Disc\n"));

        bitmap = wxBitmap(1400, 1400);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);


        DrawImages(memDC, Cpage);

        DrawLists(memDC, Cpage);

        DrawLabels(memDC, Cpage);


        wxBitmap bmp(1400, 1400);
        wxMemoryDC xdc;
        xdc.SelectObject(bmp);

        xdc.SetBackground(*wxWHITE_BRUSH);
        xdc.Clear();

        xdc.SetBrush(*wxBLACK_BRUSH);  //Draw bounders
        xdc.SetPen(*wxWHITE_PEN);
        xdc.DrawCircle(wxPoint(700, 700), 700);
        xdc.SetBrush(*wxWHITE_BRUSH);  //Draw bounders
        xdc.DrawCircle(wxPoint(700, 700), 88);

        memDC.Blit(0, 0, 1400, 1400, &xdc, 0, 0, wxOR);
    }
    else if ( part == 0 )   // Export Front
    {

        CFs.DWLog(_T("Front\n"));

        if ( (Database->PDC == 0) || (Database->PDC == 1) )
            bitmap = wxBitmap(1429, 1417);
        else if ( Database->PDC == 2 )
            bitmap = wxBitmap(3224, 2182);
        else if ( Database->PDC == 3 )
            bitmap = wxBitmap(3153, 2182);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 0);

        DrawLists(memDC, 0);

        DrawLabels(memDC, 0);
    }
    else if ( part == 1 )   // Export Front && Inside
    {

        CFs.DWLog(_T("Front & Inside\n"));

        bitmap = wxBitmap(2858, 1417);
        bitmap1 = wxBitmap(1429, 1417);
        bitmap2 = wxBitmap(1429, 1417);
        memDC.SelectObject(bitmap1);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);


        DrawImages(memDC, 1);

        DrawLists(memDC, 1);

        DrawLabels(memDC, 1);

        memDC.SelectObject(wxNullBitmap);
        memDC.SelectObject(bitmap2);


        DrawImages(memDC, 0);

        DrawLists(memDC, 0);

        DrawLabels(memDC, 0);

        memDC.SelectObject(wxNullBitmap);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        memDC.DrawBitmap(bitmap1, 0, 0, 0);
        memDC.DrawBitmap(bitmap2, 1429, 0, 0);

    }
    else if ( part == 2 )   // Export Inside
    {

        CFs.DWLog(_T("Inside\n"));

        bitmap = wxBitmap(1429, 1417);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 1);

        DrawLists(memDC, 1);

        DrawLabels(memDC, 1);

    }
    else    // Export Back
    {

        CFs.DWLog(_T("Back\n"));

        bitmap = wxBitmap(1780, 1393);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 2);

        DrawLists(memDC, 2);

        DrawLabels(memDC, 2);

    }

    memDC.SelectObject(wxNullBitmap);

    wxString path, Format;
    switch(format){
        case 0:
            Format = _("JPEG image (*.jpg)|*.jpg;*.JPG;*.jpeg;*.JPEG|All files (*)|*");
            break;
        case 1:
            Format = _("PNG image (*.png)|*.png;*.PNG|All files (*)|*");
            break;
        case 2:
            Format = _("BMP image (*.bmp)|*.bmp;*.BMP|All files (*)|*");
            break;
    }

    wxFileDialog FileDialog1(this, _("Choose a file"), ExportPath, _(""), Format, wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize);
    if (FileDialog1.ShowModal() == wxID_OK)
    {
        path = FileDialog1.GetPath();
        LastDir = FileDialog1.GetDirectory();
    }
    else
        return;

    CFs.DWLog(_T("> Saving image\n"));

    switch(format){
        case 0:
            bitmap.SaveFile(path, wxBITMAP_TYPE_JPEG);
            break;
        case 1:
            bitmap.SaveFile(path, wxBITMAP_TYPE_PNG);
            break;
        case 2:
            bitmap.SaveFile(path, wxBITMAP_TYPE_BMP);
            break;
    }
}

void DiscWrapperFrame::On_PRINT(wxCommandEvent& event)        // Zoom in
{

    CFs.DWLog(_T("> Printing\n"));

    wxMemoryDC memDC;
    wxBitmap bitmap, bitmap2, bitmapt1, bitmapt2;
    int Cpage = GetCurrentPage();

    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Disc" ) )
    {
        bitmap = wxBitmap(1400, 1400);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, Cpage);

        DrawLists(memDC, Cpage);

        DrawLabels(memDC, Cpage);


        memDC.SelectObject(wxNullBitmap);

#if defined(__UNIX__)
        if ( wxFile::Exists(_T("/usr/bin/4L-gui")) == true )
        {
            if ( wxMessageDialog(this, _("LightScribe Software of LaCie is detected on your system. Do you want to lightscribe your design instead of printing it?"), _T("DiscWrapper"), wxYES_NO , wxDefaultPosition).ShowModal() == wxID_YES )
            {
                bitmap.SaveFile(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("LightScribe.bmp"), wxBITMAP_TYPE_BMP);
                std::string command = "gksudo 4L-gui "+CFs.oFolder_userM+CFs.wx2std(CFs.PathCoordination+_T("LightScribe.bmp"));

                system(const_cast<char*>(command.c_str()));

               /* FILE *LSL;
                LSL = popen(const_cast<char*>(command.c_str()), "w");
                if ( LSL == NULL )
                {
                    wxMessageDialog(this, _("Can't run 4L."), _T("DiscWrapper"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                    return;
                }

                fprintf( LSL, "\t");
                //    wxMessageDialog(this, _("Nem megy."), _T("DiscWrapper"), wxICON_ERROR , wxDefaultPosition).ShowModal();

                pclose( LSL );*/

                return;
            }
        }
#endif
        //wxMessageDialog(this, _("Printing on disc with an Inkjet Disc Printer hasn't been tested!"), _T("DiscWrapper"), wxICON_EXCLAMATION , wxDefaultPosition).ShowModal();

        PrintDiscDialog dialog(this,wxID_ANY);
        if ( dialog.ShowModal() == wxID_OK )
        {
            memDC.SelectObject(bitmap);
            wxBitmap bmp(1400, 1400);
            wxMemoryDC xdc;
            xdc.SelectObject(bmp);

            xdc.SetBackground(*wxWHITE_BRUSH);
            xdc.Clear();

            xdc.SetBrush(*wxBLACK_BRUSH);  //Draw bounders
            xdc.SetPen(*wxWHITE_PEN);
            xdc.DrawCircle(wxPoint(700, 700), 700);
            xdc.SetBrush(*wxWHITE_BRUSH);  //Draw bounders
            xdc.DrawCircle(wxPoint(700, 700), 700-dialog.GetSurface());

            memDC.Blit(0, 0, 1400, 1400, &xdc, 0, 0, wxOR);
            memDC.SelectObject(wxNullBitmap);

            myprint = new DWPrintout( 1, wxT("wxPrint: Disc"));
            myprint->SetDiscPosition(dialog.GetPosition());
            myprint->SetDC(bitmap, 4);
            myprint->preparePrint(true);
            printer.Print(this, myprint, true );
        }
        else
            return;

    }
    else if ( ((Database->PDC == 0) || (Database->PDC == 1)) && ((Notebook1->GetPageText(Notebook1->GetSelection()) == _("Front")) || (Notebook1->GetPageText(Notebook1->GetSelection()) == _("Inside"))) )   // Export Front && Inside
    {
        bitmap = wxBitmap(2858, 1417);
        bitmapt1 = wxBitmap(1429, 1417);
        bitmapt2 = wxBitmap(1429, 1417);
        memDC.SelectObject(bitmapt1);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);


        DrawImages(memDC, 1);

        DrawLists(memDC, 1);

        DrawLabels(memDC, 1);

        memDC.SelectObject(wxNullBitmap);
        memDC.SelectObject(bitmapt2);

        DrawImages(memDC, 0);

        DrawLists(memDC, 0);

        DrawLabels(memDC, 0);

        memDC.SelectObject(wxNullBitmap);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        memDC.DrawBitmap(bitmapt1, 0, 0, 0);
        memDC.DrawBitmap(bitmapt2, 1429, 0, 0);

        memDC.SetPen( *wxBLACK_PEN );
        memDC.SetBrush( *wxTRANSPARENT_BRUSH );
        memDC.DrawRectangle(0, 0, 2858, 1417);
        wxPen pen( *wxBLACK, 1, wxLONG_DASH);
        memDC.SetPen(pen);
        memDC.DrawLine(1429, 0, 1429, 1417);

        memDC.SelectObject(wxNullBitmap);
        bitmap2 = wxBitmap(bitmap.ConvertToImage().Rotate90(false));

        myprint = new DWPrintout( 1, wxT("wxPrint: Case type 0"));
        myprint->SetDC(bitmap2, 0);
        myprint->preparePrint(true);
        printer.Print(this, myprint, true );
        /*if(!success)
            wxMessageBox(_("Printing seems failed."), _T("DiscWrapper"));*/
    }
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Back") )
    {
        bitmap = wxBitmap(1780, 1393);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 2);

        DrawLists(memDC, 2);

        DrawLabels(memDC, 2);

        memDC.SetPen( *wxBLACK_PEN );
        memDC.SetBrush( *wxTRANSPARENT_BRUSH );
        memDC.DrawRectangle(0, 0, 1780, 1393);
        wxPen pen( *wxBLACK, 1, wxLONG_DASH);
        memDC.SetPen(pen);
        memDC.DrawLine(77, 0, 77, 1393);
        memDC.DrawLine(1703, 0, 1703, 1393);

        memDC.SelectObject(wxNullBitmap);

        myprint = new DWPrintout( 1, wxT("wxPrint: Case type 1"));
        myprint->SetDC(bitmap, 1);
        myprint->preparePrint(true);
        printer.Print(this, myprint, true );
        /*if(!success)
            wxMessageBox(_("Printing seems failed."), _T("DiscWrapper"));*/
    }
    else if ( Database->PDC == 2 )
    {
        bitmap = wxBitmap(3224, 2182);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 0);

        DrawLists(memDC, 0);

        DrawLabels(memDC, 0);

        memDC.SetPen( *wxBLACK_PEN );
        memDC.SetBrush( *wxTRANSPARENT_BRUSH );
        memDC.DrawRectangle(0, 0, 3224, 2182);

        memDC.SelectObject(wxNullBitmap);
        bitmap2 = wxBitmap(bitmap.ConvertToImage().Rotate90(false));

        myprint = new DWPrintout( 1, wxT("wxPrint: Case type 2"));
        myprint->SetDC(bitmap2, 2);
        myprint->preparePrint(true);
        printer.Print(this, myprint, true );
        /*if(!success)
            wxMessageBox(_("Printing seems failed."), _T("DiscWrapper"));*/
    }
    else if ( Database->PDC == 3 )
    {
        bitmap = wxBitmap(3153, 2182);
        memDC.SelectObject(bitmap);
        memDC.SetBackground(*wxWHITE_BRUSH);
        memDC.Clear();
        memDC.SetBackgroundMode(wxTRANSPARENT);

        DrawImages(memDC, 0);

        DrawLists(memDC, 0);

        DrawLabels(memDC, 0);

        memDC.SetPen( *wxBLACK_PEN );
        memDC.SetBrush( *wxTRANSPARENT_BRUSH );
        memDC.DrawRectangle(0, 0, 3153, 2182);

        memDC.SelectObject(wxNullBitmap);
        bitmap2 = wxBitmap(bitmap.ConvertToImage().Rotate90(false));

        CFs.DWLog(_T("> Sending data\n"));

        myprint = new DWPrintout( 1, wxT("wxPrint: Case type 3"));
        myprint->SetDC(bitmap2, 3);
        myprint->preparePrint(true);
        printer.Print(this, myprint, true );
        /*if(!success)
            wxMessageBox(_("Printing seems failed."), _T("DiscWrapper"));*/
    }

    delete myprint;
}

void DiscWrapperFrame::DrawLabels(wxDC &dc, int Cpage, bool preview)
{
    int i, j;
    for ( i = 0 ; i < Database->Page[Cpage].labels.GetCount() ; i++ )
    {
        dc.SetFont(Database->Page[Cpage].labels[i].Font.GetChosenFont());           // Apply Font && Color then draw text with the chosen coordinates && angle
        dc.SetTextForeground(Database->Page[Cpage].labels[i].Colour.GetColour());
        wxFont Xfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
        wxCoord w, oh, h, xc = NULL;
        dc.GetMultiLineTextExtent(Database->Page[Cpage].labels[i].L, & w, & oh, &xc, &Xfont);

        if ( ( (Database->Page[Cpage].labels[i].L == _("<Title>")) || (Database->Page[Cpage].labels[i].L == _("<Date>")) ) && !preview )
            ;
        else if ( (Database->Page[Cpage].labels[i].Bend == false) && (Database->Page[Cpage].labels[i].L != wxEmptyString) )
        {
                int ii, ij = 1;
                for ( ii = 0 ; ii < Database->Page[Cpage].labels[i].L.Len()-1 ; ii++ )
                    if ( Database->Page[Cpage].labels[i].L[ii] == '\n' )
                        ij++;

                int ig, ih = 0, DrawY = Database->Page[Cpage].labels[i].Y - oh;

                for ( ii = 0 ; ii < ij ; ii++ )
                {
                    DrawY += oh;

                    wxString DrawL = wxEmptyString;

                    for ( ig = ih ; (Database->Page[Cpage].labels[i].L[ig] != '\n') && (ig < Database->Page[Cpage].labels[i].L.Len()) ; ig++ )
                        DrawL += Database->Page[Cpage].labels[i].L[ig];
                    ih = ig+1;

                    wxFont Xfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
                    xc = NULL;
                    dc.GetMultiLineTextExtent(DrawL, & w, & oh, &xc, &Xfont);

                    if ( Database->Page[Cpage].labels[i].Align == 0 )
                        dc.DrawRotatedText( DrawL, Database->Page[Cpage].labels[i].X + ((DrawY-Database->Page[Cpage].labels[i].Y)*RoateCoordinationOnX(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnX2(Database->Page[Cpage].labels[i].Angle, ii, oh), DrawY - ((2*(DrawY-Database->Page[Cpage].labels[i].Y))*RoateCoordinationOnY(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnY2(Database->Page[Cpage].labels[i].Angle, ii, oh), Database->Page[Cpage].labels[i].Angle);
                    else if ( Database->Page[Cpage].labels[i].Align == 1 )
                        dc.DrawRotatedText( DrawL, Database->Page[Cpage].labels[i].X - (w/2*cos(Database->Page[Cpage].labels[i].Angle/180*3.141592653)) + ((DrawY-Database->Page[Cpage].labels[i].Y)*RoateCoordinationOnX(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnX2(Database->Page[Cpage].labels[i].Angle, ii, oh), DrawY + (w/2*sin(Database->Page[Cpage].labels[i].Angle/180*3.141592653)) - ((2*(DrawY-Database->Page[Cpage].labels[i].Y))*RoateCoordinationOnY(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnY2(Database->Page[Cpage].labels[i].Angle, ii, oh), Database->Page[Cpage].labels[i].Angle);
                    else
                        dc.DrawRotatedText( DrawL, Database->Page[Cpage].labels[i].X - (w*cos(Database->Page[Cpage].labels[i].Angle/180*3.141592653)) + ((DrawY-Database->Page[Cpage].labels[i].Y)*RoateCoordinationOnX(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnX2(Database->Page[Cpage].labels[i].Angle, ii, oh), DrawY + (w*sin(Database->Page[Cpage].labels[i].Angle/180*3.141592653)) - ((2*(DrawY-Database->Page[Cpage].labels[i].Y))*RoateCoordinationOnY(Database->Page[Cpage].labels[i].Angle)) + RoateCoordinationOnY2(Database->Page[Cpage].labels[i].Angle, ii, oh), Database->Page[Cpage].labels[i].Angle);
                }
        }
        else if ( Database->Page[Cpage].labels[i].L.Len() != 0 )
        {
            int ii, ij = 1;
            for ( ii = 0 ; ii < Database->Page[Cpage].labels[i].L.Len()-1 ; ii++ )
                if ( Database->Page[Cpage].labels[i].L[ii] == '\n' )
                    ij++;

            int ig, ih = 0, DrawY = Database->Page[Cpage].labels[i].Y - oh;

            for ( ii = 0 ; ii < ij ; ii++ )
            {
                DrawY += oh;
                wxString DrawL = wxEmptyString;

                for ( ig = ih ; (Database->Page[Cpage].labels[i].L[ig] != '\n') && (ig < Database->Page[Cpage].labels[i].L.Len()) ; ig++ )
                    DrawL += Database->Page[Cpage].labels[i].L[ig];
                ih = ig+1;

                wxFont Xfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
                xc = NULL;
                dc.GetMultiLineTextExtent(DrawL, & w, & oh, &xc, &Xfont);

                if ( DrawY <= 416 )
                {
                    double MaxRad = static_cast<double>(DrawY)/(416-oh);
                    double Space = 0.025;

                    if ( Database->Page[Cpage].labels[i].Angle != 0 )
                        Space = static_cast<double>(Database->Page[Cpage].labels[i].Angle)/66;

                    wxString Character = wxEmptyString;
                    double Radius = 0;

                    wxFont Tfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
                    wxCoord cw, ch, cxc = NULL;

                    for ( j = 0 ; j < DrawL.Len() ; j++ )
                    {
                        dc.GetMultiLineTextExtent(DrawL[j], & cw, & ch, &cxc, &Tfont);
                        Radius += (1+MaxRad)*static_cast<double>(cw)/19*Space;
                    }


                    double Start = (Radius/2);
                    for ( j = 0 ; j < DrawL.Len() ; j++ )
                    {
                        Character = DrawL[j];

                        dc.GetMultiLineTextExtent(Character, & cw, & ch, &cxc, &Tfont);

                        Character += _T(" ");

                        dc.DrawRotatedText( Character, 700-((700-DrawY)*sin(Start/180*3.141592653)), 700-((700-DrawY)*cos(Start/180*3.141592653)), Start);
                        Start -= (1+MaxRad)*static_cast<double>(cw)/19*Space;
                    }
                }
                else if ( DrawY >= 984-oh )
                {
                    double MaxRad = static_cast<double>(DrawY-984)/(416-oh);
                    double Space = 0.025;
                    if ( Database->Page[Cpage].labels[i].Angle != 0 )
                        Space = static_cast<double>(Database->Page[Cpage].labels[i].Angle)/66;
                    wxString Character = wxEmptyString;
                    double Radius = 0;

                    wxFont Tfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
                    wxCoord cw, ch, cxc = NULL;

                    for ( j = 0 ; j < DrawL.Len() ; j++ )
                    {
                        dc.GetMultiLineTextExtent(DrawL[j], & cw, & ch, &cxc, &Tfont);
                        Radius -= (2-MaxRad)*static_cast<double>(cw)/19*Space;
                    }


                    double Start = (Radius/2);
                    for ( j = 0 ; j < DrawL.Len() ; j++ )
                    {
                        Character = DrawL[j];

                        dc.GetMultiLineTextExtent(Character, & cw, & ch, &cxc, &Tfont);

                        Character += _T(" ");

                        dc.DrawRotatedText( Character, 700-((700-DrawY)*sin(Start/180*3.141592653)), 700-((700-DrawY)*cos(Start/180*3.141592653)), Start);
                        Start += (2-MaxRad)*static_cast<double>(cw)/19*Space;
                    }
                }
                else
                {
                    dc.DrawRotatedText( DrawL, Database->Page[Cpage].labels[i].X-(w/2), DrawY, 0);
                }
            }
        }
        if ( (Database->Page[Cpage].labels[i].L == wxEmptyString) && !preview )
        {
            dc.SetFont(Database->Page[Cpage].labels[i].Font.GetChosenFont());           // Apply Font && Color then draw text with the chosen coordinates && angle
            dc.SetTextForeground(Database->Page[Cpage].labels[i].Colour.GetColour());
            dc.DrawText( _("<Empty>"), Database->Page[Cpage].labels[i].X, Database->Page[Cpage].labels[i].Y);
        }
    }

}

void DiscWrapperFrame::DrawLists(wxDC &dc, int Cpage, bool preview)
{
    int i, j;
    for ( i = 0 ; i < Database->Page[Cpage].lists.GetCount() ; i++ )
    {
        dc.SetFont(Database->Page[Cpage].lists[i].Font.GetChosenFont());
        dc.SetTextForeground(Database->Page[Cpage].lists[i].Colour.GetColour());

        int g = 0;
        long Col = -1, *columns;
        wxString TempString = wxEmptyString;

        j = 0;
        while ( j < Database->Page[Cpage].lists[i].L.Item(0).Len() )
        {
            if ( Database->Page[Cpage].lists[i].L.Item(0)[j] != ';' )
            {
                TempString += Database->Page[Cpage].lists[i].L.Item(0)[j];
                j++;
            }
            else if ( Col == -1 )
            {
                TempString.ToLong(&Col);
                TempString = wxEmptyString;
                columns = new long[Col];
                j++;
            }
            else
            {
                TempString.ToLong(&columns[g++]);
                TempString = wxEmptyString;
                j++;
            }
        }

        for ( j = 1 ; j < Database->Page[Cpage].lists[i].L.GetCount() ; j++ )
        {
            wxChar align;
            long length, k, ColWidth = 0;

            for ( k = g = 0 ; g < Database->Page[Cpage].lists[i].L.Item(j).Len() ; )
            {
                align = Database->Page[Cpage].lists[i].L.Item(j)[g++];
                TempString = wxEmptyString;
                while ( Database->Page[Cpage].lists[i].L.Item(j)[g] != ';' )
                    TempString += Database->Page[Cpage].lists[i].L.Item(j)[g++];
                TempString.ToLong(&length);
                TempString = wxEmptyString;
                length += ++g;
                while ( g < length )
                    TempString += Database->Page[Cpage].lists[i].L.Item(j)[g++];

                if ( (TempString == wxEmptyString) && preview )
                    TempString = _("<Empty>");

                wxFont Xfont = Database->Page[Cpage].lists[i].Font.GetChosenFont();
                wxCoord w, h, xc = NULL;
                dc.GetMultiLineTextExtent(TempString, & w, & h, &xc, &Xfont);
                if ( align == 'l' )
                    dc.DrawText( TempString, Database->Page[Cpage].lists[i].X+ColWidth, Database->Page[Cpage].lists[i].Y+((j-1)*Database->Page[Cpage].lists[i].Font.GetChosenFont().GetPointSize()*1.5));
                else if ( align == 'c' )
                    dc.DrawText( TempString, Database->Page[Cpage].lists[i].X+ColWidth+columns[k]/2-w/2, Database->Page[Cpage].lists[i].Y+((j-1)*Database->Page[Cpage].lists[i].Font.GetChosenFont().GetPointSize()*1.5));
                else
                    dc.DrawText( TempString, Database->Page[Cpage].lists[i].X+ColWidth+columns[k]-w, Database->Page[Cpage].lists[i].Y+((j-1)*Database->Page[Cpage].lists[i].Font.GetChosenFont().GetPointSize()*1.5));

                ColWidth += columns[k++];
            }
        }

        delete[] columns;
    }

}

void DiscWrapperFrame::DrawImages(wxDC &dc, int Cpage, bool preview)
{
    if ( Database->Page[Cpage].PageBack.IsOk() )
        dc.DrawBitmap(Database->Page[Cpage].PageBack, 0, 0, 0);

    int i, j;
    for ( j = 0 ; j < Database->Page[Cpage].images.GetCount() ; j++ )
    {
        i = Database->Page[Cpage].ImageOrder[j];
        int W = Database->Page[Cpage].images[i].Img.GetWidth()*Database->Page[Cpage].images[i].Scale/100, H = Database->Page[Cpage].images[i].Img.GetHeight()*Database->Page[Cpage].images[i].Scale/100;
        wxImage img;
        if ( preview )
            img = Database->Page[Cpage].images[i].Img.Scale(W, H, wxIMAGE_QUALITY_NORMAL);
        else
            img = Database->Page[Cpage].images[i].Img.Scale(W, H, wxIMAGE_QUALITY_HIGH);
        switch(Database->Page[Cpage].images[i].Rotate){
            case 0:
                break;
            case 1:
                img = img.Rotate90(true);
                break;
            case 2:
                img = img.Rotate90(true);
                img = img.Rotate90(true);
                break;
            case 3:
                img = img.Rotate90(false);
                break;
        }
        wxBitmap bmptemp = wxBitmap(img, -1);

        if ( (Database->Page[Cpage].images[i].Rotate == 0) || (Database->Page[Cpage].images[i].Rotate == 2) )
            dc.DrawBitmap(bmptemp, Database->Page[Cpage].images[i].X-(W/2), Database->Page[Cpage].images[i].Y-(H/2), 0);
        else if ( (Database->Page[Cpage].images[i].Rotate == 1) || (Database->Page[Cpage].images[i].Rotate == 3) )
            dc.DrawBitmap(bmptemp, Database->Page[Cpage].images[i].X-(H/2), Database->Page[Cpage].images[i].Y-(W/2), 0);
    }
}

void DiscWrapperFrame::On_Zoom_In(wxCommandEvent& event)        // Zoom in
{
    if ( CurrentZoom > 0.5 )
        CurrentZoom = CurrentZoom - 0.1;
    else
        return;

    UpdPview = true;
    RDO();
}

void DiscWrapperFrame::On_Zoom_Out(wxCommandEvent& event)       // Zoom out
{
    if ( CurrentZoom < 1.5 )
        CurrentZoom = CurrentZoom + 0.1;
    else
        return;

    UpdPview = true;
    RDO();
}

void DiscWrapperFrame::On_Zoom_Fit(wxCommandEvent& event)       // Zoom fit best
{
    CurrentZoom = 1;
    FitDC = true;

    UpdPview = true;
    RDO();
}

double DiscWrapperFrame::RoateCoordinationOnX(int input)
{
    double i = (double)(input % 91)/90;

    if ( input <= 90 )
        ;
    else if ( input <= 180 )
        i = 1 - i;
    else if ( input <= 270 )
        i = - i;
    else
        i = - (1 - i);

    return(i);
}

double DiscWrapperFrame::RoateCoordinationOnX2(int input, int input2, int input3)
{
    double j = (double)(input % 45)/46;
    if ( input <= 45 )
        ;
    else if ( input < 90 )
        j = 1 - j;
    else if ( input <= 135 )
        ;
    else if ( input < 180 )
        j = 1 - j;
    else if ( input <= 225 )
        j = - j;
    else if ( input < 270 )
        j = -(1-j);
    else if ( input <= 315 )
        j = - j;
    else if ( input < 360 )
        j = -(1-j);
    else
        j = 0;

    return(j*input2*input3/3.85);
}

double DiscWrapperFrame::RoateCoordinationOnY(int input)
{
    double i = (double)(input % 181)/180;
    if ( input <= 180 )
        ;
    else
        i = 1 - i;

    return(i);
}

double DiscWrapperFrame::RoateCoordinationOnY2(int input, int input2, int input3)
{
    double j = (double)(input % 45)/46;
    if ( input <= 45 )
        ;
    else if ( input < 90 )
        j = 1 - j;
    else if ( input <= 135 )
        j = - j;
    else if ( input < 180 )
        j = -(1 - j);
    else if ( input <= 225 )
        j = - j;
    else if ( input < 270 )
        j = -(1-j);
    else if ( input <= 315 )
        ;
    else if ( input < 360 )
        j = 1-j;
    else
        j = 0;

    return(j*input2*input3/3.85);
}
