/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "ManageImageStoreDialog.h"

//(*InternalHeaders(ManageImageStoreDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/msgdlg.h>

//(*IdInit(ManageImageStoreDialog)
const long ManageImageStoreDialog::ID_TEXTCTRL1 = wxNewId();
const long ManageImageStoreDialog::ID_BUTTON1 = wxNewId();
const long ManageImageStoreDialog::ID_BUTTON2 = wxNewId();
const long ManageImageStoreDialog::ID_BUTTON3 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ManageImageStoreDialog,wxDialog)
	//(*EventTable(ManageImageStoreDialog)
	//*)
END_EVENT_TABLE()

ManageImageStoreDialog::ManageImageStoreDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(ManageImageStoreDialog)
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;

	Create(parent, wxID_ANY, _("Edit paths"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	BoxSizer1 = new wxBoxSizer(wxVERTICAL);
	TextCtrl1 = new wxTextCtrl(this, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxSize(400,250), wxTE_MULTILINE|wxTE_DONTWRAP, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	BoxSizer1->Add(TextCtrl1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(this, ID_BUTTON1, _("Add"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer2->Add(Button1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(this, ID_BUTTON2, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer2->Add(Button2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(this, ID_BUTTON3, _("Ok"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	BoxSizer2->Add(Button3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer1->Add(BoxSizer2, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);

	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ManageImageStoreDialog::OnAdd);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ManageImageStoreDialog::OnButton2Click);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ManageImageStoreDialog::OnOK);
	//*)
}

ManageImageStoreDialog::~ManageImageStoreDialog()
{
	//(*Destroy(ManageImageStoreDialog)
	//*)
}


void ManageImageStoreDialog::OnButton2Click(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void ManageImageStoreDialog::OnOK(wxCommandEvent& event)
{
    s_paths = wxEmptyString;

    int i, j;
    for ( i = 0 ; i < TextCtrl1->GetNumberOfLines() ; i++ )
    {
        if ( TextCtrl1->GetLineText(i) != wxEmptyString )
        {
            wxString temp = TextCtrl1->GetLineText(i);
            if ( temp[temp.Len()-1] != '/' )
                temp += _T("/");

            for ( j = 0 ; j < temp.Len() ; j++ )
                if ( temp[j] == '\\' )
                    temp[j] = '/';

            if ( !wxDir::Exists(temp) )
            {
                wxMessageDialog(this, _("The folowing folder does not exist:\n")+temp, _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
                return;
            }
            s_paths += temp;

            if ( i != TextCtrl1->GetNumberOfLines()-1 )
                s_paths += _T("\n");
        }
    }

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ManageImageStoreDialog::OnAdd(wxCommandEvent& event)
{
    wxDirDialog dialog(this,_("Choose a folder"), _(""), wxDD_DIR_MUST_EXIST, wxDefaultPosition, wxDefaultSize, _T("wxDirCtrl"));
    if (dialog.ShowModal() == wxID_OK)
    {
        TextCtrl1->AppendText(_T("\n")+dialog.GetPath());
    }
}
