#ifndef IMPORTTEXTFILEDIALOG_H
/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#define IMPORTTEXTFILEDIALOG_H

//(*Headers(ImportTextFileDialog)
#include <wx/sizer.h>
#include <wx/radiobox.h>
#include <wx/textctrl.h>
#include <wx/grid.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class ImportTextFileDialog: public wxDialog
{
	public:

		ImportTextFileDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ImportTextFileDialog();

		void SetPath(wxString data){ m_path = data; }
		wxArrayString GetData(){ return(m_Data); }

		//(*Declarations(ImportTextFileDialog)
		wxButton* Button1;
		wxGrid* Grid1;
		wxButton* Button2;
		wxTextCtrl* TextCtrl1;
		wxRadioBox* RadioBox1;
		//*)

	protected:

		//(*Identifiers(ImportTextFileDialog)
		static const long ID_RADIOBOX1;
		static const long ID_TEXTCTRL1;
		static const long ID_BUTTON2;
		static const long ID_BUTTON1;
		static const long ID_GRID1;
		//*)

		wxString m_path;
		wxArrayString m_Data;

	private:

		//(*Handlers(ImportTextFileDialog)
		void OnOk(wxCommandEvent& event);
		void OnCancel(wxCommandEvent& event);
		void OnRadioBox(wxCommandEvent& event);
		void OnText(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);
		//*)
		void RefreshPreview();

		wxString Separator;

		DECLARE_EVENT_TABLE()
};

#endif
