/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#ifndef EXPORTDIALOG_H
#define EXPORTDIALOG_H

//(*Headers(ExportDialog)
#include <wx/sizer.h>
#include <wx/panel.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class ExportDialog: public wxDialog
{
	public:

		ExportDialog(wxWindow* parent,wxWindowID id=wxID_ANY, int i=0,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ExportDialog();

		//(*Declarations(ExportDialog)
		wxButton* Button1;
		wxPanel* Panel1;
		wxButton* Button2;
		wxChoice* Choice1;
		wxChoice* Choice2;
		//*)

		int GetPart() const { return ex_part; }
		int GetFormat() const { return ex_format; }

	protected:

		//(*Identifiers(ExportDialog)
		static const long ID_CHOICE1;
		static const long ID_CHOICE2;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_PANEL1;
		//*)

		int ex_part, ex_format;

	private:

		//(*Handlers(ExportDialog)
		void OnClose(wxCommandEvent& event);
		void OnExport(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
