/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcSubButton;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

public class AlcToolBarSubSection {
    private final AlcModule module;
    final JPanel panel;
    private final JPanel contentPanel;
    private final AlcToolBarSubSection me;
    private int contentWidth;
    private ImageIcon arrow = AlcUtil.getImageIcon("sub-section-arrow.png");
    private AlcSubButton titleButton;
    private final int titleButtonWidth;

    public AlcToolBarSubSection(AlcModule module) {
        this.module = module;
        this.me = this;
        this.panel = new JPanel(new FlowLayout(0, 0, 0));
        this.panel.setOpaque(false);
        this.contentPanel = new JPanel(new FlowLayout(0, 2, 0));
        this.contentPanel.setOpaque(false);
        this.titleButton = new AlcSubButton(module.getName());
        this.titleButton.setFont(AlcConstants.FONT_SMALL_BOLD);
        this.titleButton.setVerticalTextPosition(0);
        this.titleButton.setHorizontalTextPosition(10);
        this.titleButtonWidth = this.titleButton.getPreferredSize().width;
        this.titleButton.setPreferredSize(new Dimension(this.titleButtonWidth, 25));
        this.titleButton.setIconTextGap(4);
        this.titleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.toolBar.toggleSubSection(AlcToolBarSubSection.this.me);
            }
        });
        this.panel.add(this.titleButton);
        this.contentPanel.setOpaque(false);
        this.panel.add(this.contentPanel);
    }

    void setContentVisible(boolean visible) {
        this.contentPanel.setVisible(visible);
        if (visible) {
            this.titleButton.setIcon(null);
            this.titleButton.setPreferredSize(new Dimension(this.titleButtonWidth, 25));
        } else {
            this.titleButton.setIcon(this.arrow);
            this.titleButton.setPreferredSize(new Dimension(this.titleButtonWidth + 7, 25));
        }
    }

    boolean isContentVisible() {
        return this.contentPanel.isVisible();
    }

    int getContentWidth() {
        return this.contentWidth;
    }

    public void add(Component comp) {
        this.contentPanel.add(comp);
        this.contentWidth = this.contentPanel.getLayout().preferredLayoutSize((Container)this.contentPanel).width;
    }

    public void remove(Component comp) {
        this.contentPanel.remove(comp);
        this.contentWidth = this.contentPanel.getLayout().preferredLayoutSize((Container)this.panel).width;
    }

    public void revalidate() {
        this.contentPanel.revalidate();
    }

    int getWidth() {
        Dimension layoutSize = this.panel.getLayout().preferredLayoutSize(this.panel);
        return layoutSize.width;
    }

    int getIndex() {
        return this.module.getIndex();
    }

    int getModuleType() {
        return this.module.getModuleType();
    }
}

