/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.alchemy.core.AlcAbstractToolBar;
import org.alchemy.core.AlcButton;
import org.alchemy.core.AlcCheckBoxMenuItem;
import org.alchemy.core.AlcColorButton;
import org.alchemy.core.AlcColorPicker;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcPopupButton;
import org.alchemy.core.AlcRadioButtonMenuItem;
import org.alchemy.core.AlcSeparator;
import org.alchemy.core.AlcSlider;
import org.alchemy.core.AlcSpinner;
import org.alchemy.core.AlcSubSeparator;
import org.alchemy.core.AlcToggleButton;
import org.alchemy.core.AlcToolBarMain;
import org.alchemy.core.AlcToolBarSub;
import org.alchemy.core.AlcToolBarSubSection;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

public class AlcToolBar
extends AlcAbstractToolBar
implements AlcConstants {
    private AlcPopupButton createButton;
    private AlcPopupButton affectButton;
    private AlcColorButton colorButton;
    private AlcToolBarMain mainToolBar;
    private AlcToolBarSub subToolBar;
    JPanel toolBars;
    private JButton detachButton;
    private AlcSlider transparencySlider;
    private AlcToolBarSubSection[] affectSubToolBarSections;
    private AlcToolBarSubSection createSubToolBarSection;
    private int currentSubToolBarSections = 0;
    private AlcColorPicker fgPicker;
    private AlcColorPicker bgPicker;
    AlcToggleButton fgbgButton;
    private boolean toolBarVisible = true;
    private boolean toolBarKeyedOn = false;
    private static int toolBarHeight = 60;
    private int totalHeight = 60;
    private Timer toolBarTimer;
    private boolean insideToolBar;

    AlcToolBar() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.setName("Toolbar");
        this.setLayout(new BorderLayout());
        this.toolBars = new JPanel(new BorderLayout());
        this.toolBars.setOpaque(false);
        this.mainToolBar = this.loadToolBar();
        this.toolBars.add("Center", this.mainToolBar);
        this.subToolBar = this.loadSubToolBar();
        this.toolBars.add("South", this.subToolBar);
        this.subToolBar.setVisible(true);
        if (!Alchemy.preferences.paletteAttached) {
            this.add("South", this.toolBars);
        }
        AbstractAction toolBarAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!Alchemy.preferences.paletteAttached) {
                    if (AlcToolBar.this.toolBarVisible) {
                        AlcToolBar.this.setToolBarVisible(false);
                        AlcToolBar.this.toolBarKeyedOn = false;
                    } else {
                        AlcToolBar.this.setToolBarVisible(true);
                        AlcToolBar.this.toolBarKeyedOn = true;
                    }
                }
            }
        };
        Alchemy.shortcuts.setShortcut(null, 32, "toggleToolBar", toolBarAction);
        AbstractAction hideCursorAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (Alchemy.canvas.getCursor() == AlcConstants.CURSOR_BLANK) {
                    Alchemy.canvas.setCursor(AlcConstants.CURSOR_CROSS);
                } else {
                    Alchemy.canvas.setCursor(AlcConstants.CURSOR_BLANK);
                }
            }
        };
        Alchemy.shortcuts.setShortcut(null, 72, "toggleCursor", hideCursorAction);
        AbstractAction eyedropperAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (Alchemy.canvas.isBackgroundColorActive()) {
                    if (!AlcToolBar.this.bgPicker.isEyeDropperActive()) {
                        AlcToolBar.this.bgPicker.startEyeDropper();
                    }
                } else if (!AlcToolBar.this.fgPicker.isEyeDropperActive()) {
                    AlcToolBar.this.fgPicker.startEyeDropper();
                }
            }
        };
        Alchemy.shortcuts.setShortcut(null, 73, "startEyeDropper", eyedropperAction);
        this.windowSize = new Dimension(Alchemy.window.getWindowSize().width, this.mainToolBar.getHeight());
        this.setToolBarVisible(false);
    }

    private AlcToolBarMain loadToolBar() {
        AlcToolBarMain toolBarGroup = new AlcToolBarMain();
        JPanel toolBar = new JPanel();
        toolBar.setOpaque(false);
        toolBar.setLayout(new FlowLayout(0, 10, 8));
        String styleTitle = this.getS("styleTitle");
        final AlcToggleButton styleButton = new AlcToggleButton();
        AbstractAction styleAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.toggleStyle();
                if (!e.getSource().getClass().getName().endsWith("AlcToggleButton")) {
                    styleButton.setSelected(!styleButton.isSelected());
                }
            }
        };
        styleButton.setAction(styleAction);
        styleButton.setup(styleTitle, this.getS("styleDescription"), AlcUtil.getUrlPath("style.png"));
        Alchemy.shortcuts.setShortcut(styleButton, 83, "styleTitle", styleAction);
        toolBar.add(styleButton);
        String underOverTitle = this.getS("overTitle");
        final AlcToggleButton underOverButton = new AlcToggleButton();
        AbstractAction underOverAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!e.getSource().getClass().getName().endsWith("AlcToggleButton")) {
                    underOverButton.setSelected(!underOverButton.isSelected());
                }
                if (underOverButton.isSelected()) {
                    underOverButton.setText(AlcToolBar.this.getS("underTitle"));
                } else {
                    underOverButton.setText(AlcToolBar.this.getS("overTitle"));
                }
                Alchemy.canvas.setDrawUnder(!Alchemy.canvas.getDrawUnder());
            }
        };
        underOverButton.setAction(underOverAction);
        underOverButton.setup(underOverTitle, this.getS("underOverDescription"), AlcUtil.getUrlPath("underOver.png"));
        Dimension underOverButtonSize = underOverButton.getPreferredSize();
        underOverButton.setText(this.getS("underTitle"));
        Dimension underOverButtonNewSize = underOverButton.getPreferredSize();
        if (underOverButtonSize.width > underOverButtonNewSize.width) {
            underOverButton.setPreferredSize(underOverButtonSize);
        } else {
            underOverButton.setPreferredSize(underOverButtonNewSize);
        }
        underOverButton.setText(underOverTitle);
        Alchemy.shortcuts.setShortcut(styleButton, 68, "underOverTitle", underOverAction);
        toolBar.add(underOverButton);
        boolean lineWidthSpinnerMin = true;
        int lineWidthSpinnerMax = 75;
        final AlcSpinner lineWidthSpinner = new AlcSpinner(this.getS("lineWeightTitle"), 1, 75, (int)Alchemy.canvas.getLineWidth(), 1);
        lineWidthSpinner.setToolTip(this.getS("lineWeightDescription"));
        lineWidthSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Alchemy.canvas.setLineWidth(lineWidthSpinner.getValue());
            }
        });
        AbstractAction lineWidthDownAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                lineWidthSpinner.setPreviousValue();
                Alchemy.canvas.setLineWidth(lineWidthSpinner.getValue());
            }
        };
        AbstractAction lineWidthUpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                lineWidthSpinner.setNextValue();
                Alchemy.canvas.setLineWidth(lineWidthSpinner.getValue());
            }
        };
        Alchemy.shortcuts.setShortcut(lineWidthSpinner, 91, "lineWeightDownTitle", lineWidthDownAction);
        Alchemy.shortcuts.setShortcut(lineWidthSpinner, 93, "lineWeightUpTitle", lineWidthUpAction);
        toolBar.add(lineWidthSpinner);
        toolBar.add(new AlcSeparator());
        String colorTitle = this.getS("colorTitle");
        this.colorButton = new AlcColorButton(colorTitle, this.getS("colorDescription"));
        this.fgPicker = new AlcColorPicker(this.colorButton);
        this.bgPicker = new AlcColorPicker(this.colorButton, true);
        this.colorButton.addFgItem(this.fgPicker);
        this.colorButton.addBgItem(this.bgPicker);
        toolBar.add(this.colorButton);
        AbstractAction fgbgAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcToolBar.this.colorButton.switchColors();
            }
        };
        Alchemy.shortcuts.setShortcut(this.colorButton, 88, "fgbgTitle", fgbgAction);
        this.transparencySlider = new AlcSlider(this.getS("transparencyTitle"), this.getS("transparencyDescription"), 0, 255, 254);
        this.transparencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!AlcToolBar.this.transparencySlider.getValueIsAdjusting()) {
                    Alchemy.canvas.setAlpha(AlcToolBar.this.transparencySlider.getValue());
                    AlcToolBar.this.refreshColorButton();
                }
            }
        });
        toolBar.add(this.transparencySlider);
        toolBar.add(new AlcSeparator());
        this.createButton = new AlcPopupButton(this.getS("createTitle"), this.getS("createDescription"), AlcUtil.getUrlPath("create.png"));
        ButtonGroup group = new ButtonGroup();
        int zero = 48;
        int createCount = 0;
        for (int i = 0; i < Alchemy.plugins.creates.length; ++i) {
            AlcModule currentModule = Alchemy.plugins.creates[i];
            if (!this.loadModule(currentModule)) continue;
            final AlcRadioButtonMenuItem createMenuItem = new AlcRadioButtonMenuItem();
            AbstractAction createMenuItemAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (Alchemy.plugins.currentCreate != createMenuItem.getIndex()) {
                        AlcToolBar.this.removeSubToolBarSection(0);
                        Alchemy.plugins.setCurrentCreate(createMenuItem.getIndex());
                    }
                    if (!e.getSource().getClass().getName().endsWith("AlcRadioButtonMenuItem")) {
                        createMenuItem.setSelected(!createMenuItem.isSelected());
                    } else {
                        Point loc = createMenuItem.getLocation();
                        int heightFromWindow = loc.y + 50;
                        AlcToolBar.this.toggleToolBar(heightFromWindow, true);
                    }
                }
            };
            createMenuItem.setAction(createMenuItemAction);
            createMenuItem.setup(currentModule);
            if (createCount == 0) {
                createMenuItem.setSelected(true);
            }
            group.add(createMenuItem);
            this.createButton.addItem(createMenuItem);
            if (createCount < 9) {
                Alchemy.shortcuts.setShortcut(createMenuItem, zero + createCount + 1, currentModule.getName(), createMenuItemAction);
            } else if (createCount == 9) {
                Alchemy.shortcuts.setShortcut(createMenuItem, zero, currentModule.getName(), createMenuItemAction);
            } else if (createCount > 9) {
                Alchemy.shortcuts.setShortcut(createMenuItem, zero + (createCount - 9), currentModule.getName(), createMenuItemAction, 8);
            }
            ++createCount;
        }
        toolBar.add(this.createButton);
        if (Alchemy.plugins.getNumberOfAffectModules() > 0) {
            this.affectButton = new AlcPopupButton(this.getS("affectTitle"), this.getS("affectDescription"), AlcUtil.getUrlPath("affect.png"));
            int affectCount = 0;
            for (int i = 0; i < Alchemy.plugins.affects.length; ++i) {
                AlcModule currentModule = Alchemy.plugins.affects[i];
                boolean load = this.loadModule(currentModule);
                if (!load) continue;
                final AlcCheckBoxMenuItem affectMenuItem = new AlcCheckBoxMenuItem();
                AbstractAction affectMenuItemAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        if (!e.getSource().getClass().getName().endsWith("AlcCheckBoxMenuItem")) {
                            affectMenuItem.setSelected(!affectMenuItem.isSelected());
                        }
                        if (affectMenuItem.isSelected()) {
                            Alchemy.plugins.addAffect(affectMenuItem.getIndex());
                        } else {
                            Alchemy.plugins.removeAffect(affectMenuItem.getIndex());
                            AlcToolBar.this.removeSubToolBarSection(affectMenuItem.getIndex() + 1);
                        }
                        if (e.getSource().getClass().getName().endsWith("AlcCheckBoxMenuItem")) {
                            Point loc = affectMenuItem.getLocation();
                            int heightFromWindow = loc.y + 50;
                            AlcToolBar.this.toggleToolBar(heightFromWindow, true);
                        }
                    }
                };
                affectMenuItem.setAction(affectMenuItemAction);
                affectMenuItem.setup(currentModule);
                this.affectButton.addItem(affectMenuItem);
                if (affectCount < 9) {
                    Alchemy.shortcuts.setShortcut(affectMenuItem, zero + affectCount + 1, currentModule.getName(), affectMenuItemAction, KEY_MODIFIER);
                } else if (affectCount == 9) {
                    Alchemy.shortcuts.setShortcut(affectMenuItem, zero, currentModule.getName(), affectMenuItemAction, KEY_MODIFIER);
                } else if (affectCount > 9) {
                    Alchemy.shortcuts.setShortcut(affectMenuItem, zero + (affectCount - 9), currentModule.getName(), affectMenuItemAction, 1);
                }
                ++affectCount;
            }
            toolBar.add(this.affectButton);
        }
        toolBar.add(new AlcSeparator());
        String clearTitle = this.getS("clearTitle");
        AbstractAction clearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.clear();
            }
        };
        AlcButton clearButton = new AlcButton(clearAction);
        clearButton.setup(clearTitle, this.getS("clearDescription"), AlcUtil.getUrlPath("clear.png"));
        Alchemy.shortcuts.setShortcut(clearButton, 8, "clearTitle", clearAction, KEY_MODIFIER);
        Alchemy.canvas.getActionMap().put(clearTitle, clearAction);
        toolBar.add(clearButton);
        JPanel topAlign = new JPanel();
        topAlign.setOpaque(false);
        topAlign.setLayout(new BoxLayout(topAlign, 3));
        this.detachButton = new JButton(AlcUtil.getImageIcon("palette-detach.png"));
        this.detachButton.setRolloverIcon(AlcUtil.getImageIcon("palette-detach-over.png"));
        this.detachButton.setToolTipText("Detach the toolbar to a seperate palette");
        if (Alchemy.OS == 2) {
            this.detachButton.setMargin(new Insets(2, 0, 0, 2));
        } else {
            this.detachButton.setMargin(new Insets(2, 0, 0, 7));
        }
        this.detachButton.setBorderPainted(false);
        this.detachButton.setContentAreaFilled(false);
        this.detachButton.setFocusPainted(false);
        this.detachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.window.setPalette(true);
            }
        });
        topAlign.add(this.detachButton);
        toolBarGroup.add((Component)toolBar, "Before");
        toolBarGroup.add((Component)topAlign, "After");
        return toolBarGroup;
    }

    void resizeToolBar() {
        Dimension toolBarWindowSize = new Dimension(this.windowSize.width, this.totalHeight);
        this.resizeToolBar(toolBarWindowSize);
    }

    void resizeToolBar(Dimension windowSize) {
        this.setBounds(0, 0, windowSize.width, this.totalHeight);
        this.windowSize = windowSize;
        this.revalidate();
        this.repaint();
        this.checkSubSections();
    }

    private void refreshToolBar() {
        this.calculateTotalHeight();
        this.resizeToolBar();
    }

    void toggleToolBar(int y) {
        this.toggleToolBar(y, false);
    }

    void toggleToolBar(int y, boolean startTimer) {
        if (y < 10) {
            this.setToolBarVisible(true);
            this.insideToolBar = true;
        } else if (y > this.getTotalHeight() + 5) {
            if (this.isPopupMenusVisible() || this.toolBarTimer != null || startTimer) {
                this.setTimer();
            } else if (!this.toolBarKeyedOn) {
                this.setToolBarVisible(false);
            }
            this.insideToolBar = false;
        } else {
            this.insideToolBar = true;
            this.toolBarKeyedOn = false;
        }
    }

    void setToolBarVisible(boolean visible) {
        if (visible != this.toolBarVisible) {
            this.setVisible(visible);
            this.toolBarVisible = visible;
            Alchemy.canvas.setEvents(!visible);
            if (!visible) {
                Alchemy.canvas.restoreCursor();
                this.setCursor(CURSOR_ARROW);
                this.colorButton.hidePopup();
                this.createButton.hidePopup();
                if (this.affectButton != null) {
                    this.affectButton.hidePopup();
                }
            }
        }
    }

    boolean isToolBarVisible() {
        return this.toolBarVisible;
    }

    int getToolBarHeight() {
        return toolBarHeight;
    }

    void calculateTotalHeight() {
        int newTotalHeight = this.mainToolBar.getHeight();
        if (this.subToolBar.isVisible()) {
            newTotalHeight += this.subToolBar.getHeight();
        }
        if (Alchemy.OS != 2) {
            newTotalHeight += Alchemy.menuBar.getHeight();
        }
        this.totalHeight = newTotalHeight;
    }

    int getTotalHeight() {
        return this.totalHeight;
    }

    private AlcToolBarSub loadSubToolBar() {
        this.affectSubToolBarSections = new AlcToolBarSubSection[Alchemy.plugins.getNumberOfAffectModules()];
        this.createSubToolBarSection = null;
        AlcToolBarSub toolBar = new AlcToolBarSub();
        return toolBar;
    }

    public void addSubToolBarSection(AlcToolBarSubSection subSection) {
        subSection.setContentVisible(false);
        if (subSection.getModuleType() == 1) {
            this.createSubToolBarSection = subSection;
        } else {
            this.affectSubToolBarSections[subSection.getIndex()] = subSection;
        }
        ++this.currentSubToolBarSections;
        this.toggleSubSection(subSection);
        this.refreshSubToolBar();
    }

    void removeSubToolBarSection(int index) {
        if (index == 0) {
            if (this.createSubToolBarSection != null) {
                this.createSubToolBarSection = null;
                --this.currentSubToolBarSections;
            }
        } else {
            int offsetIndex = index - 1;
            if (this.affectSubToolBarSections[offsetIndex] != null) {
                this.affectSubToolBarSections[offsetIndex] = null;
                --this.currentSubToolBarSections;
            }
        }
        this.refreshSubToolBar();
    }

    private void refreshSubToolBar() {
        this.subToolBar.removeAll();
        if (this.createSubToolBarSection != null) {
            this.subToolBar.add(this.createSubToolBarSection.panel);
        }
        for (int i = 0; i < this.affectSubToolBarSections.length; ++i) {
            if (this.affectSubToolBarSections[i] == null) continue;
            if (this.subToolBar.getComponentCount() % 2 != 0) {
                this.subToolBar.add(new AlcSubSeparator());
            }
            this.subToolBar.add(this.affectSubToolBarSections[i].panel);
        }
        if (this.currentSubToolBarSections > 0) {
            this.subToolBar.setVisible(true);
        } else if (!Alchemy.preferences.paletteAttached) {
            this.subToolBar.setVisible(false);
        }
        this.subToolBar.revalidate();
        this.subToolBar.repaint();
        this.refreshToolBar();
    }

    private void checkSubSections() {
        if (this.isSubSectionOverflow()) {
            this.trimSubSection();
        }
    }

    private boolean isSubSectionOverflow() {
        int layoutWidth = this.subToolBar.getContentWidth();
        return layoutWidth > this.windowSize.width;
    }

    void toggleSubSection(AlcToolBarSubSection subSection) {
        if (subSection.isContentVisible()) {
            subSection.setContentVisible(false);
        } else if (this.subToolBar.getContentWidth() + subSection.getContentWidth() < this.windowSize.width) {
            subSection.setContentVisible(true);
        } else if (this.currentSubToolBarSections > 1) {
            for (int i = this.affectSubToolBarSections.length - 1; i >= 0; --i) {
                if (this.affectSubToolBarSections[i] == null || !this.affectSubToolBarSections[i].isContentVisible()) continue;
                this.affectSubToolBarSections[i].setContentVisible(false);
                if (this.subToolBar.getContentWidth() + subSection.getContentWidth() >= this.windowSize.width) continue;
                subSection.setContentVisible(true);
                return;
            }
            if (this.createSubToolBarSection.isContentVisible()) {
                this.createSubToolBarSection.setContentVisible(false);
                if (this.subToolBar.getContentWidth() + subSection.getContentWidth() < this.windowSize.width) {
                    subSection.setContentVisible(true);
                    return;
                }
            }
        }
    }

    private void trimSubSection() {
        if (this.currentSubToolBarSections > 1) {
            for (int i = this.affectSubToolBarSections.length - 1; i >= 0; --i) {
                if (this.affectSubToolBarSections[i] == null || !this.affectSubToolBarSections[i].isContentVisible()) continue;
                this.affectSubToolBarSections[i].setContentVisible(false);
                if (this.isSubSectionOverflow()) continue;
                return;
            }
            if (this.createSubToolBarSection.isContentVisible()) {
                this.createSubToolBarSection.setContentVisible(false);
            }
        }
    }

    boolean isPopupMenusVisible() {
        if (this.colorButton.isPopupVisible()) {
            return true;
        }
        if (this.createButton.isPopupVisible()) {
            return true;
        }
        return this.affectButton != null && this.affectButton.isPopupVisible();
    }

    private void setTimer() {
        if (this.toolBarTimer == null) {
            this.toolBarTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!AlcToolBar.this.insideToolBar) {
                        if (AlcToolBar.this.isPopupMenusVisible()) {
                            if (!(AlcToolBar.this.colorButton.isInside() || AlcToolBar.this.createButton.isInside() || AlcToolBar.this.affectButton.isInside())) {
                                AlcToolBar.this.setToolBarVisible(false);
                                AlcToolBar.this.insideToolBar = false;
                            }
                        } else {
                            AlcToolBar.this.setToolBarVisible(false);
                            AlcToolBar.this.insideToolBar = false;
                        }
                    }
                    AlcToolBar.this.toolBarTimer.stop();
                    AlcToolBar.this.toolBarTimer = null;
                }
            });
            this.toolBarTimer.start();
        }
    }

    void detachToolBar() {
        if (!this.subToolBar.isVisible()) {
            this.subToolBar.setVisible(true);
        }
        this.setToolBarVisible(false);
        this.remove(this.toolBars);
        this.remove(Alchemy.menuBar);
    }

    void attachToolBar() {
        if (Alchemy.OS != 2) {
            Alchemy.window.setJMenuBar(null);
            this.add("North", Alchemy.menuBar);
        }
        if (this.currentSubToolBarSections < 1) {
            this.subToolBar.setVisible(false);
        }
        this.add("South", this.toolBars);
        this.calculateTotalHeight();
        this.detachButton.setVisible(true);
        this.revalidate();
        this.refreshToolBar();
        this.setToolBarVisible(true);
        this.requestFocus();
    }

    void toggleDetachButton(boolean visible) {
        this.detachButton.setVisible(visible);
    }

    void addPaletteContent() {
        Alchemy.palette.addContent(this.toolBars);
    }

    void refreshColorButton() {
        this.colorButton.refresh();
    }

    void refreshTransparencySlider() {
        this.transparencySlider.setValue(Alchemy.canvas.getAlpha());
    }
}

