/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcNumberDialog;
import org.alchemy.core.AlcNumberDialogInterface;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcSliderCustom
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
AlcNumberDialogInterface,
AlcConstants {
    int width;
    int height;
    int min;
    int max;
    int displayValue;
    int trueValue;
    boolean mouseDown;
    boolean borderPainting = true;
    boolean fillPainting = true;
    Image bgImage;
    private float step;
    private float scale;
    private Color line = Color.GRAY;
    protected transient ChangeEvent changeEvent;
    private AlcNumberDialog dialog;
    private String title;

    AlcSliderCustom(String title, int width, int height, int min, int max, int initialSliderValue) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(width, height));
        this.setup(min, max);
        this.setValue(initialSliderValue);
        this.dialog = new AlcNumberDialog(this);
    }

    public void setup(int min, int max) {
        this.min = min;
        this.max = max;
        this.scale = max - min;
        this.step = this.scale / (float)this.width;
        this.moveSlider(this.displayValue);
        this.fireStateChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.bgImage != null) {
            g2.drawImage(this.bgImage, 0, 0, null);
        } else {
            g2.setColor(COLOR_UI_START);
            g2.fillRect(1, 1, this.width - 2, this.height - 2);
        }
        g2.setColor(Color.LIGHT_GRAY);
        if (this.borderPainting) {
            if (this.fillPainting) {
                g2.fillRect(1, 1, this.displayValue, this.height - 2);
            }
            AlcUtil.drawSoftRect(g2, 0, 0, this.width, this.height);
        } else if (this.fillPainting) {
            g2.fillRect(0, 0, this.displayValue, this.height);
        }
        if (this.bgImage != null) {
            g2.setColor(Color.WHITE);
            int displayValueMinus = this.displayValue - 1;
            if (displayValueMinus >= 0) {
                g2.drawLine(displayValueMinus, 0, displayValueMinus, this.height);
            }
            g2.setColor(Color.BLACK);
        } else {
            g2.setColor(this.line);
        }
        g2.drawLine(this.displayValue, 0, this.displayValue, this.height);
    }

    private void moveSlider(int x) {
        if (x < 0) {
            this.displayValue = 0;
        } else if (x > this.width) {
            this.displayValue = this.width;
        } else if (x >= 0 && x < this.width) {
            this.displayValue = x;
        }
        this.trueValue = this.min + Math.round(this.step * (float)this.displayValue);
        this.repaint();
    }

    void setBorderPainted(boolean b) {
        this.borderPainting = b;
    }

    void setFillPainted(boolean b) {
        this.fillPainting = b;
    }

    void setBgImage(Image bgImage) {
        this.bgImage = bgImage;
    }

    boolean getValueIsAdjusting() {
        return this.mouseDown;
    }

    int getValue() {
        return this.trueValue;
    }

    void setValue(int value) {
        if (value >= this.min && value <= this.max) {
            this.trueValue = value;
            this.displayValue = Math.round((float)this.width / this.scale * (float)value);
            this.repaint();
        }
    }

    void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    void fireStateChanged() {
        this.repaint();
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListeners.length - 2; i >= 0; i -= 2) {
            if (changeListeners[i] != ChangeListener.class) continue;
            ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void mouseClicked(MouseEvent e) {
        boolean showDialog = false;
        if (Alchemy.OS == 2) {
            if (e.isMetaDown()) {
                showDialog = true;
            }
        } else if (e.isControlDown()) {
            showDialog = true;
        }
        if (showDialog && !Alchemy.preferences.simpleToolBar) {
            this.dialog.show(this.min, this.max);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mouseDown = true;
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent e) {
        this.moveSlider(e.getX());
        this.mouseDown = false;
        this.fireStateChanged();
    }

    public void mouseEntered(MouseEvent e) {
        this.line = Color.BLACK;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.line = Color.GRAY;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.moveSlider(e.getX());
        this.fireStateChanged();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: 
            case 40: {
                this.moveSlider(this.displayValue - 1);
                this.fireStateChanged();
                break;
            }
            case 38: 
            case 39: {
                this.moveSlider(this.displayValue + 1);
                this.fireStateChanged();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int scrollAmount = Math.round((float)e.getUnitsToScroll() * this.step) * -1;
        this.setValue(this.trueValue + scrollAmount);
    }
}

