/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcSliderCustom;

class AlcSlider
extends JPanel
implements AlcShortcutInterface,
AlcConstants {
    protected AlcSliderCustom slider;
    private JLabel label;
    private String toolTip;

    AlcSlider(String name, String toolTip, int minValue, int maxValue, int startValue) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 3));
        this.slider = new AlcSliderCustom(name, 80, 25, minValue, maxValue, startValue);
        this.add(this.slider);
        if (name != null) {
            this.label = new JLabel(name);
            this.label.setFont(FONT_MEDIUM);
            this.label.setAlignmentX(0.5f);
            this.label.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            this.add(this.label);
        }
        if (toolTip != null) {
            this.toolTip = toolTip;
            this.setToolTipText(toolTip);
        }
    }

    public void setToolTipText(String toolTip) {
        this.slider.setToolTipText(toolTip);
        this.label.setToolTipText(toolTip);
    }

    public void refreshShortcut(int key, int modifier) {
        this.setToolTipText(AlcShortcuts.getShortcutString(key, modifier, this.toolTip));
    }

    public boolean getValueIsAdjusting() {
        return this.slider.mouseDown;
    }

    public int getValue() {
        return this.slider.trueValue;
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public void addChangeListener(ChangeListener listener) {
        this.slider.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.slider.removeChangeListener(listener);
    }
}

