/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.alchemy.core.AlcAbstractToolBar;
import org.alchemy.core.AlcButton;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcMath;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcSimpleModuleToggleButton;
import org.alchemy.core.AlcSliderCustom;
import org.alchemy.core.AlcToggleButton;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.alchemy.core.ColorBox;

public class AlcSimpleToolBar
extends AlcAbstractToolBar
implements AlcConstants {
    final ColorBox colorBox;
    AlcSliderCustom transparencySlider;

    AlcSimpleToolBar() {
        this.toolBarWidth = 150;
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, COLOR_UI_LINE));
        this.setOpaque(true);
        this.setBackground(COLOR_UI_BG);
        this.setName("Toolbar");
        ImageIcon lineWeightImage = this.getLineWidthImage(0);
        final JLabel lineWeightBox = new JLabel(lineWeightImage);
        lineWeightBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        lineWeightBox.setToolTipText(this.getS("lineWeightDescription"));
        final Rectangle lineWeightRect = new Rectangle(0, 0, lineWeightImage.getIconWidth(), lineWeightImage.getIconHeight());
        lineWeightBox.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                AlcSimpleToolBar.this.changeLineWeight(e.getPoint(), lineWeightRect, lineWeightBox);
            }
        });
        lineWeightBox.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                AlcSimpleToolBar.this.changeLineWeight(e.getPoint(), lineWeightRect, lineWeightBox);
            }
        });
        final AlcToggleButton styleButton = new AlcToggleButton();
        styleButton.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        AbstractAction styleAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.toggleStyle();
                if (Alchemy.canvas.getStyle() == 1) {
                    lineWeightBox.setVisible(true);
                } else {
                    lineWeightBox.setVisible(false);
                }
                if (!e.getSource().getClass().getName().endsWith("AlcToggleButton")) {
                    styleButton.setSelected(!styleButton.isSelected());
                }
            }
        };
        styleButton.setAction(styleAction);
        styleButton.setup(null, this.getS("styleDescription"), AlcUtil.getUrlPath("simple-style.png"));
        Alchemy.shortcuts.setShortcut(styleButton, 83, "styleTitle", styleAction);
        this.add(styleButton);
        this.add(lineWeightBox);
        this.colorBox = new ColorBox(this.toolBarWidth, 25, Alchemy.canvas.getColor());
        this.colorBox.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, COLOR_UI_LINE));
        ImageIcon colorPickerIcon = AlcUtil.getImageIcon("simple-color-picker.png");
        final Rectangle colorPickerRect = new Rectangle(0, 0, colorPickerIcon.getIconWidth(), colorPickerIcon.getIconHeight());
        final BufferedImage colorPickerBuffImage = AlcUtil.getBufferedImage(colorPickerIcon.getImage());
        JLabel colorPicker = new JLabel(colorPickerIcon);
        colorPicker.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, COLOR_UI_LINE));
        colorPicker.setToolTipText(this.getS("colorDescription"));
        Cursor pickerCursor = AlcUtil.getCursor("cursor-circle.png");
        colorPicker.setCursor(pickerCursor);
        colorPicker.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                if (colorPickerRect.contains(p)) {
                    Color c = new Color(colorPickerBuffImage.getRGB(p.x, p.y));
                    Alchemy.canvas.setColor(c);
                    AlcSimpleToolBar.this.colorBox.update(Alchemy.canvas.getColor());
                }
            }
        });
        colorPicker.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = e.getPoint();
                if (colorPickerRect.contains(p)) {
                    Color c = new Color(colorPickerBuffImage.getRGB(p.x, p.y));
                    Alchemy.canvas.setColor(c);
                    AlcSimpleToolBar.this.colorBox.update(Alchemy.canvas.getColor());
                }
            }
        });
        this.add(colorPicker);
        this.transparencySlider = new AlcSliderCustom(null, this.toolBarWidth, 25, 0, 255, 254);
        this.transparencySlider.setBorderPainted(false);
        this.transparencySlider.setFillPainted(false);
        this.transparencySlider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, COLOR_UI_LINE));
        this.transparencySlider.setToolTipText(this.getS("transparencyDescription"));
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0, 0), this.toolBarWidth, 0.0f, new Color(0, 0, 0, 255), true);
        BufferedImage gradientImage = new BufferedImage(this.toolBarWidth, 25, 2);
        Graphics2D g2 = gradientImage.createGraphics();
        g2.setPaint(gradientPaint);
        g2.fillRect(0, 0, this.toolBarWidth, 25);
        g2.dispose();
        g2 = null;
        this.transparencySlider.setBgImage(gradientImage);
        this.transparencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Alchemy.canvas.setAlpha(AlcSimpleToolBar.this.transparencySlider.getValue());
                AlcSimpleToolBar.this.colorBox.update(Alchemy.canvas.getColor());
            }
        });
        this.add(this.transparencySlider);
        this.add(this.colorBox);
        ColorBox separator = new ColorBox(this.toolBarWidth, 10, COLOR_UI_BG);
        separator.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, COLOR_UI_LINE));
        this.addModules(Alchemy.plugins.creates);
        this.add(separator);
        this.addModules(Alchemy.plugins.affects);
        this.add((ColorBox)separator.clone());
        AbstractAction clearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.clear();
            }
        };
        AlcButton clearButton = new AlcButton(clearAction);
        clearButton.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        clearButton.setup(null, this.getS("clearDescription"), AlcUtil.getUrlPath("simple-clear.png"));
        this.add(clearButton);
        Alchemy.shortcuts.setShortcut(clearButton, 8, "clearTitle", clearAction, KEY_MODIFIER);
        this.setVisible(true);
    }

    private void addModules(AlcModule[] modules) {
        ButtonGroup buttonGroup = new ButtonGroup();
        int count = 0;
        for (int i = 0; i < modules.length; ++i) {
            AlcModule currentModule = modules[i];
            if (!this.loadModule(currentModule)) continue;
            this.addModuleButton(currentModule, buttonGroup, count);
            ++count;
        }
    }

    private void addModuleButton(final AlcModule currentModule, final ButtonGroup buttonGroup, int count) {
        final boolean createModule = currentModule.getModuleType() == 1;
        final AlcSimpleModuleToggleButton moduleButton = new AlcSimpleModuleToggleButton();
        AbstractAction moduleAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (createModule) {
                    if (Alchemy.plugins.currentCreate != currentModule.getIndex()) {
                        Alchemy.plugins.setCurrentCreate(currentModule.getIndex());
                        buttonGroup.setSelected(moduleButton.getModel(), true);
                    }
                } else {
                    if (!e.getSource().getClass().getName().endsWith("AlcSimpleModuleToggleButton")) {
                        moduleButton.setSelected(!moduleButton.isSelected());
                    }
                    if (moduleButton.isSelected()) {
                        Alchemy.plugins.addAffect(currentModule.getIndex());
                    } else {
                        Alchemy.plugins.removeAffect(currentModule.getIndex());
                    }
                }
            }
        };
        moduleButton.setAction(moduleAction);
        moduleButton.setup(AlcUtil.getUrlPath(currentModule.getIconName(), currentModule.getClassLoader()), currentModule.getName());
        if (count < 9) {
            if (createModule) {
                Alchemy.shortcuts.setShortcut(moduleButton, 48 + count + 1, currentModule.getName(), moduleAction);
            } else {
                Alchemy.shortcuts.setShortcut(moduleButton, 48 + count + 1, currentModule.getName(), moduleAction, KEY_MODIFIER);
            }
        } else if (count == 9) {
            if (createModule) {
                Alchemy.shortcuts.setShortcut(moduleButton, 48, currentModule.getName(), moduleAction);
            } else {
                Alchemy.shortcuts.setShortcut(moduleButton, 48, currentModule.getName(), moduleAction, KEY_MODIFIER);
            }
        }
        if (createModule) {
            buttonGroup.add(moduleButton);
            if (count == 0) {
                buttonGroup.setSelected(moduleButton.getModel(), true);
            }
        }
        this.add(moduleButton);
    }

    void resizeToolBar(Dimension windowSize) {
        this.setBounds(0, 0, 151, windowSize.height);
        this.windowSize = windowSize;
        this.revalidate();
        this.repaint();
    }

    void refreshColorButton() {
        this.colorBox.update(Alchemy.canvas.getColor());
    }

    void refreshTransparencySlider() {
        this.transparencySlider.setValue(Alchemy.canvas.getAlpha());
    }

    private void changeLineWeight(Point p, Rectangle lineWeightRect, JLabel lineWeightBox) {
        if (lineWeightRect.contains(p)) {
            int lineWeightInc = (int)AlcMath.map(p.x, 25.0f, this.toolBarWidth, 1.0f, 10.0f);
            Alchemy.canvas.setLineWidth(lineWeightInc * 4 + 1);
            lineWeightBox.setIcon(this.getLineWidthImage(lineWeightInc));
        }
    }

    private ImageIcon getLineWidthImage(int lineWidth) {
        BufferedImage lineWeightImage = new BufferedImage(this.toolBarWidth, 25, 2);
        Graphics2D g2 = lineWeightImage.createGraphics();
        for (int i = 0; i < 10; ++i) {
            if (i == lineWidth) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(Color.LIGHT_GRAY);
            }
            int inc = i + 1;
            g2.fillRect(inc * 13, 0, inc, 25);
        }
        g2.dispose();
        g2 = null;
        return new ImageIcon(lineWeightImage);
    }
}

