/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcUtil;

class AlcSimpleModuleToggleButton
extends JToggleButton {
    AlcSimpleModuleToggleButton() {
    }

    AlcSimpleModuleToggleButton(Action action) {
        this.setAction(action);
    }

    AlcSimpleModuleToggleButton(URL iconUrl) {
        this.setup(iconUrl, null);
    }

    void setup(URL iconUrl) {
        this.setup(iconUrl, null);
    }

    void setup(URL iconUrl, String toolTip) {
        if (iconUrl != null) {
            ImageIcon icon = AlcUtil.getImageIcon(iconUrl);
            this.setIcon(this.createIcon(icon, AlcToolBar.COLOR_UI_BG));
            this.setRolloverIcon(this.createIcon(icon, AlcToolBar.COLOR_UI_END));
            this.setSelectedIcon(this.createIcon(icon, Color.GRAY));
        }
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
    }

    private ImageIcon createIcon(ImageIcon icon, Color bgColor) {
        int padding = 12;
        int halfPad = padding / 2;
        int width = icon.getIconWidth() + padding;
        int height = icon.getIconHeight() + padding;
        BufferedImage iconBg = new BufferedImage(width, height, 2);
        Graphics2D g2 = iconBg.createGraphics();
        g2.setColor(bgColor);
        g2.fillRect(0, 0, width, height);
        g2.setColor(AlcToolBar.COLOR_UI_LINE);
        g2.drawRect(0, 0, width - 1, height - 1);
        g2.drawImage(icon.getImage(), halfPad, halfPad, null);
        g2.dispose();
        return new ImageIcon(iconBg);
    }
}

