/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.Alchemy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlcShape
implements AlcConstants,
Cloneable,
Serializable {
    GeneralPath path;
    Color color;
    int alpha = 255;
    int style;
    private GradientPaint gradientPaint;
    float lineWidth;
    private static boolean lineSmoothing = true;
    private Point2D.Float lastPoint;
    private boolean pathClosed = false;
    private boolean penShape = false;
    private int totalPoints = 0;
    private ArrayList<Point2D.Float> spine;
    private ArrayList<Float> spineWidth;
    private final int startPoints = 5;
    private final int minDistance = 5;
    private final int minDistanceSpine = 3;

    public AlcShape(Point p) {
        this.setup(p);
        this.setup();
    }

    public AlcShape(Point2D.Float p) {
        this.setup(p);
        this.setup();
    }

    public AlcShape(Point p, Color color, int alpha, int style, float lineWidth) {
        this.setup(p);
        this.setup(color, alpha, style, lineWidth);
    }

    public AlcShape(Point2D.Float p, Color color, int alpha, int style, float lineWidth) {
        this.setup(p);
        this.setup(color, alpha, style, lineWidth);
    }

    public AlcShape() {
        this.path = new GeneralPath(1, 1000);
        this.setup();
    }

    public AlcShape(GeneralPath path) {
        this.setup(path);
        this.setup();
    }

    public AlcShape(GeneralPath path, Color color, int alpha, int style, float lineWidth) {
        this.setup(path);
        this.setup(color, alpha, style, lineWidth);
    }

    private void setup(Point p) {
        this.setup(new Point2D.Float(p.x, p.y));
    }

    private void setup(Point2D.Float p) {
        this.path = new GeneralPath(1, 1000);
        this.path.moveTo(p.x, p.y);
        ++this.totalPoints;
        this.savePoints(p);
    }

    private void setup(GeneralPath path) {
        this.path = path;
        path.setWindingRule(1);
        this.recalculateTotalPoints();
    }

    public void setup(Color color, int alpha, int style, float lineWidth) {
        this.alpha = alpha;
        this.setColor(color);
        this.style = style;
        if (lineWidth < 0.0f) {
            lineWidth = 0.0f;
        }
        this.lineWidth = lineWidth;
    }

    public void setup() {
        this.alpha = Alchemy.canvas.getAlpha();
        this.setColor(Alchemy.canvas.getColor());
        this.style = Alchemy.canvas.getStyle();
        this.lineWidth = Alchemy.canvas.getLineWidth() < 0.0f ? 0.0f : Alchemy.canvas.getLineWidth();
    }

    public void curveTo(Point p) {
        this.curveTo(new Point2D.Float(p.x, p.y));
    }

    public void curveTo(Point2D.Float p) {
        if (lineSmoothing) {
            if (!p.equals(this.lastPoint)) {
                if (this.totalPoints < 5) {
                    this.path.lineTo(p.x, p.y);
                    this.savePoints(p);
                } else {
                    double movement = p.distance(this.lastPoint);
                    if (movement > 5.0) {
                        Point2D.Float pt = new Point2D.Float();
                        pt.x = (this.lastPoint.x + p.x) / 2.0f;
                        pt.y = (this.lastPoint.y + p.y) / 2.0f;
                        this.path.quadTo(this.lastPoint.x, this.lastPoint.y, pt.x, pt.y);
                        this.savePoints(p);
                    }
                }
            }
        } else {
            this.lineTo(p);
        }
    }

    public void lineTo(Point p) {
        this.lineTo(new Point2D.Float(p.x, p.y));
    }

    public void lineTo(Point2D.Float p) {
        if (!p.equals(this.lastPoint)) {
            if (this.totalPoints < 5) {
                this.path.lineTo(p.x, p.y);
                this.savePoints(p);
            } else {
                double movement = p.distance(this.lastPoint);
                if (movement > 5.0) {
                    this.path.lineTo(p.x, p.y);
                    this.savePoints(p);
                }
            }
        }
    }

    public void spineTo(Point2D.Float p, float width) {
        this.penShape = true;
        if (this.spine == null) {
            this.spine = new ArrayList(1000);
        }
        if (this.spineWidth == null) {
            this.spineWidth = new ArrayList(1000);
        }
        if (Alchemy.canvas.isPenLocationChanged()) {
            if (this.spine.size() == 0) {
                this.spine.add(p);
                this.spineWidth.add(Float.valueOf(width));
            } else {
                Point2D.Float lastPt = this.spine.get(this.spine.size() - 1);
                double distance = p.distance(lastPt);
                if (distance > 3.0) {
                    this.spine.add(p);
                    this.spineWidth.add(Float.valueOf(width));
                    this.createSpine();
                }
            }
        }
    }

    public void createSpine() {
        if (this.spine.size() > 0) {
            this.setPoint(this.spine.get(0));
            for (int i = 1; i < this.spine.size(); ++i) {
                Point2D.Float p2 = this.spine.get(i - 1);
                Point2D.Float p1 = this.spine.get(i);
                float level = this.spineWidth.get(i).floatValue();
                Point2D.Float pOut = AlcShape.rightAngle(p1, p2, level);
                this.curveTo(pOut);
            }
            for (int j = 1; j < this.spine.size(); ++j) {
                int index = this.spine.size() - j;
                Point2D.Float p2 = this.spine.get(index);
                Point2D.Float p1 = this.spine.get(index - 1);
                float level = this.spineWidth.get(index).floatValue();
                Point2D.Float pIn = AlcShape.rightAngle(p1, p2, level);
                this.curveTo(pIn);
            }
            this.closePath();
        }
    }

    public void append(GeneralPath newPath, boolean connect) {
        this.path.append(newPath, connect);
    }

    private void savePoints(Point2D.Float p) {
        ++this.totalPoints;
        this.lastPoint = new Point2D.Float(p.x, p.y);
        this.penShape = true;
    }

    public void moveTo(Point p) {
        this.path.moveTo(p.x, p.y);
    }

    public void moveTo(Point2D.Float p) {
        this.path.moveTo(p.x, p.y);
    }

    public void closePath() {
        this.path.closePath();
        this.pathClosed = true;
    }

    public void move(double x, double y) {
        GeneralPath transformedPath;
        AffineTransform move = AffineTransform.getTranslateInstance(x, y);
        this.path = transformedPath = (GeneralPath)this.path.createTransformedShape(move);
    }

    public void scale(double sx, double sy) {
        GeneralPath transformedPath;
        AffineTransform scale = AffineTransform.getScaleInstance(sx, sy);
        this.path = transformedPath = (GeneralPath)this.path.createTransformedShape(scale);
    }

    public void rotate(double theta) {
        Rectangle bounds = this.path.getBounds();
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        this.rotate(theta, x, y);
    }

    public void rotate(double theta, double x, double y) {
        GeneralPath transformedPath;
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, x, y);
        this.path = transformedPath = (GeneralPath)this.path.createTransformedShape(rotate);
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public void setPath(GeneralPath path) {
        this.path = path;
    }

    public void setPoint(Point p) {
        this.setPoint(new Point2D.Float(p.x, p.y));
    }

    public void setPoint(Point2D.Float p) {
        this.path = new GeneralPath(1, 1000);
        this.path.moveTo(p.x, p.y);
        this.totalPoints = 1;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    public void setTotalPoints(int totalPoints) {
        this.totalPoints = totalPoints;
    }

    public void recalculateTotalPoints() {
        PathIterator count = this.path.getPathIterator(null);
        int numberOfPoints = 0;
        while (!count.isDone()) {
            ++numberOfPoints;
            count.next();
        }
        this.totalPoints = numberOfPoints;
    }

    public Point2D.Float getLastPoint() {
        return this.lastPoint;
    }

    public void setLastPoint(Point2D.Float lastPt) {
        this.lastPoint = lastPt;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
    }

    Paint getPaint() {
        if (this.gradientPaint != null) {
            return this.gradientPaint;
        }
        return this.color;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.setColor(this.color);
    }

    public void setAlphaColor(Color color) {
        this.color = color;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public GradientPaint getGradientPaint() {
        return this.gradientPaint;
    }

    public void setGradientPaint(GradientPaint gradientPaint) {
        this.gradientPaint = gradientPaint;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public static boolean isLineSmoothing() {
        return lineSmoothing;
    }

    public static void setLineSmoothing(boolean lineSmoothing) {
        AlcShape.lineSmoothing = lineSmoothing;
    }

    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    public boolean isPathClosed() {
        return this.pathClosed;
    }

    void setPathClosed(boolean pathClosed) {
        this.pathClosed = pathClosed;
    }

    public boolean isPenShape() {
        return this.penShape;
    }

    void setPenShape(boolean penShape) {
        this.penShape = penShape;
    }

    public boolean hasSpine() {
        return this.spine != null;
    }

    public ArrayList<Point2D.Float> getSpine() {
        return this.spine;
    }

    public void setSpine(ArrayList<Point2D.Float> spine) {
        this.spine = spine;
    }

    public ArrayList<Float> getSpineWidth() {
        return this.spineWidth;
    }

    public void setSpineWidth(ArrayList<Float> spineWidth) {
        this.spineWidth = spineWidth;
    }

    public ArrayList<Point2D.Float> getPoints() {
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] points = new float[6];
        ArrayList<Point2D.Float> list = new ArrayList<Point2D.Float>(1000);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(points)) {
                case 0: {
                    list.add(new Point2D.Float(points[0], points[1]));
                    break;
                }
                case 1: {
                    list.add(new Point2D.Float(points[0], points[1]));
                    break;
                }
                case 2: {
                    list.add(new Point2D.Float(points[2], points[3]));
                    break;
                }
                case 3: {
                    list.add(new Point2D.Float(points[4], points[5]));
                }
            }
            pathIterator.next();
        }
        return list;
    }

    public static Point2D.Float rightAngle(Point2D.Float p1, Point2D.Float p2, double distance) {
        double angle = Math.atan2(p1.y - p2.y, p1.x - p2.x) - 1.5707963705062866;
        double x = (double)p1.x + distance * Math.cos(angle);
        double y = (double)p1.y + distance * Math.sin(angle);
        return new Point2D.Float((float)x, (float)y);
    }

    public Object clone() {
        AlcShape tempShape = new AlcShape(this.path, this.color, this.alpha, this.style, this.lineWidth);
        this.cloneAttributes(tempShape);
        return tempShape;
    }

    public AlcShape customClone(GeneralPath tempPath) {
        AlcShape tempShape = new AlcShape(tempPath);
        this.cloneAttributes(tempShape);
        return tempShape;
    }

    public AlcShape customClone(ArrayList<Point2D.Float> spine, ArrayList<Float> spineWidth) {
        AlcShape tempShape = new AlcShape();
        tempShape.setSpine(spine);
        tempShape.setSpineWidth(spineWidth);
        tempShape.createSpine();
        this.cloneAttributes(tempShape);
        return tempShape;
    }

    private void cloneAttributes(AlcShape tempShape) {
        tempShape.setAlpha(this.alpha);
        tempShape.setStyle(this.style);
        tempShape.setLineWidth(this.lineWidth);
        tempShape.setTotalPoints(this.totalPoints);
        tempShape.setLastPoint(this.lastPoint);
        tempShape.setPathClosed(this.pathClosed);
        tempShape.setPenShape(this.penShape);
        if (this.gradientPaint != null) {
            GradientPaint gp = new GradientPaint(this.gradientPaint.getPoint1(), this.gradientPaint.getColor1(), this.gradientPaint.getPoint2(), this.gradientPaint.getColor2());
            tempShape.setGradientPaint(gp);
        }
    }
}

