/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.BorderFactory;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcRadioButtonMenuItem
extends JRadioButtonMenuItem
implements AlcShortcutInterface,
AlcConstants {
    private int index;
    private int moduleType = -1;
    private static int checkX = Alchemy.OS == 2 ? 7 : 6;
    private String toolTip;
    Ellipse2D.Double toolCircle = new Ellipse2D.Double(checkX, 13.0, 8.0, 8.0);
    Ellipse2D.Double toolCircleLine = new Ellipse2D.Double(checkX + 1, 15.0, 6.0, 6.0);
    Ellipse2D.Double toolInnerCircle = new Ellipse2D.Double(checkX + 1, 14.0, 6.0, 6.0);
    Ellipse2D.Double menuCircle = new Ellipse2D.Double(checkX, 7.0, 8.0, 8.0);
    Ellipse2D.Double menuInnerCircle = new Ellipse2D.Double(checkX + 1, 8.0, 6.0, 6.0);

    AlcRadioButtonMenuItem() {
    }

    AlcRadioButtonMenuItem(int index, String title) {
        this.setup(index, title);
    }

    AlcRadioButtonMenuItem(int index, String title, int accelerator) {
        this.setup(index, title);
        if (accelerator > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator, KEY_MODIFIER));
        }
    }

    void setup(AlcModule module) {
        this.setup(module.getIndex(), module.getName());
        this.moduleType = module.getModuleType();
        this.toolTip = module.getDescription();
        this.setToolTipText(this.toolTip);
        this.setIcon(AlcUtil.getImageIcon(module.getIconUrl()));
    }

    private void setup(int index, String title) {
        this.index = index;
        this.setText(title);
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        if (Alchemy.OS != 3) {
            this.setBackground(COLOR_UI_HIGHLIGHT);
        }
        this.setFont(FONT_MEDIUM);
    }

    int getIndex() {
        return this.index;
    }

    int getModuleType() {
        return this.moduleType;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (Alchemy.OS != 3 && !Alchemy.OS_IS_VISTA) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!this.isSelected()) {
                g2.setColor(COLOR_UI_BOX);
                if (this.moduleType != -1) {
                    g2.draw(this.toolCircleLine);
                } else {
                    g2.draw(this.menuInnerCircle);
                }
            } else if (this.moduleType != -1) {
                if (Alchemy.OS != 2) {
                    g2.setColor(this.getBackground());
                    g2.fill(this.toolCircle);
                    g2.setColor(Color.BLACK);
                    g2.fill(this.toolInnerCircle);
                }
            } else {
                g2.setColor(this.getBackground());
                g2.fill(this.menuCircle);
                g2.setColor(Color.BLACK);
                g2.fill(this.menuInnerCircle);
            }
        }
    }

    public void refreshShortcut(int key, int modifier) {
        this.setToolTipText(AlcShortcuts.getShortcutString(key, modifier, this.toolTip));
    }
}

