/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.Alchemy;

class AlcPopupMenu
extends JPopupMenu
implements AlcConstants {
    static final int uiPopupMenuY = 47;
    boolean inside = false;
    boolean clickOk = true;

    AlcPopupMenu() {
        this.setBackground(COLOR_UI_HIGHLIGHT);
        this.setOpaque(true);
        Border outline = BorderFactory.createLineBorder(COLOR_UI_LINE, 1);
        Border empty = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        CompoundBorder compound = BorderFactory.createCompoundBorder(outline, empty);
        this.setBorder(compound);
        this.addMouseListener(this.createMouseListener(this));
        this.addPopupMenuListener(this.createPopupMenuListener());
    }

    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        if (Alchemy.OS == 2) {
            this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        }
    }

    PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Timer initialDelay = new Timer(50, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        AlcPopupMenu.this.clickOk = true;
                    }
                });
                initialDelay.setRepeats(false);
                initialDelay.start();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    MouseListener createMouseListener(final AlcPopupMenu popup) {
        return new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                AlcPopupMenu.this.inside = popup.contains(e.getPoint());
            }

            public void mouseExited(MouseEvent e) {
                AlcPopupMenu.this.inside = popup.contains(e.getPoint());
            }
        };
    }
}

