/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcPaletteTitleBar;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcWindow;
import org.alchemy.core.Alchemy;

class AlcPalette
extends JWindow
implements KeyListener,
MouseListener,
AlcConstants {
    public JPanel mainPalette;
    private Component content;
    private AlcPaletteTitleBar titleBar;
    private int maxSize = 1280;
    private int minSize = 600;
    private int paletteHeight = 87;

    AlcPalette(AlcWindow owner) {
        super(owner);
        this.setGoodSize();
        this.setBackground(Color.WHITE);
        this.setFocusable(true);
        this.mainPalette = new JPanel();
        this.mainPalette.setBackground(AlcToolBar.COLOR_UI_BG);
        this.mainPalette.setBorder(new LineBorder(AlcToolBar.COLOR_UI_LINE, 1));
        this.mainPalette.setLayout(new BorderLayout());
        this.mainPalette.setCursor(CURSOR_ARROW);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.titleBar = new AlcPaletteTitleBar(this);
        this.mainPalette.add("West", this.titleBar);
        this.setContentPane(this.mainPalette);
        if (Alchemy.OS == 2) {
            this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        }
    }

    void shiftPalette(int x, int y) {
        Point aPoint = this.getLocation();
        this.setLocation(aPoint.x + x, aPoint.y + y);
    }

    void addContent(Component comp) {
        this.setGoodSize();
        if (this.content != null) {
            this.mainPalette.remove(this.content);
        }
        this.content = comp;
        this.mainPalette.add("Center", comp);
        this.mainPalette.revalidate();
    }

    private void setGoodSize() {
        if (Alchemy.window.getWindowSize().width < this.minSize) {
            this.setSize(this.minSize, this.paletteHeight);
        } else if (Alchemy.window.getWindowSize().width > this.maxSize) {
            this.setSize(this.maxSize, this.paletteHeight);
        } else {
            this.setSize(Alchemy.window.getWindowSize().width, this.paletteHeight);
        }
    }

    public void keyPressed(KeyEvent event) {
        Alchemy.window.keyPressed(event);
    }

    public void keyReleased(KeyEvent event) {
        Alchemy.window.keyReleased(event);
    }

    public void keyTyped(KeyEvent event) {
        Alchemy.window.keyTyped(event);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        Alchemy.canvas.setTempCursor(CURSOR_ARROW);
    }

    public void mouseExited(MouseEvent event) {
        if (!this.contains(event.getPoint())) {
            Alchemy.canvas.restoreCursor();
        }
    }

    public void mousePressed(MouseEvent event) {
        this.requestFocus();
        this.toFront();
    }

    public void mouseReleased(MouseEvent event) {
    }
}

