/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcNumberDialogInterface;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcNumberDialog
extends JDialog
implements AlcConstants {
    private JSpinner minField;
    private JSpinner maxField;
    private SpinnerNumberModel minModel;
    private SpinnerNumberModel maxModel;
    private AlcNumberDialogInterface parent;
    private JButton okButton;
    private JButton cancelButton;

    AlcNumberDialog(AlcNumberDialogInterface parent) {
        super((Frame)Alchemy.window, parent.getTitle() + " " + Alchemy.bundle.getString("sliderDialogTitle"));
        this.parent = parent;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel();
        content.setPreferredSize(new Dimension(250, 90));
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.setBackground(COLOR_UI_HIGHLIGHT);
        this.minField = new JSpinner();
        this.maxField = new JSpinner();
        content.add(new JLabel(Alchemy.bundle.getString("minimum") + ":"));
        content.add(this.minField);
        content.add(new JLabel(Alchemy.bundle.getString("maximum") + ":"));
        content.add(this.maxField);
        this.getContentPane().add((Component)content, "North");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.setResizable(false);
        this.pack();
        this.setDefaultCloseOperation(1);
        AlcUtil.registerWindowCloseKeys(this.getRootPane(), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlcNumberDialog.this.setVisible(false);
            }
        });
    }

    void show(int min, int max) {
        this.minModel = new SpinnerNumberModel(min, -10000, 10000, 1);
        this.maxModel = new SpinnerNumberModel(max, -10000, 10000, 1);
        this.minField.setModel(this.minModel);
        this.maxField.setModel(this.maxModel);
        Point p = AlcUtil.calculateCenter(this);
        this.setLocation(p);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.cancelButton = new JButton(Alchemy.bundle.getString("cancel"));
        this.cancelButton.setMnemonic(27);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcNumberDialog.this.setVisible(false);
            }
        });
        this.okButton = new JButton(Alchemy.bundle.getString("ok"));
        this.okButton.setMnemonic(10);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer newMin = (Integer)AlcNumberDialog.this.minModel.getValue();
                Integer newMax = (Integer)AlcNumberDialog.this.maxModel.getValue();
                AlcNumberDialog.this.parent.setup(newMin, newMax);
                AlcNumberDialog.this.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        if (Alchemy.OS == 2) {
            buttonPane.add(this.cancelButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.okButton);
        } else {
            buttonPane.add(this.okButton);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(this.cancelButton);
        }
        return buttonPane;
    }
}

