/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import org.alchemy.core.AlcCheckBoxMenuItem;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcExportDialog;
import org.alchemy.core.AlcFileChooser;
import org.alchemy.core.AlcImageTransferable;
import org.alchemy.core.AlcMenu;
import org.alchemy.core.AlcMenuItem;
import org.alchemy.core.AlcRadioButtonMenuItem;
import org.alchemy.core.AlcShape;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;
import org.alchemy.core.ExportFileFilter;

class AlcMenuBar
extends JMenuBar
implements AlcConstants {
    private static final int height = 27;
    private File platformAppDir;
    private PrinterJob printer = null;
    private PageFormat page = null;
    private PageFormat defaultPage = null;
    private AlcMenuItem nextPageItem;
    private AlcMenuItem previousPageItem;
    private AlcMenuItem unloadSessionItem;
    AlcMenuItem unloadBackgroundImageItem;
    private AlcCheckBoxMenuItem linkSessionItem;
    AlcCheckBoxMenuItem fullScreenItem;
    AlcCheckBoxMenuItem transparentItem;
    private AlcExportDialog exportDialog;

    AlcMenuBar() {
        switch (Alchemy.OS) {
            case 2: {
                this.platformAppDir = new File(File.separator + "Applications");
                this.setBorderPainted(false);
                break;
            }
            case 1: {
                this.platformAppDir = new File(File.separator + "Program Files");
                break;
            }
            case 3: {
                this.platformAppDir = new File(File.separator + "usr" + File.separator + "bin");
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        }
        this.setBackground(AlcToolBar.COLOR_UI_HIGHLIGHT);
        int[] recordingInterval = new int[]{5000, 15000, 30000, 60000, 120000, 300000, 600000};
        String[] recordingIntervalString = new String[recordingInterval.length];
        for (int i = 0; i < recordingIntervalString.length; ++i) {
            recordingIntervalString[i] = this.getS("interval" + recordingInterval[i]);
        }
        AlcMenu fileMenu = new AlcMenu(this.getS("fileTitle"));
        String newTitle = this.getS("newTitle");
        AbstractAction newAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                boolean result;
                if (Alchemy.canvas.shapes.size() > 0 && (result = AlcUtil.showConfirmDialogFromBundle("newWinDialogTitle", "newWinDialogMessage", "newMacDialogTitle", "newMacDialogMessage"))) {
                    Alchemy.canvas.clear();
                }
            }
        };
        AlcMenuItem newItem = new AlcMenuItem(newAction);
        int newKey = Alchemy.shortcuts.setShortcut(newItem, 78, "newTitle", newAction, KEY_MODIFIER);
        newItem.setup(newTitle, newKey);
        fileMenu.add(newItem);
        fileMenu.add(new JSeparator());
        String exportTitle = this.getS("exportTitle");
        AbstractAction exportAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.export();
            }
        };
        AlcMenuItem exportItem = new AlcMenuItem(exportAction);
        int exportKey = Alchemy.shortcuts.setShortcut(exportItem, 69, "exportTitle", exportAction, KEY_MODIFIER);
        exportItem.setup(exportTitle, exportKey);
        fileMenu.add(exportItem);
        fileMenu.add(new JSeparator());
        AbstractAction pageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.pageSetup();
            }
        };
        AlcMenuItem pageItem = new AlcMenuItem(pageAction);
        pageItem.setup(this.getS("pageSetupTitle"));
        fileMenu.add(pageItem);
        String printTitle = this.getS("printTitle");
        AbstractAction printAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.print();
            }
        };
        AlcMenuItem printItem = new AlcMenuItem(printAction);
        int printKey = Alchemy.shortcuts.setShortcut(printItem, 80, "printTitle", printAction, KEY_MODIFIER);
        printItem.setup(printTitle, printKey);
        fileMenu.add(printItem);
        if (Alchemy.OS != 2) {
            fileMenu.add(new JSeparator());
            AbstractAction exitAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Alchemy.window.exitAlchemy();
                }
            };
            AlcMenuItem exitItem = new AlcMenuItem(exitAction);
            exitItem.setup(this.getS("exitTitle"));
            fileMenu.add(exitItem);
        }
        this.add(fileMenu);
        AlcMenu editMenu = new AlcMenu(this.getS("editTitle"));
        String copyTitle = this.getS("copyTitle");
        AbstractAction copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.copy();
            }
        };
        AlcMenuItem copyItem = new AlcMenuItem(copyAction);
        int copyKey = Alchemy.shortcuts.setShortcut(copyItem, 67, "copyTitle", copyAction, KEY_MODIFIER);
        copyItem.setup(copyTitle, copyKey);
        editMenu.add(copyItem);
        editMenu.add(new JSeparator());
        String flipHorizontalTitle = this.getS("flipHorizontal");
        AbstractAction flipHorizontalAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.flipHorizontal();
            }
        };
        AlcMenuItem flipHorizontalItem = new AlcMenuItem(flipHorizontalAction);
        int flipHorizontalKey = Alchemy.shortcuts.setShortcut(flipHorizontalItem, 59, "flipHorizontal", flipHorizontalAction, KEY_MODIFIER);
        flipHorizontalItem.setup(flipHorizontalTitle, flipHorizontalKey);
        editMenu.add(flipHorizontalItem);
        String flipVerticalTitle = this.getS("flipVertical");
        AbstractAction flipVerticalAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.flipVertical();
            }
        };
        AlcMenuItem flipVerticalItem = new AlcMenuItem(flipVerticalAction);
        int flipVerticalKey = Alchemy.shortcuts.setShortcut(flipVerticalItem, 222, "flipVertical", flipVerticalAction, KEY_MODIFIER);
        flipVerticalItem.setup(flipVerticalTitle, flipVerticalKey);
        editMenu.add(flipVerticalItem);
        this.add(editMenu);
        AlcMenu viewMenu = new AlcMenu(this.getS("viewTitle"));
        String fullScreenTitle = this.getS("fullScreenTitle");
        this.fullScreenItem = new AlcCheckBoxMenuItem();
        AbstractAction fullScreenAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String source = e.getSource().getClass().getName();
                if (!source.equals("org.alchemy.core.AlcCheckBoxMenuItem")) {
                    AlcMenuBar.this.fullScreenItem.setState(!AlcMenuBar.this.fullScreenItem.getState());
                }
                Alchemy.window.setFullscreen(!Alchemy.window.isFullscreen());
            }
        };
        this.fullScreenItem.setAction(fullScreenAction);
        int fullScreenKey = Alchemy.shortcuts.setShortcut(this.fullScreenItem, 70, "fullScreenTitle", fullScreenAction, KEY_MODIFIER);
        this.fullScreenItem.setup(fullScreenTitle, fullScreenKey);
        viewMenu.add(this.fullScreenItem);
        String transparentTitle = this.getS("transparentTitle");
        this.transparentItem = new AlcCheckBoxMenuItem();
        if (Alchemy.window.isTransparent()) {
            this.transparentItem.setSelected(true);
        }
        AbstractAction transparentAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String source = e.getSource().getClass().getName();
                if (!source.equals("org.alchemy.core.AlcCheckBoxMenuItem")) {
                    AlcMenuBar.this.transparentItem.setState(!AlcMenuBar.this.transparentItem.getState());
                }
                Alchemy.window.setTransparent(!Alchemy.window.isTransparent());
            }
        };
        this.transparentItem.setAction(transparentAction);
        int transparentKey = Alchemy.shortcuts.setShortcut(this.transparentItem, 84, "transparentTitle", transparentAction, KEY_MODIFIER);
        this.transparentItem.setup(transparentTitle, transparentKey);
        viewMenu.add(this.transparentItem);
        viewMenu.add(new JSeparator());
        String loadBackgroundImageTitle = this.getS("loadBackgroundImageTitle");
        AlcMenuItem loadBackgroundImageItem = new AlcMenuItem(loadBackgroundImageTitle);
        AbstractAction loadBackgroundImageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File file = AlcUtil.showFileChooser(new File(AlcConstants.DIR_DESKTOP), false);
                if (file != null && file.exists()) {
                    Image image = null;
                    try {
                        image = AlcUtil.getImage(file.toURI().toURL());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (image != null) {
                        Rectangle visibleRect = Alchemy.canvas.getVisibleRect();
                        int x = (visibleRect.width - image.getWidth(null)) / 2;
                        int y = (visibleRect.height - image.getHeight(null)) / 2;
                        Alchemy.canvas.setImageLocation(x, y);
                        Alchemy.canvas.setImageDisplay(true);
                        Alchemy.canvas.setImage(AlcUtil.getBufferedImage(image));
                        Alchemy.canvas.redraw();
                    } else {
                        AlcUtil.showConfirmDialogFromBundle("imageErrorDialogTitle", "imageErrorDialogMessage");
                    }
                } else {
                    System.out.println("Error reading the file...");
                }
            }
        };
        loadBackgroundImageItem.setAction(loadBackgroundImageAction);
        int loadBackgroundImageKey = Alchemy.shortcuts.setShortcut(loadBackgroundImageItem, 76, "loadBackgroundImageTitle", loadBackgroundImageAction, KEY_MODIFIER);
        loadBackgroundImageItem.setup(loadBackgroundImageTitle, loadBackgroundImageKey);
        viewMenu.add(loadBackgroundImageItem);
        AbstractAction unloadBackgroundImageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.canvas.setImageLocation(0, 0);
                Alchemy.canvas.setImageDisplay(false);
                Alchemy.canvas.setImage(null);
                Alchemy.canvas.redraw();
            }
        };
        this.unloadBackgroundImageItem = new AlcMenuItem(unloadBackgroundImageAction);
        this.unloadBackgroundImageItem.setup(this.getS("unloadBackgroundImageTitle"));
        this.unloadBackgroundImageItem.setEnabled(false);
        viewMenu.add(this.unloadBackgroundImageItem);
        this.add(viewMenu);
        AlcMenu sessionMenu = new AlcMenu(this.getS("sessionTitle"));
        String savePageTitle = this.getS("savePageTitle");
        AbstractAction savePageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.manualSavePage();
            }
        };
        AlcMenuItem savePageItem = new AlcMenuItem(savePageAction);
        int savePageKey = Alchemy.shortcuts.setShortcut(savePageItem, 83, "savePageTitle", savePageAction, KEY_MODIFIER);
        savePageItem.setup(savePageTitle, savePageKey);
        sessionMenu.add(savePageItem);
        String saveClearTitle = this.getS("saveClearTitle");
        AbstractAction saveClearPageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.manualSaveClearPage();
            }
        };
        AlcMenuItem saveClearPageItem = new AlcMenuItem(saveClearPageAction);
        int saveClearKey = Alchemy.shortcuts.setShortcut(saveClearPageItem, 68, "saveClearTitle", saveClearPageAction, KEY_MODIFIER);
        saveClearPageItem.setup(saveClearTitle, saveClearKey);
        sessionMenu.add(saveClearPageItem);
        sessionMenu.add(new JSeparator());
        String recordingTitle = this.getS("recordingTitle");
        final AlcCheckBoxMenuItem recordingItem = new AlcCheckBoxMenuItem();
        AbstractAction recordingAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String source = e.getSource().getClass().getName();
                if (!source.equals("org.alchemy.core.AlcCheckBoxMenuItem")) {
                    recordingItem.setState(!recordingItem.getState());
                }
                Alchemy.session.setRecording(recordingItem.getState());
                System.out.println("STATE: " + recordingItem.getState());
            }
        };
        recordingItem.setAction(recordingAction);
        int recordingKey = Alchemy.shortcuts.setShortcut(recordingItem, 82, "recordingTitle", recordingAction, KEY_MODIFIER);
        recordingItem.setup(recordingTitle, recordingKey);
        recordingItem.setState(Alchemy.preferences.sessionRecordingState);
        if (Alchemy.preferences.sessionRecordingState) {
            Alchemy.session.setRecording(true);
        }
        sessionMenu.add(recordingItem);
        AlcMenu intervalMenu = new AlcMenu(this.getS("recordIntervalTitle"));
        if (Alchemy.OS != 3) {
            intervalMenu.setOpaque(true);
            intervalMenu.setBackground(AlcToolBar.COLOR_UI_HIGHLIGHT);
        }
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < recordingIntervalString.length; ++i) {
            AlcRadioButtonMenuItem intervalItem = new AlcRadioButtonMenuItem(recordingInterval[i], recordingIntervalString[i]);
            if (Alchemy.preferences.sessionRecordingInterval == recordingInterval[i]) {
                intervalItem.setSelected(true);
            }
            intervalItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlcRadioButtonMenuItem source = (AlcRadioButtonMenuItem)e.getSource();
                    Alchemy.session.setTimerInterval(source.getIndex());
                }
            });
            group.add(intervalItem);
            intervalMenu.add(intervalItem);
        }
        intervalMenu.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        sessionMenu.add(intervalMenu);
        AbstractAction autoClearAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcCheckBoxMenuItem source = (AlcCheckBoxMenuItem)e.getSource();
                Alchemy.preferences.sessionAutoClear = source.getState();
            }
        };
        AlcCheckBoxMenuItem autoClearItem = new AlcCheckBoxMenuItem(autoClearAction);
        autoClearItem.setup(this.getS("autoClearTitle"));
        autoClearItem.setState(Alchemy.preferences.sessionAutoClear);
        sessionMenu.add(autoClearItem);
        sessionMenu.add(new JSeparator());
        String loadSessionTitle = this.getS("loadSessionTitle");
        AbstractAction loadSessionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File file = AlcUtil.showFileChooser(new File(AlcConstants.DIR_DESKTOP), false);
                if (file != null && file.exists()) {
                    boolean loaded = Alchemy.session.loadSessionFile(file);
                    AlcMenuBar.this.nextPageItem.setEnabled(loaded);
                    AlcMenuBar.this.previousPageItem.setEnabled(loaded);
                    AlcMenuBar.this.unloadSessionItem.setEnabled(loaded);
                    AlcMenuBar.this.linkSessionItem.setEnabled(loaded);
                }
            }
        };
        AlcMenuItem loadSessionItem = new AlcMenuItem(loadSessionAction);
        loadSessionItem.setup(loadSessionTitle);
        sessionMenu.add(loadSessionItem);
        String nextPageTitle = this.getS("nextPageTitle");
        AbstractAction nextPageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.nextPage();
            }
        };
        this.nextPageItem = new AlcMenuItem(nextPageAction);
        int nextPageKey = Alchemy.shortcuts.setShortcut(this.nextPageItem, 39, "nextPageTitle", nextPageAction, KEY_MODIFIER);
        this.nextPageItem.setup(nextPageTitle, nextPageKey);
        sessionMenu.add(this.nextPageItem);
        this.nextPageItem.setEnabled(false);
        String previousPageTitle = this.getS("previousPageTitle");
        AbstractAction previousPageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.previousPage();
            }
        };
        this.previousPageItem = new AlcMenuItem(previousPageAction);
        int previousPageKey = Alchemy.shortcuts.setShortcut(this.previousPageItem, 37, "previousPageTitle", previousPageAction, KEY_MODIFIER);
        this.previousPageItem.setup(previousPageTitle, previousPageKey);
        sessionMenu.add(this.previousPageItem);
        this.previousPageItem.setEnabled(false);
        String unloadSessionTitle = this.getS("unloadSessionTitle");
        AbstractAction unloadSessionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.unloadSessionFile();
                AlcMenuBar.this.nextPageItem.setEnabled(false);
                AlcMenuBar.this.previousPageItem.setEnabled(false);
                AlcMenuBar.this.unloadSessionItem.setEnabled(false);
                AlcMenuBar.this.linkSessionItem.setEnabled(false);
            }
        };
        this.unloadSessionItem = new AlcMenuItem(unloadSessionAction);
        this.unloadSessionItem.setup(unloadSessionTitle);
        sessionMenu.add(this.unloadSessionItem);
        this.unloadSessionItem.setEnabled(false);
        String linkSessionTitle = this.getS("linkSessionTitle");
        this.linkSessionItem = new AlcCheckBoxMenuItem();
        AbstractAction linkSessionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcCheckBoxMenuItem source = (AlcCheckBoxMenuItem)e.getSource();
                Alchemy.preferences.sessionLink = source.getState();
            }
        };
        this.linkSessionItem.setAction(linkSessionAction);
        this.linkSessionItem.setup(linkSessionTitle);
        this.linkSessionItem.setSelected(Alchemy.preferences.sessionLink);
        sessionMenu.add(this.linkSessionItem);
        this.linkSessionItem.setEnabled(false);
        sessionMenu.add(new JSeparator());
        String restartTitle = this.getS("restartTitle");
        AbstractAction restartAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.session.restartSession();
            }
        };
        AlcMenuItem restartItem = new AlcMenuItem(restartAction);
        restartItem.setup(restartTitle);
        sessionMenu.add(restartItem);
        this.add(sessionMenu);
        AlcMenu switchMenu = new AlcMenu(this.getS("switchTitle"));
        String switchVectorTitle = this.getS("switchVectorTitle");
        AbstractAction switchVectorAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.switchVector();
            }
        };
        AlcMenuItem switchVectorItem = new AlcMenuItem(switchVectorAction);
        int vectorKey = Alchemy.shortcuts.setShortcut(switchVectorItem, 86, "switchVectorTitle", switchVectorAction, KEY_MODIFIER);
        switchVectorItem.setup(switchVectorTitle, vectorKey);
        switchMenu.add(switchVectorItem);
        String switchBitmapTitle = this.getS("switchBitmapTitle");
        AbstractAction switchBitmapAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcMenuBar.this.switchBitmap();
            }
        };
        AlcMenuItem switchBitmapItem = new AlcMenuItem(switchBitmapAction);
        int bitmapKey = Alchemy.shortcuts.setShortcut(switchBitmapItem, 66, "switchBitmapTitle", switchBitmapAction, KEY_MODIFIER);
        switchBitmapItem.setup(switchBitmapTitle, bitmapKey);
        switchMenu.add(switchBitmapItem);
        switchMenu.add(new JSeparator());
        String setVectorApp = this.getS("setVectorApp");
        AbstractAction switchVectorAppAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File file = AlcUtil.showFileChooser(AlcMenuBar.this.platformAppDir);
                if (file != null) {
                    System.out.println(file.toString());
                    Alchemy.preferences.switchVectorApp = file.toString();
                }
            }
        };
        AlcMenuItem switchVectorAppItem = new AlcMenuItem(switchVectorAppAction);
        switchVectorAppItem.setup(setVectorApp);
        switchMenu.add(switchVectorAppItem);
        AlcMenu formatMenu = new AlcMenu(this.getS("setVectorFormat"));
        if (Alchemy.OS != 3) {
            formatMenu.setOpaque(true);
            formatMenu.setBackground(AlcToolBar.COLOR_UI_HIGHLIGHT);
        }
        ButtonGroup formatGroup = new ButtonGroup();
        AlcRadioButtonMenuItem pdfItem = new AlcRadioButtonMenuItem(Alchemy.preferences.FORMAT_PDF, "PDF");
        if (Alchemy.preferences.switchVectorFormat == Alchemy.preferences.FORMAT_PDF) {
            pdfItem.setSelected(true);
        }
        pdfItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcRadioButtonMenuItem source = (AlcRadioButtonMenuItem)e.getSource();
                Alchemy.preferences.switchVectorFormat = source.getIndex();
            }
        });
        formatGroup.add(pdfItem);
        formatMenu.add(pdfItem);
        AlcRadioButtonMenuItem svgItem = new AlcRadioButtonMenuItem(Alchemy.preferences.FORMAT_SVG, "SVG");
        if (Alchemy.preferences.switchVectorFormat == Alchemy.preferences.FORMAT_SVG) {
            svgItem.setSelected(true);
        }
        svgItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlcRadioButtonMenuItem source = (AlcRadioButtonMenuItem)e.getSource();
                Alchemy.preferences.switchVectorFormat = source.getIndex();
            }
        });
        formatGroup.add(svgItem);
        formatMenu.add(svgItem);
        formatMenu.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        switchMenu.add(formatMenu);
        String setBitmapApp = this.getS("setBitmapApp");
        AbstractAction switchBitmapAppAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File file = AlcUtil.showFileChooser(AlcMenuBar.this.platformAppDir);
                if (file != null) {
                    System.out.println(file.toString());
                    Alchemy.preferences.switchBitmapApp = file.toString();
                }
            }
        };
        AlcMenuItem switchBitmapAppItem = new AlcMenuItem(switchBitmapAppAction);
        switchBitmapAppItem.setup(setBitmapApp);
        switchMenu.add(switchBitmapAppItem);
        this.add(switchMenu);
        AlcMenu settingsMenu = new AlcMenu(this.getS("settingsTitle"));
        AbstractAction smoothingAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcCheckBoxMenuItem source = (AlcCheckBoxMenuItem)e.getSource();
                Alchemy.canvas.setSmoothing(source.getState());
                Alchemy.canvas.redraw();
            }
        };
        AlcCheckBoxMenuItem smoothingItem = new AlcCheckBoxMenuItem(smoothingAction);
        smoothingItem.setSelected(Alchemy.preferences.smoothing);
        smoothingItem.setup(this.getS("smoothingTitle"));
        settingsMenu.add(smoothingItem);
        AbstractAction lineSmoothingAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcCheckBoxMenuItem source = (AlcCheckBoxMenuItem)e.getSource();
                AlcShape.setLineSmoothing(source.getState());
            }
        };
        AlcCheckBoxMenuItem lineSmoothingItem = new AlcCheckBoxMenuItem(lineSmoothingAction);
        lineSmoothingItem.setSelected(Alchemy.preferences.lineSmoothing);
        AlcShape.setLineSmoothing(Alchemy.preferences.lineSmoothing);
        lineSmoothingItem.setup(this.getS("lineSmoothingTitle"));
        settingsMenu.add(lineSmoothingItem);
        settingsMenu.add(new JSeparator());
        AbstractAction keyboardShortcutsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Alchemy.shortcuts.showWindow();
            }
        };
        AlcMenuItem keyboardShortcutsItem = new AlcMenuItem(keyboardShortcutsAction);
        keyboardShortcutsItem.setup(this.getS("keyboardShortcutsTitle"));
        settingsMenu.add(keyboardShortcutsItem);
        if (Alchemy.OS != 2) {
            AbstractAction optionsAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Alchemy.preferences.showWindow();
                }
            };
            AlcMenuItem optionsItem = new AlcMenuItem(optionsAction);
            optionsItem.setup(this.getS("optionsTitle"));
            settingsMenu.add(optionsItem);
        }
        this.add(settingsMenu);
        AlcMenu helpMenu = new AlcMenu(this.getS("helpTitle"));
        AbstractAction helpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File manual = new File("Alchemy.pdf");
                if (manual.exists()) {
                    AlcUtil.openPDF(manual);
                } else {
                    System.err.println("Error locating the Alchemy manual");
                    String locale = AlcConstants.LOCALE.getLanguage().toLowerCase();
                    if (locale.startsWith("ja")) {
                        AlcUtil.openURL("http://al.chemy.org/ja/documentation/");
                    } else {
                        AlcUtil.openURL("http://al.chemy.org/documentation/");
                    }
                }
            }
        };
        AlcMenuItem helpItem = new AlcMenuItem(helpAction);
        helpItem.setup(this.getS("alchemyHelpTitle"));
        helpMenu.add(helpItem);
        helpMenu.add(new JSeparator());
        AbstractAction wwwAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String locale = AlcConstants.LOCALE.getLanguage().toLowerCase();
                if (locale.startsWith("ja")) {
                    AlcUtil.openURL("http://al.chemy.org/ja/");
                } else {
                    AlcUtil.openURL("http://al.chemy.org/");
                }
            }
        };
        AlcMenuItem wwwItem = new AlcMenuItem(wwwAction);
        wwwItem.setup(this.getS("alchemyWebsiteTitle"));
        helpMenu.add(wwwItem);
        AbstractAction forumAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AlcUtil.openURL("http://al.chemy.org/forum/");
            }
        };
        AlcMenuItem forumItem = new AlcMenuItem(forumAction);
        forumItem.setup(this.getS("alchemyForumTitle"));
        helpMenu.add(forumItem);
        if (Alchemy.OS != 2) {
            helpMenu.add(new JSeparator());
            AbstractAction aboutAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Alchemy.window.showAbout();
                }
            };
            AlcMenuItem aboutItem = new AlcMenuItem(aboutAction);
            aboutItem.setup(this.getS("aboutAlchemyTitle"));
            helpMenu.add(aboutItem);
        }
        this.add(helpMenu);
    }

    private String getS(String stringName) {
        return Alchemy.bundle.getString(stringName);
    }

    public int getHeight() {
        return 27;
    }

    private void print() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        if (this.page == null) {
            this.page = this.printer.defaultPage();
            this.page.setOrientation(0);
        }
        this.printer.setPrintable(Alchemy.canvas, this.page);
        if (this.printer.printDialog()) {
            try {
                this.printer.print();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private void pageSetup() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
        }
        if (this.defaultPage == null) {
            this.defaultPage = this.printer.defaultPage();
            this.defaultPage.setOrientation(0);
        } else {
            this.defaultPage = this.page;
        }
        this.page = this.printer.pageDialog(this.defaultPage);
    }

    private void export() {
        AlcFileChooser fc = new AlcFileChooser(Alchemy.preferences.exportDirectory);
        fc.setDialogTitle(Alchemy.bundle.getString("exportFileTitle"));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new ExportFileFilter("PNG"));
        fc.setFileFilter(new ExportFileFilter("JPG"));
        fc.setFileFilter(new ExportFileFilter("PDF"));
        fc.setFileFilter(new ExportFileFilter("SVG"));
        fc.setSelectedFile(new File(Alchemy.bundle.getString("defaultFileName")));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String format;
            File file = fc.getSelectedFile();
            String parent = file.getParent();
            if (parent != null) {
                Alchemy.preferences.exportDirectory = parent;
            }
            if ((format = fc.getFileFilter().getDescription()).equals("PDF")) {
                Alchemy.session.saveSinglePdf(file);
            } else if (format.equals("SVG")) {
                Alchemy.session.saveSVG(file);
            } else if (format.equals("JPG") || format.equals("PNG")) {
                if (this.exportDialog == null) {
                    this.exportDialog = new AlcExportDialog();
                }
                this.exportDialog.showWindow(file, format);
            }
        }
    }

    private void copy() {
        Alchemy.canvas.setGuide(false);
        AlcUtil.setClipboard(new AlcImageTransferable(Alchemy.canvas.renderCanvas(true)), Alchemy.window);
        Alchemy.canvas.setGuide(true);
    }

    private void switchVector() {
        try {
            if (Alchemy.preferences.switchVectorFormat == Alchemy.preferences.FORMAT_SVG) {
                File tempVector = File.createTempFile("AlchemyTempVectorFile", ".svg");
                tempVector.deleteOnExit();
                if (Alchemy.session.saveSVG(tempVector)) {
                    this.openSwitch(tempVector.toString(), Alchemy.preferences.switchVectorApp);
                } else {
                    System.out.println("Didn't save SVG");
                }
            } else {
                File tempVector = File.createTempFile("AlchemyTempVectorFile", ".pdf");
                tempVector.deleteOnExit();
                if (Alchemy.session.saveSinglePdf(tempVector)) {
                    this.openSwitch(tempVector.toString(), Alchemy.preferences.switchVectorApp);
                } else {
                    System.out.println("Didn't save PDF");
                }
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    private void switchBitmap() {
        try {
            File tempBitmap = File.createTempFile("AlchemyTempBitmapFile", ".png");
            tempBitmap.deleteOnExit();
            if (Alchemy.canvas.saveBitmap(tempBitmap)) {
                this.openSwitch(tempBitmap.toString(), Alchemy.preferences.switchBitmapApp);
            } else {
                System.out.println("Didn't save???");
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    private void openSwitch(String file, String app) {
        File path = new File(app);
        try {
            String[] commands = null;
            switch (Alchemy.OS) {
                case 2: {
                    commands = new String[]{"open", "-a", path.getName(), file};
                    break;
                }
                case 1: {
                    commands = new String[]{path.getAbsolutePath(), file};
                    break;
                }
                case 3: {
                    commands = new String[]{path.getName(), file};
                }
            }
            if (commands != null) {
                Runtime.getRuntime().exec(commands);
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    protected void paintComponent(Graphics g) {
        if (Alchemy.OS != 2) {
            super.paintComponent(g);
        }
    }
}

