/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Point;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcFileChooser
extends JFileChooser
implements AlcConstants {
    AlcFileChooser() {
    }

    AlcFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    AlcFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        Point p = AlcUtil.calculateCenter(dialog);
        dialog.setLocation(p.x, p.y);
        dialog.setResizable(false);
        return dialog;
    }

    public void approveSelection() {
        if (this.getDialogType() == 1) {
            String format = this.getFileFilter().getDescription();
            String ext = format.substring(0, 3).toLowerCase();
            File fileWithExtension = AlcUtil.addFileExtension(this.getSelectedFile(), ext);
            if (fileWithExtension.exists()) {
                String message;
                String title;
                Object[] options = new Object[2];
                if (Alchemy.OS == 2) {
                    title = "";
                    message = "<html>" + UIManager.get("OptionPane.css") + "<b>\"" + fileWithExtension.getName() + "\" " + Alchemy.bundle.getString("existsMacDialogTitle") + "</b>" + "<p>" + Alchemy.bundle.getString("existsMacDialogMessage");
                    options[0] = Alchemy.bundle.getString("replace");
                    options[1] = Alchemy.bundle.getString("cancel");
                } else {
                    title = Alchemy.bundle.getString("existsWinDialogTitle");
                    message = "\"" + fileWithExtension.getName() + "\" " + Alchemy.bundle.getString("existsWinDialogMessage");
                    options[0] = Alchemy.bundle.getString("yes");
                    options[1] = Alchemy.bundle.getString("no");
                }
                int result = JOptionPane.showOptionDialog(Alchemy.window, message, title, 0, 2, null, options, options[0]);
                if (result != 0) {
                    return;
                }
            }
            this.setSelectedFile(fileWithExtension);
        }
        super.approveSelection();
    }
}

