/*
 * Decompiled with CFR 0.152.
 */
package org.alchemy.core;

import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import org.alchemy.core.AlcConstants;
import org.alchemy.core.AlcModule;
import org.alchemy.core.AlcShortcutInterface;
import org.alchemy.core.AlcShortcuts;
import org.alchemy.core.AlcToolBar;
import org.alchemy.core.AlcUtil;
import org.alchemy.core.Alchemy;

class AlcCheckBoxMenuItem
extends JCheckBoxMenuItem
implements AlcShortcutInterface,
AlcConstants {
    private int index;
    private int moduleType = -1;
    private static int checkX = Alchemy.OS == 2 ? 6 : 4;
    private String toolTip;

    AlcCheckBoxMenuItem() {
    }

    AlcCheckBoxMenuItem(Action action) {
        this.setAction(action);
    }

    AlcCheckBoxMenuItem(String title) {
        this.setup(title, -1);
    }

    AlcCheckBoxMenuItem(String title, int accelerator) {
        this.setup(title, accelerator);
    }

    void setup(AlcModule module) {
        this.setup(module.getName(), -1);
        this.index = module.getIndex();
        this.moduleType = module.getModuleType();
        this.toolTip = module.getDescription();
        this.setToolTipText(this.toolTip);
        this.setIcon(AlcUtil.getImageIcon(module.getIconUrl()));
    }

    void setup(String title) {
        this.setup(title, -1);
    }

    void setup(String title, int accelerator) {
        this.setText(title);
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.setOpaque(true);
        if (Alchemy.OS != 3) {
            this.setBackground(AlcToolBar.COLOR_UI_HIGHLIGHT);
        }
        this.setFont(FONT_MEDIUM);
        if (accelerator > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(accelerator, KEY_MODIFIER));
        }
    }

    int getIndex() {
        return this.index;
    }

    int getModuleType() {
        return this.moduleType;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (Alchemy.OS != 3 && !Alchemy.OS_IS_VISTA && !this.getState()) {
            g.setColor(AlcToolBar.COLOR_UI_BOX);
            if (this.moduleType > 0) {
                g.drawRect(checkX, 14, 7, 7);
            } else {
                g.drawRect(checkX, 8, 7, 7);
            }
        }
    }

    public void refreshShortcut(int key, int modifier) {
        if (this.moduleType < 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(key, modifier));
        } else {
            this.setToolTipText(AlcShortcuts.getShortcutString(key, modifier, this.toolTip));
        }
    }
}

